<?php

class CHooks{

    public function __construct()

    {
        add_action('c_type_tag',array($this,'get_type_tag'),1);

        add_action('c_content_footer',array($this,'content_footer'));

        add_action('c_related',array($this,'related_post'));

        add_filter( 'excerpt_length', array($this,'wpdocs_custom_excerpt_length'), 999 );

        add_filter('excerpt_more', array($this,'new_excerpt_more'));
        add_filter('get_type_tag_f', array($this,'get_type_tag_f'));

        add_shortcode('HitPosts',array($this,'hit_posts'));

        add_shortcode('slider',array($this,'slider'));

        add_image_size( 'owls', 350, 350, true ); // 220 pixels wide by 180 pixels tall, hard crop mode

    }
    
    public function to_fa($string){
        $persian_num = array('۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹');
        $latin_num = range(0, 9);

        $string = str_replace($latin_num, $persian_num, $string);

        return $string;
    }

    public function get_type_tag_f(){

        $obj = get_post_type( get_the_ID() );

        switch ($obj){

            case 'post':

                $p = 'اخبار';

                break;

            case 'video':

                $p = 'ویدیو';

                break;

            case 'picture':

                $p = 'عکس';

                break;

            case 'movie':

                $p = 'معرفی فیلم';

                break;            
            case 'theater':

                $p = 'معرفی تئاتر';

                break;


        }

        return '<span class="card-title text_small card_notic">'.$p.'</span>';


    }

    public function get_type_tag(){

        $obj = get_post_type( get_the_ID() );

        switch ($obj){

            case 'post':

                $p = 'اخبار';

                break;

            case 'video':

                $p = 'ویدیو';

                break;

            case 'picture':

                $p = 'عکس';

                break;

            case 'movie':

                $p = 'معرفی فیلم';

                break;
            case 'theater':

                $p = 'معرفی تئاتر';

                break;

        }

        ?>

        <span class="card-title text_small card_notic"><?php echo $p?></span>

        <?php

    }



    public function content_footer(){

        ?>

        <div class="chip">

            <i class="small material-icons">date_range</i>

            <span dir="rtl"><?php echo $this->to_fa(get_the_date('Y/m/d'));?></span>

        </div>

        <div class="chip">

            <i class="small material-icons">person_pin</i>

            <?php echo get_the_author(); ?>

        </div>

        <div class="chip">

            <i class="small material-icons">question_answer</i>

            <?php comments_number( 'بدون دیدگاه', 'یک دیدگاه' ); ?>

        </div>
        <?php 
        $obj = get_post_type( get_the_ID() );
        if($obj == "post"){?>
                <div class="chip">

            <i class="small material-icons">dns</i>

            <?php the_category( ' &bull; ' ); ?>

        </div>
        <?php } ?>

        <div class="col">

            <!-- Dropdown Trigger -->

            <a class='dropdown-button waves-effect waves-teal btn-flat tooltipped' data-position="right" data-delay="50" data-tooltip="اشتراک گذاری" href='#' data-activates='dropdown1'><i class="small material-icons">share</i></a>

            <!-- Dropdown Structure -->

            <ul id='dropdown1' class='dropdown-content do_rtl'>

                <li><a class="center" href="https://www.facebook.com/sharer.php?u=<?php the_permalink()?>">فیسبوک</a></li>
                <li><a class="center" href="https://twitter.com/intent/tweet?url=<?php the_permalink()?>&text=<?php the_title(); ?>&via=<?php echo bloginfo('site');?>&hashtags=<?php echo bloginfo('site');?>">توئیتر</a></li>
                <li><a class="center" href="https://telegram.me/share/url?url=<?php the_permalink()?>&text=<?php the_title(); ?>">تلگرام</a></li>
                <li><a class="center" href="https://www.linkedin.com/shareArticle?url=<?php the_permalink()?>&title=<?php the_title(); ?>">لینکدن</a></li>
                <li><a class="center" href="https://plus.google.com/share?url=<?php the_permalink()?>">گوگل +</a></li>
                <li><a class="center" href="http://pinterest.com/pin/create/button/?url=<?php the_permalink()?>&description=<?php the_title(); ?>">پینترست</a></li>
                <li><a class="center" href="https://reddit.com/submit?url=<?php the_permalink()?>&title=<?php the_title(); ?>">رددیت</a></li>

            </ul>

        </div>

        <?php

    }



    public function related_post(){

        $obj = get_post_type( get_the_ID() );

        switch ($obj){

            case 'post':

                $p = 'اخبار';

                break;

            case 'video':

                $p = 'ویدیو';

                break;

            case 'picture':

                $p = 'عکس';

                break;

            case 'movie':

                $p = 'فیلم';

                break;
            case 'theater':

                $p = 'معرفی تئاتر';

            break;

        }

        ?>

        <div class="row related_row z-depth-2">

            <h5>

                <i data-base="<?php echo $obj;?>" data-name="اخبار" data-id="<?php echo  get_the_id();?>" data-post="post" class="small material-icons left tooltipped set_up_rel" onclick="related_posts(this)" data-position="top" data-delay="50" data-tooltip="اخبار">chat</i>

                <i data-base="<?php echo $obj;?>" data-name="معرفی فیلم ها" data-id="<?php echo  get_the_id();?>" data-post="movie" class="small material-icons left tooltipped set_up_rel" onclick="related_posts(this)" data-position="top" data-delay="50" data-tooltip="معرفی فیلم">movie</i>

                <i data-base="<?php echo $obj;?>" data-name="تصاویر" data-id="<?php echo  get_the_id();?>" data-post="picture" class="small material-icons left tooltipped set_up_rel" onclick="related_posts(this)" data-position="top" data-delay="50" data-tooltip="تصاویر">insert_photo</i>

                <i data-base="<?php echo $obj;?>" data-name="ویدیو" data-id="<?php echo  get_the_id();?>" data-post="video" class="small material-icons left tooltipped set_up_rel" onclick="related_posts(this)" data-position="top" data-delay="50" data-tooltip="ویدیو ها">live_tv</i>
                
                <i data-base="<?php echo $obj;?>" data-name="معرفی تداتر" data-id="<?php echo  get_the_id();?>" data-post="theater" class="small material-icons left tooltipped set_up_rel" onclick="related_posts(this)" data-position="top" data-delay="50" data-tooltip="معرفی تئاتر">dashboard</i>

                <b>شاید این <?php echo "<b id='post_name'>".$p."</b>";?> را هم بپسندید</b>

            </h5>

            <hr>

            <div id="has_rel">





                <div class="owl-carousel owl-theme" id="owl_related_slider">

                    <?php

                    if ($obj == "post"){

                        $tags = wp_get_post_tags(get_the_ID());

                        $first_tag = $tags[0]->term_id;
                        $custom_taxterms = wp_get_object_terms( get_the_ID(), 'category', array('fields' => 'ids') );
                        $args = array(

                            'tax_query' => array(

                                array(

                                    'taxonomy' => 'category',

                                    'field' => 'id',

                                    'terms' => $custom_taxterms

                                )

                            ),

                            'post__not_in' => array(get_the_ID()),

                            'posts_per_page' => 12,

                            'caller_get_posts' => 1

                        );

                    }else{

                        $custom_taxterms = wp_get_object_terms( get_the_ID(), $obj.'-category', array('fields' => 'ids') );

                        $args = array(

                            'post_type' => $obj,

                            'post_status' => 'publish',

                            'posts_per_page' => 10, // you may edit this number

                            'orderby' => 'rand',

                            'tax_query' => array(

                                array(

                                    'taxonomy' => $obj.'-category',

                                    'field' => 'id',

                                    'terms' => $custom_taxterms

                                )

                            ),

                            'post__not_in' => array (get_the_ID()),

                        );

                    }



                    $my_query = new WP_Query($args);

                    if ($my_query->have_posts()) {

                        while ($my_query->have_posts()) : $my_query->the_post(); ?>

                            <a href="<?php the_permalink() ?>"><div class="col m12 no-padding slide_block tooltipped" data-position="bottom" data-delay="50" data-tooltip="<?php the_title(); ?>"><img class="responsive-img" src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'thumbnail'); ?>"></div></a>

                            <?php

                        endwhile;

                    }

                    wp_reset_query();

                    ?>

                </div>

            </div>

        </div>

                <div class="row">

                    <?php if ( is_active_sidebar( 'home_bottom_ads' ) ) : ?>

                        <?php dynamic_sidebar( 'home_bottom_ads' ); ?>

                    <?php endif; ?>

                </div>

        <?php

    }



    public function hit_posts(){

        ob_start();

        ?>

        <div class="col s12">

            <ul class="tabs no-padding custom_tabs">

                <li class="tab"><a href="#test1">سینمای ایران</a></li>

                <li class="tab"><a class="active" href="#test2">سینمای جهان</a></li>

                <li class="tab"><a href="#test4">اخبار ویژه</a></li>

            </ul>

        </div>

        <div id="test1" class="col s12 content_custom_tabs">

            <ul class="collection">

                <?php

                $wpb_all_query = new WP_Query(array('post_type'=>'post', 'post_status'=>'publish', 'posts_per_page'=>-1)); ?>



                <?php if ( $wpb_all_query->have_posts() ) : ?>

                    <!-- the loop -->

                    <?php while ( $wpb_all_query->have_posts() ) : $wpb_all_query->the_post(); ?>

                        <li class="collection-item"><a title="<?php the_title(); ?>" href="<?php echo get_the_permalink(); ?>"><?php the_title(); ?></a></li>

                    <?php endwhile; ?>

                    <!-- end of the loop -->

                    <?php wp_reset_postdata(); ?>



                <?php else : ?>

                    <li><?php _e( 'مطلبی یافت نشد' ); ?></li>

                <?php endif; ?>

            </ul>

        </div>

        <div id="test2" class="col s12 content_custom_tabs">

            <ul class="collection">

                <?php

                $wpb_all_query = new WP_Query(array('post_type'=>'post', 'post_status'=>'publish', 'posts_per_page'=>-1)); ?>



                <?php if ( $wpb_all_query->have_posts() ) : ?>

                    <!-- the loop -->

                    <?php while ( $wpb_all_query->have_posts() ) : $wpb_all_query->the_post(); ?>

                        <li class="collection-item"><a title="<?php the_title(); ?>" href="<?php echo get_the_permalink(); ?>"><?php the_title(); ?></a></li>

                    <?php endwhile; ?>

                    <!-- end of the loop -->

                    <?php wp_reset_postdata(); ?>



                <?php else : ?>

                    <li><?php _e( 'مطلبی یافت نشد' ); ?></li>

                <?php endif; ?>

            </ul>

        </div>

        <div id="test4" class="col s12 content_custom_tabs">

            <ul class="collection">

                <?php

                $wpb_all_query = new WP_Query(array('post_type'=>'post', 'post_status'=>'publish', 'posts_per_page'=>-1)); ?>



                <?php if ( $wpb_all_query->have_posts() ) : ?>

                    <!-- the loop -->

                    <?php while ( $wpb_all_query->have_posts() ) : $wpb_all_query->the_post(); ?>

                        <li class="collection-item"><a title="<?php the_title(); ?>" href="<?php echo get_the_permalink(); ?>"><?php the_title(); ?></a></li>

                    <?php endwhile; ?>

                    <!-- end of the loop -->

                    <?php wp_reset_postdata(); ?>



                <?php else : ?>

                    <li><?php _e( 'مطلبی یافت نشد' ); ?></li>

                <?php endif; ?>

            </ul>

        </div>

        <?php

        return ob_get_clean();

    }



    public function slider(){

        ob_start();

        ?>

        <div class="owl-carousel owl-theme" id="owl_top_slider">

            <div class="col m12 no-padding slide_block">

                <img class="responsive-img" src="<?php echo get_template_directory_uri();?>/assets/img/1.jpg">

                <div class="slide_title">عنوان جهش یافته</div>

            </div>

            <div class="col m12 no-padding slide_block">

                <img class="responsive-img" src="<?php echo get_template_directory_uri();?>/assets/img/2.jpg">

                <div class="slide_title">عنوان جهش یافته</div>

            </div>

            <div class="col m12 no-padding slide_block">

                <img class="responsive-img" src="<?php echo get_template_directory_uri();?>/assets/img/3.jpg">

                <div class="slide_title">عنوان جهش یافته</div>

            </div>

        </div>

        <?php

        return ob_get_clean();

    }



    public function slider_js(){

        ?>

        <script>

            jQuery('#owl_top_slider,#owl_bottom_slider,#owl_middle_slider').owlCarousel({

                items:3,

                responsiveClass:true,

                responsive:{

                    0:{

                        items:1,

                        nav:true

                    },

                    600:{

                        items:1,

                        nav:false

                    },

                    1000:{

                        items:3,

                        nav:true,

                        loop:false

                    }

                }

            });

        </script>

        <?php

    }



    public function wpdocs_custom_excerpt_length( $length ) {

        return 40;

    }

    public function new_excerpt_more( $more ) {

        return '...';

    }





}



new CHooks();

?>