<?php
function custom_registration_function() {
    if (isset($_POST['username'])) {
        registration_validation(
        $_POST['username'],
        $_POST['password'],
        $_POST['email'],
        $_POST['website'],
        $_POST['fname'],
        $_POST['lname'],
        $_POST['nickname'],
        $_POST['bio']
		);
		
		// sanitize user form input
        global $username, $password, $email, $website, $first_name, $last_name, $nickname, $bio;
        $username	= 	sanitize_user($_POST['username']);
        $password 	= 	esc_attr($_POST['password']);
        $email 		= 	sanitize_email($_POST['email']);
        $website 	= 	esc_url($_POST['website']);
        $first_name = 	sanitize_text_field($_POST['fname']);
        $last_name 	= 	sanitize_text_field($_POST['lname']);
        $nickname 	= 	sanitize_text_field($_POST['nickname']);
        $bio 		= 	esc_textarea($_POST['bio']);

		// call @function complete_registration to create the user
		// only when no WP_error is found
        complete_registration(
        $username,
        $password,
        $email,
        $website,
        $first_name,
        $last_name,
        $nickname,
        $bio
		);
    }

    registration_form(
    	$username,
        $password,
        $email,
        $website,
        $first_name,
        $last_name,
        $nickname,
        $code,
        $bio
		);
}

function registration_form( $username, $password, $email, $website, $first_name, $last_name, $nickname, $bio ,$code ) {
    echo '
    <form id="reg_form" action="' . $_SERVER['REQUEST_URI'] . '" method="post">
	<div>
	<label for="username">نام کاربری <strong>*</strong></label>
	<input type="text" name="username" value="' . (isset($_POST['username']) ? $username : null) . '">
	</div>
	
	<div>
	<label for="password">رمز عبور <strong>*</strong></label>
	<input type="password" name="password" value="' . (isset($_POST['password']) ? $password : null) . '">
	</div>
	
	<div>
	<label for="email">ادرس ایمیلتان <strong>*</strong></label>
	<input type="text" name="email" value="' . (isset($_POST['email']) ? $email : null) . '">
	</div>
	
	<div>
	<label for="firstname">نام شما</label>
	<input type="text" name="fname" value="' . (isset($_POST['fname']) ? $first_name : null) . '">
	</div>
	
	<div>
	<label for="website">نام خانوادگی شما</label>
	<input type="text" name="lname" value="' . (isset($_POST['lname']) ? $last_name : null) . '">
	</div>

	<div>
	<label for="code_reg">سوال امنیتی</label>
	<input type="text" id="code_reg">
	</div>
	
	<button style="padding: 5px 10px;line-height: 35px;" dir="ltr" align="left" id="wp-submit" onclick="code_regs(this,event)" type="button">عضویت در سایت</button>
	</form>
	';
    echo '<script type="text/javascript">
        var code_reg = document.getElementById("code_reg");
        var a = "";
        var b = "";
        a += Math.floor(Math.random()*20);
        b += Math.floor(Math.random()*30);
        code_reg.setAttribute("placeholder",a+" + "+b+" = ? ");
        function code_regs(obj,event){
            event.preventDefault();
            var c = parseInt(a) + parseInt(b);
            var code_reg = document.getElementById("code_reg");
            if(parseInt(code_reg.value) === c && code_reg.value !== ""){
                    document.getElementById("reg_form").submit();
            }else{
                 //e.preventdefault();
                alert("خطا : کد امنیتی نادرست است");
                return false;
            }
        }
    </script>';
}

function registration_validation( $username, $password, $email, $website, $first_name, $last_name, $nickname, $bio )  {
    global $reg_errors;
    $reg_errors = new WP_Error;

    if ( empty( $username ) || empty( $password ) || empty( $email ) ) {
        $reg_errors->add('field', 'فیلد های ضروری باید پرشوند');
    }

    if ( strlen( $username ) < 4 ) {
        $reg_errors->add('username_length', 'نام کاربری بسیار کوتاه است حداقل مجاز 4 کارکتر میباشد');
    }

    if ( username_exists( $username ) )
        $reg_errors->add('user_name', 'متاسفانه نام کاربری انتخابی شما قبلا انتخاب شده است');

    if ( !validate_username( $username ) ) {
        $reg_errors->add('username_invalid', 'نام کاربری وارد شده نام معتبر میباشد');
    }

    if ( strlen( $password ) < 5 ) {
        $reg_errors->add('password', 'تعداد حروف رمز عبور باید بزرگتر از 5 باشد');
    }

    if ( !is_email( $email ) ) {
        $reg_errors->add('email_invalid', 'ادرس ایمیل نامعتبر است');
    }

    if ( email_exists( $email ) ) {
        $reg_errors->add('email', 'این ایمیل هم اکنون مورد استفاده است');
    }


    if ( is_wp_error( $reg_errors ) ) {

        foreach ( $reg_errors->get_error_messages() as $error ) {
            echo '<div>';
            echo '<strong> خطا </strong>:';
            echo $error . '<br/>';
            echo '</div>';
            add_action('wp_footer','open_register_modal',100);
        }
    }
}

function open_register_modal(){
    ?>
    <script>
    jQuery(document).ready(function(){
        jQuery('#register_modal1').modal('open');
    });
    </script>
    <?php
}

function complete_registration() {
    global $reg_errors, $username, $password, $email, $website, $first_name, $last_name, $nickname, $bio;
    if ( count($reg_errors->get_error_messages()) < 1 ) {
        $userdata = array(
        'user_login'	=> 	$username,
        'user_email' 	=> 	$email,
        'user_pass' 	=> 	$password,
        'user_url' 		=> 	$website,
        'first_name' 	=> 	$first_name,
        'last_name' 	=> 	$last_name,
        'nickname' 		=> 	$nickname,
        'description' 	=> 	$bio,
		);
        $user = wp_insert_user( $userdata );
        echo 'عضویت با موفقیت انجام پذیرفت حالا میتوانید وارد شوید <a href="' . get_site_url() . '/wp-login.php">برای ورود کلیک کنید</a>.';
        echo '<style>#reg_form{display:none;}</style>';
        add_action('wp_footer','open_register_modal',100);
	}
}

// Register a new shortcode: [cr_custom_registration]
add_shortcode('cr_custom_registration', 'custom_registration_shortcode');

// The callback function that will replace [book]
function custom_registration_shortcode() {
    ob_start();
    custom_registration_function();
    return ob_get_clean();
}
