<?php
$section_title = get_field('mag_title', 'option');
$section_subtitle = get_field('mag_subtitle', 'option');
?>
<section class="magazine py-96" id="magazine">
    <div class="container-lg">
        <div class="row">
            <div class="col-12 text-center section-head">
                <?php if ($section_title) {
                    echo '<h2 class="section-title">' . $section_title . '</h2>';
                } ?>
                <?php if ($section_subtitle) {
                    echo '<span class="d-block subtitle">' . $section_subtitle . '</span>';
                } ?>
            </div>
        </div>
        <div class="row magazine-row">
            <?php
            $args = array(
                'post_type' => 'post',
                'posts_per_page' => '4',
                'meta_query' => array(
                    array(
                        'key' => 'is_show',
                        'compare' => '=',
                        'value' => '1'
                    )
                )
            );
            $query = new WP_Query($args);
            if ($query->have_posts()):
                $i = 0.25;
                while ($query->have_posts()) : $query->the_post();
                    echo '<div class="col-9 col-sm-6 col-lg-3 mb-4 wow fadeInUp" data-wow-delay="' . $i . 's">';
                        echo get_template_part('templates/card/blog', 'card');
                    echo '</div>';
                $i += 0.25; endwhile;
            endif;
            ?>
        </div>
    </div>
</section>
