<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta content="telephone=no" name="format-detection">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    <?php $fav = get_field('fav', 'option'); 
    if( !empty($fav) ): 
    ?>
    <link rel="shortcut icon" type="image/png" href="<?php echo esc_url( $fav ); ?>" />
    <?php endif;
    wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<header  class="site-header" id="site-header">
   <div class="container-lg">
        <div class="row align-items-center position-relative">
            <nav class="col-9 col-lg-9">
                <div class="mobile-menu-btn d-inline-flex d-md-none">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/menu.svg" width="24" height="24" alt="menu" />
                </div>
                <div class="logo-wrap d-inline-flex">
                    <?php
                        /* logo */
                        $logo = get_field('logo' ,'options');
                        if ($logo) {
                            echo '<a class="logo-header" href="' . get_bloginfo('url') . '" >';
                            echo '<img src="' . $logo['url'] . '" width="' . $logo['width'] . '" height="' . $logo['height'] . '" alt="' . $logo['alt'] . '" />';
                            echo '</a>';
                        }
                    ?>
                </div>
                <?php
                    if (has_nav_menu('main')) {
                        $defaults = array(
                            'theme_location' => 'main',
                            'container' => '',
                            'menu_class' => 'main-menu d-none d-md-inline-flex',
                            'echo' => true,
                            'fallback_cb' => 'wp_page_menu',
                            'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                            'depth' => 3,
                            'walker' => new wp_bootstrap_navwalker()
                        );
                        wp_nav_menu($defaults);
                    }
                ?>
            </nav>
            <div class="col-3 col-lg-3 header-search-wrapper">
                <button class="mobile-search border-0 bg-transparent d-block d-md-none"><i class="icon-search"></i></button>
                <form class="header-search d-md-block" role="search" method="get" action="<?php echo home_url('/'); ?>">
                    <div class="position-relative">
                        <input class="form-control bg-transparent" placeholder="جستجو" type="text" name="s" id="woocommerce-product-search-field-0" value="<?php the_search_query(); ?>">
                        <span class="icon-holder position-absolute"><i class="icon-search"></i></span>
                        <input type="hidden" name="post_type" value="product" />
                    </div>
                </form>
            </div>
        </div>
   </div>
</header>

<main class="main-content">
<?php if (!is_home() && !is_front_page()) { get_template_part('templates/content/breadcrumb'); } ?>
