@component('backend.layouts.components.main',['title' => 'مدیریت کاربران', 'titleBar'=>true , 'button' => 'افزودن کاربر' , 'route' => 'admin.users.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">کاربران</li>


    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست کاربران</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>آیدی</th>
                            <th>نام</th>
                            <th>موبایل</th>
                            <th>نقش</th>
                            <th>تاریخ ثبت نام</th>
                            @can('manage-users')
                                <th>عملیات</th>
                            @endcan
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($users as $user)

                            <tr>
                                <td>{{$user->id}}</td>
                                <td>{{$user->name}}</td>
                                <td>{{$user->phone}}</td>
                                <td>
                                    @foreach($user->roles as $role)
                                        <div class="d-flex align-items-center">
                                            <i class="fa fa-circle text-warning ml-1"></i>
                                            {{$role->label}}
                                        </div>
                                    @endforeach
                                </td>
                                <td>{{\Hekmatinasser\Verta\Verta::instance($user->created_at)->formatJalaliDate()}}</td>

                                <td>
                                    <form action="{{route('admin.users.destroy', $user->id)}}" method="post"
                                          id="delete-{{$user->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    @can('manage-users')
                                        <a href="{{route('admin.users.edit', $user->id)}}" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-{{$user->id}}').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-{{$user->id}}').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    @endcan
                                </td>

                            </tr>

                        @endforeach
                        </tbody>
                    </table>

                </div>
                {{$users->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
