<?php

namespace Modules\ProductReview\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\ProductReview\Entities\ProductReview;

class ProductReviewController extends Controller
{
    use SEOTools;

    public function __construct()
    {
        $this->middleware('can:manage-product-reviews');
    }
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {

        $this->seo()->setTitle('همه نظرات');

        $reviews = ProductReview::query();
        if ($key = \request('search')) {
            $reviews = $reviews->where('username', 'like', "%$key%");
        }
        $reviews = $reviews->latest()->simplePaginate(15);
        return view('productreview::backend.all', compact('reviews'));
    }

    public function status(Request $request, ProductReview $productReview)
    {
        if ($productReview->status == 0){
            $productReview->update([
                'status' => 1
            ]);
        }else{
            $productReview->update([
                'status' => 0
            ]);
        }
        alert()->success('عملیات با موفقیت انجام شد.');
        return back();
    }

    public function destroy(ProductReview $productReview)
    {
        $productReview->delete();
        alert()->success('عملیات با موفقیت انجام شد');
        return back();
    }

}
