@component('backend.layouts.components.main',['title' => 'مدیریت قیمت های ثابت', 'titleBar'=>true , 'button' => 'افزودن قیمت جدید' , 'route' => 'admin.prices.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">قیمت های ثابت</li>
    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست قیمت های ثابت</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>نام</th>
                            <th>نوع</th>
                            <th>قیمت</th>
                            @can('manage-prices')
                                <th>عملیات</th>
                            @endcan
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($prices as $price)

                            <tr>
                                <td>{{$price->label}}</td>
                                <td>
                                    @switch($price->type)
                                        @case('pin')
                                        پین
                                        @break
                                    @endswitch
                                </td>
                                <td>{{number_format($price->price)}}
                                تومان
                                </td>
                                <td>
                                    <form action="{{route('admin.prices.destroy', $price->id)}}" method="post"
                                          id="delete-{{$price->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    @can('manage-prices')
                                        <a href="{{route('admin.prices.edit', $price->id)}}" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-{{$price->id}}').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-{{$price->id}}').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    @endcan
                                </td>

                            </tr>

                        @endforeach
                        </tbody>
                    </table>

                </div>
                {{$prices->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
