<?php

namespace Modules\Price\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Price\Entities\Price;

class PriceController extends Controller
{
    use SEOTools;

    public function __construct()
    {
        $this->middleware('can:manage-products');
    }
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $this->seo()->setTitle('همه محصولات');

        $prices = Price::query();
        if ($key = \request('search')) {
            $prices = $prices->where('label', 'like', "%$key%");
        }
        $prices = $prices->latest()->simplePaginate(15);
        return view('price::backend.all', compact('prices'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $this->seo()->setTitle('ایجاد جدید');
        return view('price::backend.create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        $validData = $request->validate([
           'label' => 'required',
           'type' => 'required',
           'price' => 'required',
        ]);
        Price::create($validData);
        alert()->success('موفق' , 'عملیات با موفقیت انجام شد');
        return back();

    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('price::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit(Price $price)
    {
        $this->seo()->setTitle("ویرایش $price->label");
        return view('price::backend.edit', compact('price'));
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, Price $price)
    {
        $validData = $request->validate([
            'label' => 'required',
            'type' => 'required',
            'price' => 'required',
        ]);

        $price->update($validData);

        foreach ($price->products as $product) {
            $product->update([
                'price' => $product->pin_count * $price->price
            ]);
        }
        alert()->success('موفق' , 'عملیات با موفقیت انجام شد');
        return back();
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy(Price $price)
    {
        $price->delete();
        alert()->success('حذف شد.');
        return back();
    }
}
