<?php

namespace Modules\Payment\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Modules\Order\Entities\Order;

class Payment extends Model
{
    use HasFactory;
    use Notifiable;
    protected $fillable = ['status' , 'resnumber' , 'is_admin_notified' , 'is_user_notified'];

    public function order()
    {
        return $this->belongsTo(Order::class);
    }
}
