<?php

namespace Modules\LoginWithCode\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Modules\LoginWithCode\Notifications\channels\SmsPanel;

class ActiveCodeNotification extends Notification
{
    use Queueable;

    public $code;

    public $phone;


    public function __construct($code , $phone)
    {
        $this->code = $code;
        $this->phone = $phone;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return [SmsPanel::class];
    }

    public function toSmsPanel($notifiable)
    {
        return [
            'text' => "کد احرازهویت {$this->code} \n کاراوب",
            'phone' => $this->phone,
            'code' => $this->code
        ];
    }
}
