<?php
// دریافت داده‌های پرداخت از URL
$status = isset($_GET['status']) ? $_GET['status'] : '';
$id     = isset($_GET['id']) ? intval($_GET['id']) : 0;
$amount = isset($_GET['amount']) ? intval($_GET['amount']) : 0;
$ref_id = isset($_GET['ref_id']) ? htmlspecialchars($_GET['ref_id']) : '';
$msg    = isset($_GET['msg']) ? htmlspecialchars($_GET['msg']) : '';

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="utf-8">
    <title>نتیجه پرداخت</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap RTL -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <style>
        body { font-family: 'Tahoma', 'Vazir', sans-serif; background: #f9f9f9; }
        .container { max-width: 500px; margin-top: 40px; }
    </style>
</head>
<body>
<div class="container shadow rounded bg-white p-4 mt-5">

<?php if ($status === "success"): ?>
    <h3 class="text-success mb-3">پرداخت موفق!</h3>
    <ul class="list-group mb-3">
      <li class="list-group-item">مبلغ واریز شده: <b><?=number_format($amount)?> ریال</b></li>
      <li class="list-group-item">شماره تراکنش : <b><?=$ref_id ? $ref_id : 'ندارد'?></b></li>
    </ul>
<?php elseif ($status === "error"): ?>
    <h3 class="text-danger mb-3">پرداخت ناموفق!</h3>
    <div class="alert alert-danger">دلیل: <?=$msg?></div>
    <ul class="list-group mb-3">
        <?php if ($amount): ?>
          <li class="list-group-item">مبلغ: <b><?=number_format($amount)?> ریال</b></li>
        <?php endif; ?>
        <?php if ($id): ?>
        <?php endif; ?>
    </ul>
<?php else: ?>
    <h3 class="mb-3">اطلاعات تراکنش نامعتبر است.</h3>
<?php endif; ?>
<div class="alert alert-primary" role="alert">
در صورتی که پرداختی داشتید برای دریافت سرویس لطفا از پشتیبانی گوشه سایت به ما اطلاع بدید  
</div>


<a href="https://www.goftino.com/c/kHuPi0" target="_blank" class="btn btn-primary btn-lg">پشتیبانی آنلاین</a>
<a href="https://t.me/prox_net"   target="_blank" class="btn btn-secondary btn-lg">پشتیبانی تلگرام</a>


</div>




<script type="text/javascript">
(function() {
  var encodedUrl = "aHR0cHM6Ly93d3cuZ29mdGluby5jb20vd2lkZ2V0Lw=="; 
  var encodedId  = "a0h1UGkw";

  var baseUrl = atob(encodedUrl);
  var goftinoId = atob(encodedId);

  var w = window, d = document;

  function loadGoftino() {
    var script = d.createElement("script");
    var localKey = localStorage.getItem("goftino_" + goftinoId);
    script.async = true;
    script.src = localKey ? baseUrl + goftinoId + "?o=" + localKey : baseUrl + goftinoId;
    d.getElementsByTagName("head")[0].appendChild(script);
  }

  if (d.readyState === "complete") {
    loadGoftino();
  } else if (w.attachEvent) {
    w.attachEvent("onload", loadGoftino);
  } else {
    w.addEventListener("load", loadGoftino, false);
  }
})();
</script>


</body>
</html>
