<?php
// آی‌پی آدرس‌هایی که می‌خواهید بررسی کنید
$ip_addresses = ['113.30.151.182', '113.30.151.182']; // این‌ها فقط مثال هستند

// نتایج بررسی را برای هر آی‌پی آدرس نشان دهید
foreach ($ip_addresses as $ip_address) {
    // تنظیمات cURL
    $ch = curl_init("https://check-host.net/check-tcp?host=$ip_address&max_nodes=3");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json'));

    // اجرای درخواست و گرفتن نتایج
    $response = curl_exec($ch);
    curl_close($ch);

    // بررسی اینکه آیا درخواست با موفقیت انجام شد
    if ($response === false) {
        echo "Failed to check the host for IP: $ip_address\n";
        continue; // نادیده گرفتن این آی‌پی و ادامه با آی‌پی بعدی
    }

    // تجزیه پاسخ JSON
    $results = json_decode($response, true);

    // بررسی کاربردی نتایج برای هر نود
    if (isset($results['nodes']) && is_array($results['nodes'])) {
        foreach ($results['nodes'] as $node => $node_info) {
            if (empty($node_info)) {
                echo "No information for the node $node of IP: $ip_address\n";
                continue;
            }
            
            // دریافت نتیجه بررسی
            $node_result = $results[$node];

            if (isset($node_result[0]['error'])) {
                echo "IP: $ip_address via node $node - Connection timed out\n";
            } elseif (isset($node_result[0]['time'])) {
                echo "IP: $ip_address via node $node - Connected\n";
            } else {
                echo "IP: $ip_address via node $node - No specific result\n";
            }
        }
    } else {
        echo "Failed to retrieve results for IP: $ip_address\n";
    }
}

?>