<?php
session_start();

// تولید اعداد تصادفی برای CAPTCHA
$num1 = rand(1, 9);
$num2 = rand(1, 9);
$correctCaptcha = $num1 + $num2;
$_SESSION['captcha'] = $correctCaptcha;

// تنظیمات تصویر
header('Content-Type: image/png');
$image = imagecreatetruecolor(100, 40);

// رنگ‌ها
$bgColor = imagecolorallocate($image, 255, 255, 255); // سفید
$textColor = imagecolorallocate($image, 0, 0, 255); // آبی
$noiseColor = imagecolorallocate($image, 255, 0, 0); // قرمز

// پر کردن پس‌زمینه
imagefilledrectangle($image, 0, 0, 100, 40, $bgColor);

// افزودن نویز
for ($i = 0; $i < 50; $i++) {
    imagesetpixel($image, rand(0, 100), rand(0, 40), $noiseColor);
}

// افزودن خطوط عمودی قرمز با طول بیشتر
// تغییر موقعیت خط اول به سمت چپ و افزایش اندازه آن
$lineXPos = [15, 50]; // خط اول به 15 تغییر کرده است

foreach ($lineXPos as $x) {
    // تغییر طول خط اول به 25 پیکسل
    if ($x === 15) {
        imageline($image, $x, 10, $x, 35, $noiseColor); // خط اول
    } else {
        imageline($image, $x, 15, $x, 25, $noiseColor); // خط دوم
    }
}

// افزودن متن CAPTCHA
$font = 5;
$captchaText = "$num1 + $num2 = ?";
imagestring($image, $font, 10, 10, $captchaText, $textColor);

// خروجی تصویر
imagepng($image);
imagedestroy($image);
?>
