<?php

// http://localhost/110.php?ip=90.10.32.1


date_default_timezone_set('Asia/Tehran');
// Fetch the IP from the URL parameter
$ip = $_GET['ip']; 

// Define the URL for the request
$url = "https://check-host.net/ip-info?host=" . $ip;

// Initialize cURL to fetch the webpage content
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$htmlContent = curl_exec($ch);
curl_close($ch);

// Check if the content was successfully fetched
if ($htmlContent === FALSE) {
    echo json_encode([
        'error' => 'Failed to fetch data'
    ]);
    exit;
}

// Regular expression to match <tr> tags containing country information
$pattern = '/<tr>\s*<td>Country<\/td>\s*<td class="break-words">.*?<strong>(.*?)<\/strong>(.*?)<\/td>\s*<\/tr>/is';

// Search for all matches for countries
preg_match_all($pattern, $htmlContent, $matches);

// Check if any countries were found
if (count($matches[1]) > 0) {
    $countries = [];

    // Loop through the matches and extract country information
    foreach ($matches[1] as $key => $countryName) {
        // Remove parentheses and extract the country code
        preg_match('/\((.*?)\)/', $matches[2][$key], $countryCodeMatch);
        
        if (isset($countryCodeMatch[1])) {
            $countryCode = $countryCodeMatch[1]; // Extract country code
            // Add the country and its code to the array
            $countries[] = [
                'country' => $countryName,
                'code' => $countryCode
            ];
        }
    }

    // Count the occurrences of each country code
    $codeCounts = array_count_values(array_column($countries, 'code'));

    // Sort the codes in descending order to find the most common country code
    arsort($codeCounts); // Sort by frequency
    $majorityCode = key($codeCounts); // Get the most frequent country code

    // Add the majority country code to the output
    $countries[] = [
        'Majority' => $majorityCode
    ];

    // Output the result as a JSON response
    echo json_encode($countries, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
} else {
    // In case no countries were found
    echo json_encode([
        'error' => 'No countries found'
    ]);
}

?>
