<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>ورود و ذخیره کوکی‌ها</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container mt-5">
    <div class="card shadow">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">📦 وارد کردن JSON کوکی‌ها (PEC)</h5>
        </div>
        <div class="card-body">

            <form method="post">
                <div class="mb-3">
                    <label for="jsonInput" class="form-label">JSON کوکی‌ها را وارد کنید:</label>
                    <textarea name="jsonInput" id="jsonInput" rows="12" class="form-control"
                              placeholder='[
    {
        "name": "__RequestVerificationToken",
        "value": "abc123",
        "domain": "topup.pec.ir"
    }
]'></textarea>
                </div>

                <button type="submit" class="btn btn-success">تبدیل و ذخیره</button>
            </form>

            <?php
            if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                $input = trim($_POST['jsonInput']);
                $filename = "cookies.txt";

                // بررسی فرمت JSON
                $cookies = json_decode($input, true);

                if (json_last_error() !== JSON_ERROR_NONE || !is_array($cookies)) {
                    echo '<div class="alert alert-danger mt-3">❌ ساختار JSON اشتباه است!</div>';
                } else {
                    $valid = true;
                    $cookieArray = [];

                    foreach ($cookies as $c) {
                        if (!isset($c['name']) || !isset($c['value'])) {
                            $valid = false;
                            break;
                        }
                        $cookieArray[] = "{$c['name']}={$c['value']}";
                    }

                    if (!$valid) {
                        echo '<div class="alert alert-danger mt-3">⚠️ هر کوکی باید شامل کلیدهای name و value باشد!</div>';
                    } else {
                        // رشته نهایی Cookie
                        $cookieLine = "Cookie: " . implode("; ", $cookieArray) . "\n";

                        // پاک‌سازی و ذخیره جدید
                        file_put_contents($filename, $cookieLine);

                        echo '<div class="alert alert-success mt-3">✅ کوکی‌ها با موفقیت ذخیره شدند!</div>';
                        echo '<pre class="bg-dark text-white p-3 rounded">'.$cookieLine.'</pre>';
                    }
                }
            }
            ?>

        </div>
    </div>
</div>

</body>
</html>
