@extends('Layouts.adminLayout')
@section('title')
    | تنظیمات
@endsection
@section('css')
    <link rel="stylesheet" type="text/css"
          href="{{ asset('Admin/app-assets/css-rtl/plugins/forms/validation/form-validation.css') }}">
@endsection
@section('content')
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">{{trans('langPanel.setting')}}</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a
                                            href="{{route('Admin.index')}}">{{trans('langPanel.dashboard')}}</a>
                                    </li>
                                    <li class="breadcrumb-item active">{{trans('langPanel.setting')}}
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <!-- Input Validation start -->
                <section class="input-validation">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card">
                                @include('Layouts.msg')

                                <div class="card-header">
                                    {{--                                    <h4 class="card-title">{{trans('langPanel.select_theme')}}</h4>--}}
                                </div>
                                <div class="card-content">
                                    <div class="card-body">
                                        <form class="form-horizontal" action="{{route('Admin.settings.update')}}"
                                              method="POST" novalidate enctype="multipart/form-data">
                                            @CSRF
                                            <div class="row">
                                                <div class="col-md-6 ">
                                                    <p>{{trans('langPanel.color_selection')}}</p>
                                                    <fieldset class="form-group">
                                                        <select class="form-control" name="setting[0][color]"
                                                                data-validation-required-message="{{trans('langPanel.please_select_a_color')}}"
                                                                id="colors">
                                                            @forelse(Config::get('colors') as $key=>$item)
                                                                <option value="{{$key}}">{{trans($item['name'])}} <span
                                                                        style="width: 20px;height: 20px;background: {{$item['hex']}}"></span>
                                                                </option>
                                                            @empty
                                                                <option>{{trans('langPanel.the_template_file_is_empty')}}</option>
                                                            @endforelse
                                                        </select>
                                                    </fieldset>
                                                    <fieldset class="form-group">
                                                        <label
                                                            for="basicInputFile">{{trans('langPanel.slideTitle')}}</label>
                                                        <input type="text" class="form-control"
                                                               name="setting[0][slideTitle]"
                                                               value="{{(isset($settings['slideTitle']))?$settings['slideTitle']:''}}"
                                                               aria-describedby="basic-addon12">

                                                    </fieldset>

                                                    <fieldset class="form-group">
                                                        <label
                                                            for="basicInputFile">{{trans('langPanel.slideDescription')}}</label>
                                                        <input type="text" class="form-control"
                                                               name="setting[0][slideDescription]"
                                                               value="{{(isset($settings['slideDescription']))?$settings['slideDescription']:''}}"
                                                               aria-describedby="basic-addon12">

                                                    </fieldset>

                                                    <fieldset class="form-group">
                                                        <label
                                                            for="basicInputFile">{{trans('langPanel.slideExpertise')}}
                                                            ({{trans('langPanel.separate_with_comma')}})</label>
                                                        <input type="text" class="form-control"
                                                               name="setting[0][slideExpertise]"
                                                               value="{{(isset($settings['slideExpertise']))?$settings['slideExpertise']:''}}"
                                                               aria-describedby="basic-addon12">
                                                    </fieldset>

   
                                             <fieldset class="form-group">
                                                        <label
                                                            for="basicInputFile">{{trans('langPanel.titleSite')}}</label>
                                                        <input type="text" class="form-control"
                                                               name="setting[0][titleSite]"
                                                               value="{{(isset($settings['titleSite']))?$settings['titleSite']:''}}"
                                                               aria-describedby="basic-addon12">

                                                    </fieldset>

                                                </div>

                                                <div class="col-md-6 col-12">
                                                    <p>{{trans('langPanel.template_type')}}</p>
                                                    <fieldset class="form-group">
                                                        <select class="form-control" name="setting[0][theme]"
                                                                data-validation-required-message="{{trans('langPanel.please_select_your_template')}}"
                                                                id="themes">
                                                            @forelse(Config::get('themes') as $key=>$item)
                                                                <option value="{{$key}}">{{$item['nameFarsi']}}</option>
                                                            @empty
                                                                <option>{{trans('langPanel.the_template_file_is_empty')}}</option>
                                                            @endforelse
                                                        </select>
                                                    </fieldset>


                                              

                                                    @isset($settings['favicon'])
                                                        <img src="/{{$settings['favicon']}}" width="50px" height="50px">
                                                    @endisset
                                                    <fieldset class="form-group">
                                                        <label
                                                            for="basicInputFile">{{trans('langPanel.favicon')}}</label>
                                                        <div class="custom-file">
                                                            <input type="file" class="custom-file-input "
                                                                   name="setting[0][favicon]"
                                                                   id="inputGroupFile01">
                                                            <label class="custom-file-label"
                                                                   for="inputGroupFile01">{{trans('langPanel.choose_file')}}</label>
                                                        </div>
                                                    </fieldset>
                                                    @isset($settings['slideImg'])
                                                        <img src="/{{$settings['slideImg']}}" width="50px"
                                                             height="50px">
                                                    @endisset
                                                    <fieldset class="form-group">
                                                        <label
                                                            for="basicInputFile">{{trans('langPanel.slideImg')}}</label>
                                                        <div class="custom-file">
                                                            <input type="file" class="custom-file-input "
                                                                   name="setting[0][slideImg]"
                                                                   id="inputGroupFile01">
                                                            <label class="custom-file-label"
                                                                   for="inputGroupFile01">{{trans('langPanel.slideImg')}}</label>
                                                        </div>
                                                    </fieldset>

                                                    @isset($settings['resume'])
                                                        <img src="/{{$settings['resume']}}" width="50px" height="50px">
                                                    @endisset
                                                    <fieldset class="form-group">
                                                        <label
                                                            for="basicInputFile">{{trans('langPanel.resume')}}</label>
                                                        <div class="custom-file">
                                                            <input type="file" class="custom-file-input "
                                                                   name="setting[0][resume]"
                                                                   id="inputGroupFile01">
                                                            <label class="custom-file-label"
                                                                   for="inputGroupFile01">{{trans('langPanel.resume')}}</label>
                                                        </div>
                                                    </fieldset>

{{--                                                    @isset($settings['infoImage'])--}}
{{--                                                        <img src="/{{$settings['infoImage']}}" width="50px"--}}
{{--                                                             height="50px">--}}
{{--                                                    @endisset--}}
{{--                                                    <fieldset class="form-group">--}}
{{--                                                        <label--}}
{{--                                                            for="basicInputFile">{{trans('langPanel.infoImage')}}</label>--}}
{{--                                                        <div class="custom-file">--}}
{{--                                                            <input type="file" class="custom-file-input "--}}
{{--                                                                   name="setting[0][infoImage]"--}}
{{--                                                                   id="inputGroupFile01">--}}
{{--                                                            <label class="custom-file-label"--}}
{{--                                                                   for="inputGroupFile01">{{trans('langPanel.infoImage')}}</label>--}}
{{--                                                        </div>--}}
{{--                                                    </fieldset>--}}

                                                </div>

                                            </div>

                                            <div class="row">
                                                <div class="col-12">
                                                    <fieldset class="form-label-group">
                                                        <textarea class="form-control" id="label-textarea"
                                                                  name="setting[0][metatag]"
                                                                  rows="3">{{(isset($settings['metatag']))?$settings['metatag']:''}}</textarea>
                                                        <label
                                                            for="label-textarea">{{trans('langPanel.metaTag')}}</label>
                                                    </fieldset>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <fieldset class="form-label-group">
                                                        <textarea class="form-control" id="label-textarea"
                                                                  name="setting[0][keywords]"
                                                                  rows="3">{{ (isset($settings['keywords']))?$settings['keywords']:'' }}</textarea>
                                                        <label
                                                            for="label-textarea">{{trans('langPanel.keyWords')}}</label>
                                                    </fieldset>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <fieldset class="form-label-group">
                                                        <textarea class="form-control" id="label-textarea"
                                                                  name="setting[0][keywords]"
                                                                  rows="3">{{ (isset($settings['descriptionSite']))?$settings['descriptionSite']:'' }}</textarea>
                                                        <label
                                                            for="label-textarea">{{trans('langPanel.description')}}</label>
                                                    </fieldset>
                                                </div>
                                            </div>
                                            
                                                      <div class="row">
                                                <div class="col-12">
                                                    <fieldset class="form-label-group">
                                                        <textarea class="form-control" id="label-textarea"
                                                                  name="setting[0][google_analytics]"
                                                                  rows="3">{{ (isset($settings['google_analytics']))?$settings['google_analytics']:'' }}</textarea>
                                                        <label
                                                            for="label-textarea">{{trans('langPanel.google_analytics')}}</label>
                                                    </fieldset>
                                                </div>
                                            </div>
                <section id="switch-icons">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card">
                                <div class="card-content">
                                    <div class="card-body">
                                        <div class="d-flex justify-content-start flex-wrap">

                                            <div class="custom-control custom-switch custom-switch-success mr-2 mb-1">
                                                <p class="mb-0">{{trans('langPanel.service')}}</p>
                                                <input type="checkbox" class="custom-control-input" value="1" name="setting[0][service]" id="service" >
                                                <label class="custom-control-label" for="service">
                                                    <span class="switch-icon-left"><i class="feather icon-check"></i></span>
                                                    <span class="switch-icon-right"><i class="feather icon-check"></i></span>
                                                </label>
                                            </div>
                                            
                                                       <div class="custom-control custom-switch custom-switch-success mr-2 mb-1">
                                                <p class="mb-0">{{trans('langPanel.resume')}}</p>
                                                <input type="checkbox" class="custom-control-input" id="resume" value="1" name="setting[0][resume]">
                                                <label class="custom-control-label" for="resume" >
                                                    <span class="switch-icon-left"><i class="feather icon-check"></i></span>
                                                    <span class="switch-icon-right"><i class="feather icon-check"></i></span>
                                                </label>
                                            </div>
                                            
                                            
                                            <div class="custom-control custom-switch custom-switch-success mr-2 mb-1">
                                                <p class="mb-0">{{trans('langPanel.about')}}</p>
                                                <input type="checkbox" class="custom-control-input" id="about"  value="1" name="setting[0][about]" >
                                                <label class="custom-control-label" for="about" >
                                                    <span class="switch-icon-left"><i class="feather icon-check"></i></span>
                                                    <span class="switch-icon-right"><i class="feather icon-check"></i></span>
                                                </label>
                                            </div>
                                            
                                            
                                                <div class="custom-control custom-switch custom-switch-success mr-2 mb-1">
                                                <p class="mb-0">{{trans('langPanel.portfolio')}}</p>
                                                <input type="checkbox" class="custom-control-input" id="portfolio"   value="1" name="setting[0][portfolio]" >
                                                <label class="custom-control-label" for="portfolio" >
                                                    <span class="switch-icon-left"><i class="feather icon-check"></i></span>
                                                    <span class="switch-icon-right"><i class="feather icon-check"></i></span>
                                                </label>
                                            </div>
                                            
                                            <div class="custom-control custom-switch custom-switch-success mr-2 mb-1">
                                                <p class="mb-0">{{trans('langPanel.blog')}}</p>
                                                <input type="checkbox" class="custom-control-input" id="blog" value="1"  name="setting[0][blog]" >
                                                <label class="custom-control-label" for="blog" >
                                                    <span class="switch-icon-left"><i class="feather icon-check"></i></span>
                                                    <span class="switch-icon-right"><i class="feather icon-check"></i></span>
                                                </label>
                                            </div>
                                            
                                            <div class="custom-control custom-switch custom-switch-success mr-2 mb-1">
                                                <p class="mb-0">{{trans('langPanel.why-me')}}</p>
                                                <input type="checkbox" class="custom-control-input" id="why-me" value="1" name="setting[0][why-me]">
                                                <label class="custom-control-label" for="why-me" >
                                                    <span class="switch-icon-left"><i class="feather icon-check"></i></span>
                                                    <span class="switch-icon-right"><i class="feather icon-check"></i></span>
                                                </label>
                                            </div>
                                                <div class="custom-control custom-switch custom-switch-success mr-2 mb-1">
                                                <p class="mb-0">{{trans('langPanel.contact')}}</p>
                                                <input type="checkbox" class="custom-control-input" id="contact" value="1" name="setting[0][contact]">
                                                <label class="custom-control-label" for="contact" >
                                                    <span class="switch-icon-left"><i class="feather icon-check"></i></span>
                                                    <span class="switch-icon-right"><i class="feather icon-check"></i></span>
                                                </label>
                                            </div>
                                           
    
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                                            <button type="submit"
                                                    class="btn btn-primary">{{trans('langPanel.save_information')}}</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- Input Validation end -->
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script src="{{asset('Admin/app-assets/vendors/js/forms/validation/jqBootstrapValidation.js')}}"></script>
    <script src="{{ asset('Admin/app-assets/js/scripts/forms/validation/form-validation.js')}}"></script>
    <script>
            @isset($settings['theme'])
        var val ={!! $settings['theme'] !!};
        $('#themes option[value=' + val + ']').attr('selected', 'selected');
            @endisset

            @isset($settings['color'] )

        var val ={!! $settings['color'] !!};
        $('#colors option[value=' + val + ']').attr('selected', 'selected');
            @endisset
            @isset($settings['them_mode'] )

        var val ={!! $settings['them_mode'] !!};
        $('#themMode option[value=' + val + ']').attr('selected', 'selected');
            @endisset

            @isset($settings['full_color'] )

        var val ={!! $settings['full_color'] !!};
        $('#full_color option[value=' + val + ']').attr('selected', 'selected');
        @endisset
            @isset($settings['themeDark'] )

        var val ={!! $settings['themeDark'] !!};
        $('#themeDark option[value=' + val + ']').attr('selected', 'selected');
        @endisset
        
        @isset($settings['service'] )
        var service ={!! $settings['service'] !!};
        if (service == 1)
            $('#service').attr('checked', 'checked');
        @endisset
        
           @isset($settings['resume'] )
        var resume ={!! $settings['resume'] !!};
        if (resume == 1)
            $('#resume').attr('checked', 'checked');
        @endisset
        
        
           @isset($settings['about'] )
        var about ={!! $settings['about'] !!};
        if (about == 1)
            $('#about').attr('checked', 'checked');
        @endisset
        
        
           @isset($settings['portfolio'] )
        var portfolio ={!! $settings['portfolio'] !!};
        if (portfolio == 1)
            $('#portfolio').attr('checked', 'checked');
        @endisset
        
        
           @isset($settings['blog'] )
        var blog ={!! $settings['blog'] !!};
        if (blog == 1)
            $('#blog').attr('checked', 'checked');
        @endisset
        
        
           @isset($settings['why-me'] )
        var whyme ={!! $settings['why-me'] !!};
        if (whyme == 1)
            $('#why-me').attr('checked', 'checked');
        @endisset
        
                  @isset($settings['contact'] )
        var contact ={!! $settings['contact'] !!};
        if (contact == 1)
            $('#contact').attr('checked', 'checked');
        @endisset
        
        
    </script>
@endsection
