@extends('Layouts.adminLayout')
@section('title')
    | {{trans('langPanel.list_of_services')}}
@endsection
@section('css')
    <link rel="stylesheet" type="text/css"
          href="{{ asset('Admin/app-assets/vendors/css/extensions/sweetalert2.min.css') }}">
@endsection
@section('content')
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">

            </div>
            <div class="content-body">
                <!-- Input Validation start -->
                <section id="dashboard-analytics">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                @include('Layouts.msg')

                                <div class="card-header">
                                    <h4 class="mb-0">{{trans('langPanel.list_of_services')}}</h4>

                                </div>
                                <div class="card-content">
                                    <div class="table-responsive mt-1">

                                        <table class="table table-hover-animation mb-0  data-list-view">
                                            <thead>
                                            <tr>
                                                <th>{{trans('langPanel.title')}}</th>
                                                <th>{{trans('langPanel.operation')}}</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @forelse($services as $item)
                                                <tr>
                                                    <td>{{$item->title}}</td>
                                                    <td>
                                                        <a href="{{route('Admin.services.edit',$item->id)}}"
                                                           type="button"
                                                           class="btn btn-icon  rounded-circle btn-warning mr-1 mb-1 waves-effect waves-light"><i
                                                                class="feather icon-edit"></i></a>

                                                        <a onclick="deleteRecord('{{route('Admin.services.delete',$item->id)}}')"
                                                           type="button"
                                                           class="btn btn-icon rounded-circle btn-danger mr-1 mb-1 waves-effect waves-light"><i
                                                                class="feather icon-delete"></i></a>

                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td>{{trans('langPanel.no_information_found')}}</td>
                                                </tr>
                                            @endforelse
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>                <!-- Input Validation end -->
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script src="{{ asset('Admin/app-assets/vendors/js/extensions/sweetalert2.all.min.js')}}"></script>
    <script src="{{ asset('Admin/app-assets/js/scripts/extensions/sweet-alerts.js')}}"></script>

@endsection
