<?php

namespace App\Model;

use Faker\Provider\File;
use Illuminate\Database\Eloquent\Model;

class Services extends Model
{
    protected $table = 'services';
    protected $guarded = ['id'];

    public static function getService($idService)
    {
        return Services::find($idService);
    }

    public static function allServices($paginate = false)
    {
        if ($paginate)
            $services = Services::paginate(9);
        else
            $services = Services::all();
        return $services;
    }

    public static function updateServices($idService, array $data)
    {
        try {
            $service = Services::getService($idService);
            if (isset($data['image'])) {
                if (\Illuminate\Support\Facades\File::exists($service->image)) {
                    \Illuminate\Support\Facades\File::delete($service->image);
                }
                $service->image = $data['image'];
            }
            $service->title = $data['title'];
            $service->text = $data['text'];
            $service->update();
            return true;
        } catch (\Exception $e) {
            return $e->getMessage();
        }

    }

    public static function storeService(array $data)
    {
        try {
            $service = new Services();
            $service->title = $data['title'];
            $service->text = $data['text'];
            $service->image = $data['image'];
            $service->save();
            return true;
        } catch (\Exception $e) {
            return $e->getMessage();
        }

    }


    public static function destroy($id)
    {
        try {
            $service = Services::getService($id);
            if (\Illuminate\Support\Facades\File::exists($service->image)) {
                \Illuminate\Support\Facades\File::delete($service->image);
            }
            $service->delete();
            return true;
        } catch (\Exception $e) {
            return $e->getMessage();
        }

    }

}
