<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Faker\Provider\File;

class Resume extends Model
{
    protected $table = 'resumes';
    public $timestamps = true;
    protected $guarded = ['id'];

    public static function storeResume($data)
    {
        try {
            $Resume = new Resume();
            $Resume->text = $data['text'];
            $Resume->title = $data['title'];
            $Resume->start_date = $data['start_date'];
            $Resume->end_date = $data['end_date'];
            $Resume->type = $data['type'];
            $Resume->save();
            return true;
        } catch (\Exception $e) {
            dd($e);
            return $e->getMessage();
        }
    }

    public static function getResumes()
    {
        $Resumes = Resume::All();
        return $Resumes;
    }

    public static function getResume($id)
    {

        $Resume = Resume::find($id);
        if ($Resume != null)
            return $Resume;
        else
            return "";

    }

    public static function ResumeDelete($id)
    {
        try {
            $Resume = Resume::destroy($id);
            return true;
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }

    public static function updateResume($data, $id)
    {
        try {
            $Resume = Resume::find($id);
            $Resume->text = $data['text'];
            $Resume->title = $data['title'];
            $Resume->start_date = $data['start_date'];
            $Resume->end_date = $data['end_date'];
            $Resume->type = $data['type'];
            $Resume->update();
            return true;
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }

    public static function getWithType(int $type)
    {
        return Resume::where('type',$type)->get();
    }


}

