<?php

namespace App\Http\Controllers\Front;

use App\Model\Blog;

use App\Model\Category;
use App\Model\Comment;
use App\Model\Contact;
use App\Model\Counter;
use App\Model\Portfolio;
use App\Model\Resume;
use App\Model\Services;
use App\Model\Settings;
use App\Model\Skills;
use App\Model\Slider;
use App\Model\Visitor;
use App\User;
use Illuminate\Http\Request;
use App\Http\Requests\Contacts;
use App\Http\Requests\Comments;
use App\Http\Controllers\Controller;
use League\Flysystem\Config;
use Morilog\Jalali\Jalalian;
class IndexController extends Controller
{

    public function index()
    {
        $Comment = Comment::getCommentsPanel();
        $Category = Category::getCategorys();
        $Portfolio = Portfolio::getPortfolios();
        $Services = Services::allServices();
        $settings = Settings::allSettings()->pluck('value', 'name');
		  $ip=get_client_ip_env();
			$dateTime = Jalalian::now()->getTimestamp();
			$datenow=timestampDate($dateTime,true);
			$date=$datenow['date'];
         $getVisitors=Visitor::getVisitorsIp($ip,$date);
			if($getVisitors==null)
              Visitor::store();

        if (isset($settings['color']))
		{
            $themColor = \Illuminate\Support\Facades\Config::get('colors')[$settings['color']]['href'];
            $themColorTheme = \Illuminate\Support\Facades\Config::get('colors')[$settings['color']]['hrefTheme'];
             $nameColorFile = \Illuminate\Support\Facades\Config::get('colors')[$settings['color']]['nameColorFile'];
		}
        else
		{
            $themColor = \Illuminate\Support\Facades\Config::get('colors')[1]['href'];
            $themColorTheme = \Illuminate\Support\Facades\Config::get('colors')[1]['hrefTheme'];
                        $nameColorFile = \Illuminate\Support\Facades\Config::get('colors')[1]['nameColorFile'];

			
		}

        if (isset($settings['theme']))
            $themType = \Illuminate\Support\Facades\Config::get('themes')[$settings['theme']];
        else
            $themType = \Illuminate\Support\Facades\Config::get('themes')[1];
        $hrefFile = $themType['hrefFile'];
        $bladeName = $themType['nameBlade'];
        $cssFile = $themType['css'];
        $jsFile = $themType['js'];

        $themColor=$hrefFile."/".$themColor;
		$themColorTheme=$hrefFile."/".$themColorTheme;
//dd($bladeName,$cssFile,$jsFile,$themColorTheme,$themColor,$settings['theme'],$hrefFile);
        $blogs = Blog::getBlogs();
        $user = User::getUserAdmin();
        $resumesEdu = Resume::getWithType(0);
        $resumesJobs = Resume::getWithType(1);
        $skill = Skills::allSkill()->toArray();
        $count = count($skill);
        if ($count != 0)
            $skill = array_chunk($skill, round($count / 2));
        $counters = Counter::getCounters();


        if (!isset($settings['titleSite']))
            $settings['titleSite'] = '';

        $all_data = ['nameColorFile'=>$nameColorFile,'skill' => $skill, 'resumesEdu' => $resumesEdu, 'resumesJobs' => $resumesJobs, 'blogs' => $blogs, 'settings' => $settings, 'user' => $user,
            'Comment' => $Comment, 'Category' => $Category, 'Portfolio' => $Portfolio, 'Services' => $Services, 'counters' => $counters,
            'color' => $themColor, 'themColorTheme' => $themColorTheme, 'cssFile' => $cssFile,'jsFile'=>$jsFile];
            
            if(session('msgSuccess')!=null){
                $all_data ['msgSuccess'] =session('msgSuccess');
            }
            

        return view('Front.' . $bladeName)->with('data', $all_data);
    }

    public function portfolioText($id)
    {

        return $Portfolio = Portfolio::getportfolio($id);

    }

    public function blogText($id)
    {
        $Blog = Blog::getblog($id);
        $Comment = Comment::getCommentsBlog($id);
        $all_data = ['Comment' => $Comment, 'Blog' => $Blog];
        return $all_data;
    }

    public function contactStore(request $request)
    {


        $data['text'] = $request->message;
        $data['fullname'] = $request->fullname;
        $data['email'] = $request->email;
        $data['subject'] = $request->subject;
		
        $check = Contact::store($data);
        if ($check == true)
            return redirect()->route('Front.index')->with('msgSuccess', trans('langPanel.mission_accomplished'));
        else
            return redirect()->route('Front.index')->with('msgError', trans('langPanel.the_operation_failed'));


    }

    public function commentsStore(Comments $request, $id)
    {
        $data['text'] = $request->text;
        $data['fullname'] = $request->fullname;
        $data['email'] = $request->email;
        $data['commentable_id'] = $id;
        $data['commentable_type'] = 1;
        $data['image'] = '';
        $check = Comment::store($data);
        if ($check == true)
            return redirect()->route('Front.index')->with('msgSuccess', trans('langPanel.mission_accomplished'));
        else
            return redirect()->route('Front.index')->with('msgError', trans('langPanel.the_operation_failed'));


    }


}
