<?php
/**
 * Gauch post content
 */

global $gauch_opt;

// Post thumb size
if(isset($gauch_opt['gauch_blog_sidebar'])) {
   if( $gauch_opt['gauch_blog_sidebar'] == 'gauch_without_sidebar' ):
        $thumb_size = 'full';
   else:
        $thumb_size = 'gauch_post_thumb';
   endif;
}else {
    $thumb_size = 'gauch_post_thumb';
}

if( isset( $gauch_opt['read_more'] ) ):
    $read_more      = $gauch_opt['read_more'];
    $blog_style     = $gauch_opt['gauch_blog_style'];
else:
    $read_more      = 'Read More';
    $blog_style     = '1';
endif;

// Author info
$get_author_id = get_the_author_meta('ID');

// Blog Column
$gauch_blog_grid = !empty($gauch_opt['gauch_blog_grid']) ? $gauch_opt['gauch_blog_grid'] : 'col-lg-12 col-md-12';
$id    = get_the_ID();

?>

<?php if($blog_style == '2'): ?>
    <div <?php post_class( $gauch_blog_grid ); ?>>
        <div class="single-blog-post-el">
            <?php if(get_the_post_thumbnail_url() != ''): ?>
                <div class="image">
                    <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="d-block">
                        <img src="<?php the_post_thumbnail_url( 'gauch_post_thumb' ); ?>" alt="<?php the_post_thumbnail_caption(); ?>">
                    </a>
                    <span class="date"><?php echo esc_html(get_the_date()); ?></span>
                </div>
            <?php endif; ?>

            <div class="content">
                <?php if( get_the_title() != '' ): ?>
                    <h3><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h3>
                <?php endif; ?>

                <?php the_excerpt() ?>

                <?php if( $read_more != '' ): ?>
                    <a href="<?php the_permalink() ?>" class="default-btn"><span class="ri-arrow-right-s-line"></span><?php echo esc_html( $read_more ); ?></a>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php else: ?>
    <div <?php post_class( $gauch_blog_grid ); ?>>
        <div class="single-blog-post">
            <?php if(has_post_thumbnail()) { ?>
                <div class="post-image">
                    <a href="<?php the_permalink() ?>">
                        <img src="<?php the_post_thumbnail_url($thumb_size) ?>" alt="<?php the_title_attribute(); ?>">
                    </a>
                </div>
            <?php } ?>

                <div class="post-content">
                <?php if( isset( $gauch_opt['is_post_meta'] ) && $gauch_opt['is_post_meta'] == true ) { ?>
                    <div class="blog-meta">
                        <ul class="entry-meta">
                            <li>
                                <i class="ri-user-line"></i>
                                <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ); ?>"><?php echo esc_html(get_the_author()); ?></a>
                            </li>
                            <li>
                                <i class="ri-time-line"></i>
                                <?php echo wp_kses(get_the_date('F d, Y'), 'gauchallowedhtml') ?>
                            </li>
                            <li>
                                <i class="ri-message-2-line"></i>
                                <?php comments_number(); ?>
                            </li>
                        </ul>
                    </div>
                <?php } ?>

                <?php if( get_the_title() != '' ): ?>
                    <h3><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h3>
                <?php endif; ?>
                <?php the_excerpt() ?>

                <?php if( $read_more != '' ): ?>
                    <a href="<?php the_permalink() ?>" class="default-btn"><span class="ri-arrow-right-s-line"></span><?php echo esc_html( $read_more ); ?> </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php endif; ?>