<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 * @package Gauch
 */

/**
 * Adds custom classes to the array of body classes.
 */
if ( ! function_exists( 'gauch_body_classes' ) ) {
	function gauch_body_classes( $classes ) {
		// Adds a class of hfeed to non-singular pages.
		if ( ! is_singular() ) {
			$classes[] = 'hfeed';
		}

		// Adds a class of no-sidebar when there is no sidebar present.
		if ( ! is_active_sidebar( 'sidebar-1' ) ) {
			$classes[] = 'no-sidebar';
		}

		return $classes;
	}
}
add_filter( 'body_class', 'gauch_body_classes' );

/**
 * Gauch RTL
*/
if( ! function_exists( 'gauch_rtl' ) ):
	function gauch_rtl() {
		global $gauch_opt;

		if(	isset( $gauch_opt['gauch_enable_rtl'])  ):
			$gauch_rtl_opt = $gauch_opt['gauch_enable_rtl'];
		else:
			$gauch_rtl_opt = 'disable';
		endif;

		if ( isset( $_GET['rtl'] ) ) {
			$gauch_rtl_opt = $_GET['rtl'];
		}

		if ( $gauch_rtl_opt == 'enable' ) :
			$gauch_rtl = true;
		else:
			$gauch_rtl = false;
		endif;

		return $gauch_rtl;
	}
endif;

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
if ( ! function_exists( 'gauch_pingback_header' ) ) {
	function gauch_pingback_header() {
		if ( is_singular() && pings_open() ) {
			printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
		}
	}
}
add_action( 'wp_head', 'gauch_pingback_header' );

/**
 * Gauch Preloader
*/

if ( ! function_exists( 'gauch_preloader' ) ) :
	function gauch_preloader() {
		global $gauch_opt;

		if( isset( $gauch_opt['enable_preloader'] ) ):
			$is_preloader = $gauch_opt['enable_preloader'];
		else:
			$is_preloader = true;
		endif;

		$is_preloader       = !empty($gauch_opt['enable_preloader']) ? $gauch_opt['enable_preloader'] : '';

        $preloader_style    = !empty($gauch_opt['preloader_style']) ? $gauch_opt['preloader_style'] : 'circle-spin';

        if( $is_preloader == true ):
            if ( defined( 'ELEMENTOR_VERSION' ) ) :
                if (\Elementor\Plugin::$instance->preview->is_preview_mode()) :
                    echo '';
                else:
                    if ( $preloader_style == 'text' ) :
                        if (!empty( $gauch_opt['loading_text'] ) ) : ?>
                            <div class="preloader-area ">
                                <div class="loader">
                                    <p class="text-center"> <?php echo esc_html( $gauch_opt['loading_text'] ) ?> </p>
                                </div>
                            </div>
                        <?php endif;
                    elseif( $preloader_style == 'circle-spin' ) : ?>
                        <div class="preloader-area">
							<div class="spinner">
								<div class="inner">
									<div class="disc"></div>
									<div class="disc"></div>
									<div class="disc"></div>
								</div>
							</div>
						</div>
                    <?php else: ?>
                        <div class="preloader-area preloader-img">
                            <div class="loader">
                            </div>
                        </div>
                    <?php endif;
                endif;
            else:
                if ( $preloader_style == 'text' ) :
                    if (!empty( $gauch_opt['loading_text'] ) ) : ?>
                        <div class="preloader-area ">
                            <div class="loader">
                                <p class="text-center"> <?php echo esc_html( $gauch_opt['loading_text'] ) ?> </p>
                            </div>
                        </div>
                    <?php endif;
                elseif( $preloader_style == 'circle-spin' ) :
                    ?>
                    <div class="preloader-area">
						<div class="spinner">
							<div class="inner">
								<div class="disc"></div>
								<div class="disc"></div>
								<div class="disc"></div>
							</div>
						</div>
					</div>
                <?php else : ?>
                    <div class="preloader-area preloader-img">
                        <div class="loader">
                        </div>
                    </div>
                    <?php
                endif;
            endif;
        endif;
	}
endif;

/**
 * Gauch Page Shape Images
 */
if ( ! function_exists( 'gauch_page_shape_images' ) ) {
	function gauch_page_shape_images() {
		global $gauch_opt;
        if(isset($gauch_opt['banner_img1']['url'])):
            ?>
            <?php if( $gauch_opt['banner_img1']['url'] != ''  ): ?>
                <div class="shape1"><img src="<?php echo esc_url( $gauch_opt['banner_img1']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image ', 'gauch' ); ?>"></div>
            <?php endif; ?>

            <?php if( $gauch_opt['banner_img2']['url'] != ''  ): ?>
                <div class="shape3"><img src="<?php echo esc_url( $gauch_opt['banner_img2']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image ', 'gauch' ); ?>"></div>
            <?php endif; ?>
            <?php
        endif;
	}
}

/**
 * gauch Allowed HTML
 */
if ( ! function_exists( 'gauch_kses_allowed_html' ) ) :
	function gauch_kses_allowed_html($tags, $context) {
		$allowed_atts = array(
			'align'      => array(),
			'class'      => array(),
			'type'       => array(),
			'id'         => array(),
			'dir'        => array(),
			'lang'       => array(),
			'style'      => array(),
			'xml:lang'   => array(),
			'src'        => array(),
			'alt'        => array(),
			'href'       => array(),
			'rel'        => array(),
			'rev'        => array(),
			'target'     => array(),
			'novalidate' => array(),
			'type'       => array(),
			'value'      => array(),
			'name'       => array(),
			'tabindex'   => array(),
			'action'     => array(),
			'method'     => array(),
			'for'        => array(),
			'width'      => array(),
			'height'     => array(),
			'data'       => array(),
			'title'      => array(),
		);
		switch($context) {
		case 'gauchallowedhtml':
			$tags = array(
				'form'    => $allowed_atts,
				'label'   => $allowed_atts,
				'input'   => $allowed_atts,
				'textarea'=> $allowed_atts,
				'iframe'  => $allowed_atts,
				'script'  => $allowed_atts,
				'style'   => $allowed_atts,
				'strong'  => $allowed_atts,
				'small'   => $allowed_atts,
				'table'   => $allowed_atts,
				'span'    => $allowed_atts,
				'abbr'    => $allowed_atts,
				'code'    => $allowed_atts,
				'pre'     => $allowed_atts,
				'div'     => $allowed_atts,
				'img'     => $allowed_atts,
				'h1'      => $allowed_atts,
				'h2'      => $allowed_atts,
				'h3'      => $allowed_atts,
				'h4'      => $allowed_atts,
				'h5'      => $allowed_atts,
				'h6'      => $allowed_atts,
				'ol'      => $allowed_atts,
				'ul'      => $allowed_atts,
				'li'      => $allowed_atts,
				'em'      => $allowed_atts,
				'hr'      => $allowed_atts,
				'br'      => $allowed_atts,
				'tr'      => $allowed_atts,
				'td'      => $allowed_atts,
				'p'       => $allowed_atts,
				'a'       => $allowed_atts,
				'b'       => $allowed_atts,
				'i'       => $allowed_atts,
			);
			return $tags;
		default:
			return $tags;
		}
	}
endif;

add_filter( 'wp_kses_allowed_html', 'gauch_kses_allowed_html', 10, 2);

