<?php
/**
 * Register custom style.
 */

if ( ! function_exists( 'gauch_custom_style' ) ) {
    function gauch_custom_style(){

        $custom_style ='';
            global $gauch_opt;

            if( isset( $gauch_opt['primary_color'] ) ):
                $primary_color              = $gauch_opt['primary_color'];
                $footer_bg                  = $gauch_opt['footer_bg'];
                $nav_item_color             = $gauch_opt['nav_item_color'];
                $mob_nav_item_color 	    = $gauch_opt['mob_nav_item_color'];
                $hide_blog_banner           = $gauch_opt['hide_blog_banner'];
            else:
                $primary_color              = '#029894';
                $footer_bg                  = '#f9f9f9';
                $nav_item_color             = '#09114a';
                $mob_nav_item_color         = '#09114a';
                $hide_blog_banner           = false;
            endif;
            $secondary_color            = '#029894';

            $custom_style .='

            :root {
                --mainColor: '.esc_attr($primary_color).';
            }';

            $custom_style .='

            .widget_rss ul li a:hover { color: '.esc_attr($primary_color).' !important; }

            theme_gradient_color { color: '.esc_attr($primary_color).' !important; }

            .post-password-form input[type="submit"]:hover{ border-color: '.esc_attr($primary_color).'; }

            .navbar-area .navbar .navbar-nav .nav-item a, .navbar-area .navbar .navbar-nav .nav-item .dropdown-menu li a { color: '.esc_attr( $nav_item_color  ).'; }

            .gauch-responsive-nav .gauch-responsive-menu.mean-container .mean-nav ul li a { color: '.esc_attr( $mob_nav_item_color  ).'; }';

            // Hide Sticky Header
            if(isset($gauch_opt['enable_sticky_header']) && $gauch_opt['enable_sticky_header'] == false){ $custom_style .='
                .navbar-area.is-sticky{
                    display:none !important;
                }';
            }

            // Custom Css
            if( isset($gauch_opt['css_code'] ) && !empty($gauch_opt['css_code']) ):
                $custom_style .= $gauch_opt['css_code'];
            endif;

            if( is_user_logged_in() ){
                $custom_style .=' .comments-area .comment-respond .form-submit {
                    margin-top: 20px;
                }';
            }

            // Banner Image
            $banner_bg  = isset($gauch_opt['banner_bg']['url']) ? $gauch_opt['banner_bg']['url'] : '';
            if($banner_bg):
                $custom_style .= "
                    .page-title-area {
                        background-image: url(" . esc_url( $banner_bg ) . ");
                    }
                ";
            endif;

            // Pre-loader image
            $is_preloader       = !empty($gauch_opt['enable_preloader']) ? $gauch_opt['enable_preloader'] : '';
            $preloader_image = isset( $gauch_opt['preloader_image']['url'] ) ? $gauch_opt['preloader_image']['url'] : GAUCH_IMG .'/status.gif';
            $preloader_style = !empty( $gauch_opt['preloader_style'] ) ? $gauch_opt['preloader_style'] : 'text';
            if ( $preloader_style == 'image' && $is_preloader == '1' ) {
                $custom_style .= "
                .preloader:after,  .preloader:before {
                    display: none;
                }
                .preloader {
                    background: #fff;
                }
                .preloader-img {
                    background-image: url(" . esc_url( $preloader_image ) . ");
                    background-repeat: no-repeat;
                    background-position: center;
                }";
            }

            wp_add_inline_style('gauch-blog', $custom_style);

            // Custom Js
            $custom_script ='';
            if( isset($gauch_opt['js_code'] )){
                $custom_script .= $gauch_opt['js_code'];
            }

            wp_add_inline_script( 'gauch-main', $custom_script );
    }
}
add_action( 'wp_enqueue_scripts', 'gauch_custom_style' );