jQuery(function ($) {
    'use strict';
	jQuery(document).on('ready', function () {

		// Mean Menu
		$('.mean-menu').meanmenu({
			meanScreenWidth: "991"
		});

		// Header Sticky
		$(window).on('scroll',function() {
			if ($(this).scrollTop() > 120){
				$('.navbar-area').addClass("is-sticky");
			}
			else{
				$('.navbar-area').removeClass("is-sticky");
			}
		});

		// On Hover
		$('.navbar-nav .nav-item').hover(
			function(){ $(".header-area").addClass('hover') },
			function(){ $(".header-area").removeClass('hover') }
		);
		$('.partner-item').hover(
			function(){ $(".partner-area").addClass('hover') },
			function(){ $(".partner-area").removeClass('hover') }
		);
		$('.megamenu .nav-item .nav-link').hover(
			function(){ $(".megamenu").addClass('hover') },
			function(){ $(".megamenu").removeClass('hover') }
		);
		$('.awards-box').hover(
			function(){ $(".awards-box").addClass('hover') },
			function(){ $(".awards-box").removeClass('hover') }
		);
		$('.clients-list .box').hover(
			function(){ $('.clients-list .box').addClass('hover') },
			function(){ $('.clients-list .box').removeClass('hover') }
		);

		// tooltip
		var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
		var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
			return new bootstrap.Tooltip(tooltipTriggerEl)
		});

		// WOW JS
		$(window).on ('load', function (){
			if ($(".wow").length) {
				var wow = new WOW({
					boxClass:     'wow',      // animated element css class (default is wow)
					animateClass: 'animated', // animation css class (default is animated)
					offset:       20,          // distance to the element when triggering the animation (default is 0)
					mobile:       true, // trigger animations on mobile devices (default is true)
					live:         true,       // act on asynchronously loaded content (default is true)
				});
				wow.init();
			}
		});

		// Go to Top
		$(function(){
			// Scroll Event
			$(window).on('scroll', function(){
				var scrolled = $(window).scrollTop();
				if (scrolled > 600) $('.go-top').addClass('active');
				if (scrolled < 600) $('.go-top').removeClass('active');
			});
			// Click Event
			$('.go-top').on('click', function() {
				$("html, body").animate({ scrollTop: "0" },  500);
			});
		});

		/* Start "Cybersecurity Demo JS, Cryptocurrency Demo JS & ICO Landing Demo JS" */
		// Popup Video
		$('.popup-youtube').magnificPopup({
			disableOn: 320,
			type: 'iframe',
			mainClass: 'mfp-fade',
			removalDelay: 160,
			preloader: false,
			fixedContentPos: false
		});

		// Value Trade Slides
		$('.value-trade-slides').owlCarousel({
			nav: false,
			loop: true,
			margin: 25,
			dots: false,
			autoplay: true,
			autoplayHoverPause: true,
			
			responsive: {
				0: {
					items: 2
				},
				576: {
					items: 3
				},
				768: {
					items: 4
				},
				992: {
					items: 5
				},
				1200: {
					items: 8
				}
			}
		});

		// Partner Wrap Slides
		$('.partner-wrap-slides').owlCarousel({
			nav: false,
			loop: true,
			margin: 30,
			dots: false,
			autoplay: true,
			autoplayHoverPause: true,
			navText: [
				"<i class='ri-arrow-left-s-line'></i>",
				"<i class='ri-arrow-right-s-line'></i>"
			],
			responsive: {
				0: {
					items: 2
				},
				576: {
					items: 3
				},
				768: {
					items: 3
				},
				992: {
					items: 4
				},
				1200: {
					items: 5
				}
			}
		});

		/* End "Cybersecurity Demo JS, Cryptocurrency Demo JS & ICO Landing Demo JS" */
	});

	// Preloader
	$(window).on('load', function() {
		$('.preloader-area').fadeOut();
	});

	$( window ).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/widget', function( $scope ) {
			// Home Slides
			$('.home-slides').owlCarousel({
				items: 1,
				nav: true,
				loop: true,
				margin: 30,
				dots: false,
				autoplay: false,
				autoplayHoverPause: true,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>"
				]
			});

			$('.services-slides').owlCarousel({
				nav: false,
				loop: true,
				margin: 30,
				dots: true,
				autoplay: true,
				autoplayHoverPause: true,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>"
				],
				responsive: {
					0: {
						items: 1
					},
					576: {
						items: 1
					},
					768: {
						items: 2
					},
					992: {
						items: 2
					},
					1200: {
						items: 3
					}
				}
			});
			$('.services-slides-two').owlCarousel({
				nav: false,
				loop: true,
				margin: 30,
				dots: true,
				autoplay: true,
				autoplayHoverPause: true,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>"
				],
				responsive: {
					0: {
						items: 1
					},
					576: {
						items: 1
					},
					768: {
						items: 2
					},
					992: {
						items: 2
					},
					1200: {
						items: 3
					}
				}
			});

			// Odometer JS
			$('.odometer').appear(function(e) {
				var odo = $(".odometer");
				odo.each(function() {
					var countNumber = $(this).attr("data-count");
					$(this).html(countNumber);
				});
			});

			// Case Studies Slides
			$('.case-studies-slides').owlCarousel({
				items: 1,
				nav: true,
				loop: true,
				margin: 30,
				dots: false,
				autoplay: true,
				smartSpeed: 500,
				autoplayHoverPause: true,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>"
				]
			});

			// Team Slides
			$('.team-slides').owlCarousel({
				nav: true,
				loop: true,
				margin: 30,
				center: true,
				dots: false,
				autoplay: true,
				autoplayHoverPause: true,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>"
				],
				responsive: {
					0: {
						items: 1
					},
					576: {
						items: 3
					},
					768: {
						items: 3
					},
					992: {
						items: 5
					},
					1200: {
						items: 5
					}
				}
			});

			// Feedback Slides
			$('.feedback-slides').owlCarousel({
				nav: true,
				loop: true,
				margin: 30,
				dots: false,
				autoplay: true,
				autoplayHoverPause: true,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>"
				],
				responsive: {
					0: {
						items: 1
					},
					576: {
						items: 1
					},
					768: {
						items: 2
					},
					992: {
						items: 3
					},
					1200: {
						items: 3
					}
				}
			});

			// Partner Slides
			$('.partner-slides').owlCarousel({
				nav: false,
				loop: true,
				margin: 30,
				dots: false,
				autoplay: true,
				autoplayHoverPause: true,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>"
				],
				responsive: {
					0: {
						items: 2
					},
					576: {
						items: 3
					},
					768: {
						items: 4
					},
					992: {
						items: 5
					},
					1200: {
						items: 6
					}
				}
			});
			
			// Roadmap Slides
			$('.roadmap-slides').owlCarousel({
				nav: true,
				loop: true,
				margin: 25,
				dots: true,
				autoplay: true,
				autoplayHoverPause: true,
				responsive: {
					0: {
						items: 1
					},
					576: {
						items: 1
					},
					768: {
						items: 2
					},
					992: {
						items: 3
					},
					1200: {
						items: 4
					}
				},
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>"
				]
			});

			// Shorting
			$(function(){
				$('.shorting').mixItUp();
			});
		});
	});
}(jQuery));