<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package Gauch
 */

global $gauch_opt;

get_header();

if ( isset( $gauch_opt['title_not_found'] ) ):
	$banner_title	= $gauch_opt['banner_title_not_found'];
	$title 			= $gauch_opt['title_not_found'];
	$content 		= $gauch_opt['content_not_found'];
	$button 		= $gauch_opt['button_not_found'];
	$image 			= $gauch_opt['not_found_image']['url'];
    $tag 			= $gauch_opt['page_title_tag'];
endif;

?>

<div class="page-title-area">
	<div class="container">
		<div class="page-title-content text-center">
			<?php if( isset($gauch_opt['banner_title_not_found']) ): ?>
				<<?php echo esc_attr( $tag ); ?>><?php echo esc_html( $banner_title ); ?></<?php echo esc_attr( $tag ); ?>>
			<?php else: ?>
				<h1><?php esc_html_e('404 Error', 'gauch'); ?></h1>
			<?php endif; ?>

			<?php
			if ( function_exists('yoast_breadcrumb') ) {
				yoast_breadcrumb( '<p class="gauch-seo-breadcrumbs" id="breadcrumbs">','</p>' );
			} else { ?>
				<ul>
					<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'gauch' ); ?></a></li>
					<?php if( isset($gauch_opt['banner_title_not_found']) ): ?>
						<li><?php echo esc_html( $banner_title ); ?></li>
					<?php else: ?>
						<li><?php esc_html_e('404 Error', 'gauch'); ?></li>
					<?php endif; ?>
				</ul>
				<?php
			}
			?>
		</div>
	</div>

	<?php gauch_page_shape_images(); ?>
</div>

<div class="error-area ptb-100">
	<div class="d-table">
		<div class="d-table-cell">
			<div class="container">
				<?php if ( isset( $gauch_opt['title_not_found'] ) ): ?>
					<div class="error-content">
						<?php if( $image != '' ): ?>
							<img src="<?php echo esc_url( $image ); ?> " alt="<?php echo esc_attr( $title ); ?>">
						<?php endif; ?>

						<h3><?php echo esc_html( $title ); ?></h3>
						<p><?php echo esc_html( $content ); ?></p>

						<?php if(  $button != '' ): ?>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="default-btn"><?php echo esc_html( $button ); ?><span class="ri-arrow-right-s-line"></span></a>

						<?php endif; ?>
					</div>
				<?php else: ?>
					<div class="error-content">
						<h3><?php esc_html_e('Page Not Found', 'gauch');; ?></h3>
						<p><?php esc_html_e('The page you are looking for might have been removed had its name changed or is temporarily unavailable.', 'gauch'); ?></p>

						<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="default-btn"><?php esc_html_e('Go to Home', 'gauch'); ?><span class="ri-arrow-right-s-line"></span></a>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>

<?php get_footer();