<?php
namespace Elementor;
class VideoAreaWidget extends Widget_Base{
    public function get_name(){
        return "Video-area-widget";
    }
    public function get_title(){
        return "Video Area";
    }
    public function get_icon(){
        return "eicon-banner";
    }
    public function get_categories(){
        return [ 'gauch-elements' ];
    }

    protected function register_controls(){
        // Tab content controls
        $this-> start_controls_section(
            'section_content',
            [
                'label' => __('Content', 'gauch-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $this->add_control(
                'bg_image',
                [
                    'label' => __( 'Background Image', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );
            // Video
            $this->add_control(
                'video_url',
                [
                    'label' => __('Video URL', 'gauch-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                ]
            );
            $this->add_control(
                'video_icon',
                [
                    'label'       => __('Video Icon', 'gauch-toolkit'),
                    'type'        => Controls_Manager:: TEXT,
                    'default'     => 'ri-play-fill',
                ]
            );
            
        $this-> end_controls_section();

        // End Tab content controls

        // Start style1 content controls
        $this-> start_controls_section(
            'content_style',
            [
                'label' => __('Content', 'gauch-toolkit'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'video_bgcolor',
                [
                    'label' => __( 'Video Background Color', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .video-view-content .video-btn' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'video_color',
                [
                    'label' => __( 'Video Color', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .video-view-content .video-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'video_bghcolor',
                [
                    'label' => __( 'Video Background Hover Color', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .video-view-content .video-btn:hover' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'video_hcolor',
                [
                    'label' => __( 'Video Hover Color', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .video-view-content .video-btn:hover i' => 'color: {{VALUE}}',
                    ],
                ]
            );
        $this-> end_controls_section();
        // End Style content controls
    }

    protected function render()
    {
        // Retrieve all controls value
        $settings = $this->get_settings_for_display();

        global $gauch_opt;

        ?>
        <div class="video-style-area"  style="background-image:url(<?php echo esc_url( $settings['bg_image']['url'] ); ?>);">
            <div class="container-fluid">
                <?php if( $settings['video_url'] != '') : ?>
                    <div class="video-view-content">
                        <a href="<?php echo esc_url( $settings['video_url'] ); ?>" class="video-btn popup-youtube">
                            <i class="<?php echo esc_attr( $settings['video_icon'] ); ?>"></i>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new VideoAreaWidget );