<?php
/**
 * Services Widget
*/

namespace Elementor;
class Gauch_Services extends Widget_Base {

	public function get_name() {
        return 'Services';
    }

	public function get_title() {
        return __( 'Services', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-tools';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'services_section',
			[
				'label' => __( 'Services', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'style',
                [
                    'label' => __( 'Services Style', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style 1', 'gauch-toolkit' ),
                        '2'   => __( 'Style 2', 'gauch-toolkit' ),
                        '3'   => __( 'Style 3', 'gauch-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'columns',
                [
                    'label' => __( 'Choose Columns', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( '1', 'gauch-toolkit' ),
                        '2'   => __( '2', 'gauch-toolkit' ),
                        '3'   => __( '3', 'gauch-toolkit' ),
                        '4'   => __( '4', 'gauch-toolkit' ),
                    ],
                    'default' => '3',
                    'condition' => [
                        'style' => ['1','3'],
                    ]

                ]
            );

            $this->add_control(
                'read_more',
                [
                    'label' => __( 'Learn More Text', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Learn More', 'gauch-toolkit'),
                ]
            );

            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => gauch_toolkit_get_page_services_cat_el(),
                ]
            );

            $this->add_control(
                'order',
                [
                    'label' => __( 'Services Order By', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'gauch-toolkit' ),
                        'ASC'       => __( 'ASC', 'gauch-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label' => __( 'Post Per Page', 'gauch-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 6,
                ]
            );

            $this->add_control(
				'button_text',
				[
					'label' 	=> esc_html__( 'Button Text', 'gauch-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('View All Services', 'gauch-toolkit'),
                    'condition' => [
                        'style' => '3',
                    ]
				]
            );

            $this->add_control(
                'link_type',
                [
                    'label' 		=> esc_html__( 'Link Type', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options'       => [
                        '1'  	=> esc_html__( 'Link To Page', 'gauch-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'gauch-toolkit' ),
                    ],
                    'condition' => [
                        'style' => '3',
                    ]
                ]
            );

            $this->add_control(
                'link_to_page',
                [
                    'label' 		=> esc_html__( 'Link Page', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> gauch_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type'  => '1',
                        'style' => '3',
                    ]
                ]
            );
            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('External Link', 'gauch-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type'  => '2',
                        'style'      => '3',
                    ]
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'service_style',
			[
				'label' => __( 'Style', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-services-box h3 a, .cyber-security-services-card .services-content h3 a' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'gauch-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .single-services-box h3, .cyber-security-services-card .services-content h3 a',
                ]
            );

            $this->add_control(
                'content_color',
                [
                    'label' => __( 'Content Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-services-box p, .cyber-security-services-card .services-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'gauch-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .single-services-box p, .cyber-security-services-card .services-content p',
                ]
            );

            $this->add_control(
                'btn_color',
                [
                    'label' => __( 'Button Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-services-box .default-btn, .cyber-security-services-card .services-content .services-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'btn_typography',
                    'label' => __( 'Button Typography', 'gauch-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .single-services-box .default-btn, .cyber-security-services-card .services-content .services-btn',
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Card Columns
        $columns = $settings['columns'];
        if ($columns == '1') {
            $column = 'col-lg-12 col-md-6';
        }elseif ($columns == '2') {
            $column = 'col-lg-6 col-md-6';
        }elseif ($columns == '3') {
            $column = 'col-xl-4 col-lg-6 col-md-6 col-sm-12';
        }elseif ($columns == '4') {
            $column = 'col-lg-3 col-md-6';
        }

        // Services Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'services',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'service_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'services',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order']
            );
        }
        $services_array = new \WP_Query( $args );

        // Get Button Link
        if($settings['link_type'] == 1){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }
        ?>
        <?php if($settings['style'] == '1'): ?>
            <div class="container">
                <div class="row justify-content-center">
                    <?php
                    while($services_array->have_posts()):
                        $services_array->the_post();

                        // ACF Fields
                        $icon       = get_field('service_icon_image');
                        $content    = get_field('services_card_content');

                        if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        }
                        ?>
                        <div class="<?php echo esc_attr( $column );?>">
                            <div class="single-services-box" style="background-image:url(<?php echo get_the_post_thumbnail_url( get_the_ID()); ?>);">
                                <div class="d-flex align-items-center">
                                    <?php if($icon): ?>
                                        <img src="<?php echo esc_url($icon); ?>" alt="<?php the_post_thumbnail_caption();  ?>">
                                    <?php endif; ?>
                                    <h3>
                                        <a href="<?php echo esc_url( $post_link ); ?>"><?php the_title(); ?></a>
                                    </h3>
                                </div>

                                <?php echo wp_kses_post($content); ?>
                                <?php if($settings['read_more']): ?>
                                    <a href="<?php echo esc_url( $post_link ); ?>" class="default-btn"><span class="ri-arrow-right-s-line"></span><?php echo esc_html($settings['read_more']); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endwhile; ?>
                    <?php wp_reset_query(); ?>
                </div>
            </div>
        <?php elseif($settings['style'] == '2'): ?>
            <div class="container">
                <div class="services-slides owl-carousel owl-theme">
                    <?php
                    while($services_array->have_posts()):
                        $services_array->the_post();

                        // ACF Fields
                        $icon       = get_field('service_icon_image');
                        $content    = get_field('services_card_content');

                        if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        }
                        ?>
                        <div class="single-services-item">
                            <div class="d-flex align-items-center">
                                <?php if($icon): ?>
                                    <img src="<?php echo esc_url($icon); ?>" alt="<?php the_post_thumbnail_caption();  ?>">
                                <?php endif; ?>
                                <h3>
                                    <a href="<?php echo esc_url( $post_link ); ?>"><?php the_title(); ?></a>
                                </h3>
                            </div>
                            <?php echo wp_kses_post($content); ?>
                            <?php if($settings['read_more']): ?>
                                <a href="<?php echo esc_url( $post_link ); ?>" class="default-btn"><span class="ri-arrow-right-s-line"></span><?php echo esc_html($settings['read_more']); ?></a>
                            <?php endif; ?>
                        </div>
                    <?php endwhile; ?>
                    <?php wp_reset_query(); ?>
                </div>
            </div>
        <?php else: ?>
            <div class="container">
                <div class="row justify-content-center">
                    <?php while($services_array->have_posts()):
                        $services_array->the_post();

                        // ACF Fields
                        $icon       = get_field('service_icon_image');
                        $content    = get_field('services_card_content');

                        if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        }
                        ?>
                        <div class="<?php echo esc_attr( $column );?>">
                            <div class="cyber-security-services-card">
                                <div class="row align-items-center">
                                    <?php if(has_post_thumbnail()) : ?>
                                    <div class="col-lg-6 col-md-6">
                                        <div class="services-image">
                                            <img src="<?php echo get_the_post_thumbnail_url( get_the_ID()); ?>" alt="<?php the_post_thumbnail_caption(); ?>">
                                        </div>
                                    </div>
                                    <?php endif; ?>

                                    <div class="col-lg-6 col-md-6">
                                        <div class="services-content">
                                            <h3>
                                                <a href="<?php echo esc_url( $post_link ); ?>"><?php the_title(); ?></a>
                                            </h3>
                                            <p><?php echo get_the_excerpt(); ?></p>
                                            <?php if($settings['read_more']): ?>
                                                <a href="<?php echo esc_url( $post_link ); ?>" class="services-btn"><?php echo esc_html($settings['read_more']); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                    <?php wp_reset_query(); ?>

                    <?php if( $settings['button_text'] != '' ): ?>
                        <div class="col-lg-12 col-md-12">
                            <div class="view-all-services-btn">
                                <a href="<?php echo esc_url( $link ); ?>" class="default-btn style-two"><span class="ri-arrow-right-s-line"></span><?php echo esc_html( $settings['button_text'] ); ?></a>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Services );