<?php
/**
 * RoadMap Info Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Gauch_RoadMap extends Widget_Base {

	public function get_name() {
        return 'Gauch_Road_Map';
    }

	public function get_title() {
        return esc_html__( 'Road map', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-image-rollover';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Features_Info',
			[
				'label' => esc_html__( 'Road map', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

			$repeater = new Repeater();
            $repeater->add_control(
                'top_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Top Title', 'gauch-toolkit' ),
                    'default' => 'Email Marketing'
                ]
            );
            $repeater->add_control(
                'title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Title', 'gauch-toolkit' ),
                    'default' => 'Email Marketing'
                ]
            );
            $repeater->add_control(
                'content', [
					'type'    => Controls_Manager::TEXTAREA,
					'label'   => esc_html__( 'Content', 'gauch-toolkit' ),
                    'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.'
                ]
            );
            $this->add_control(
                'items',
                [
                    'label'   => esc_html__( 'Add Items', 'gauch-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'toptitle_color',
                [
                    'label'     => esc_html__( 'Top Title Color', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .roadmap-style-card .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'toptitle_bgcolor',
                [
                    'label'     => esc_html__( 'Top Title Background Color', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .roadmap-style-card .sub-title' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'toptitle_typography',
                    'label'    => __( 'Top Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .roadmap-style-card .sub-title',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label'     => esc_html__( 'Title Color', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .roadmap-style-card .content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .roadmap-style-card .content h3',
                ]
            );

            $this->add_control(
                'content_color',
                [
                    'label'     => esc_html__( 'Content Color', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .roadmap-style-card .content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .roadmap-style-card .content p',
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        ?>
            <div class="container">
                <div class="roadmap-slides owl-carousel owl-theme">
                    <?php foreach($settings['items'] as $item): ?> 
                        <div class="roadmap-style-card">
                            <span class="sub-title"><?php echo esc_html($item['top_title']); ?></span>
                            
                            <div class="content">
                                <h3><?php echo esc_html($item['title']); ?></h3>
                                <p><?php echo wp_kses_post($item['content']); ?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_RoadMap );