<?php
/**
 * Project Widget
 */

namespace Elementor;
class Gauch_Project extends Widget_Base {

	public function get_name() {
        return 'ProjectSlider';
    }

	public function get_title() {
        return __( 'Project Slider', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-post-slider';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'project_section',
			[
				'label' => __( 'Project', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
            'cat_name',
            [
                'label' => __( 'Choose Category', 'gauch-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => gauch_toolkit_get_page_project_cat_el(),
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __( 'Project Order By', 'gauch-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
					'DESC'      => __( 'DESC', 'gauch-toolkit' ),
					'ASC'       => __( 'ASC', 'gauch-toolkit' ),
				],
				'default' => 'DESC',
            ]
        );

        $this->add_control(
			'count',
			[
				'label' => __( 'Post Per Page', 'gauch-toolkit' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 3,
			]
        );

        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'gauch-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('View More', 'gauch-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button_icon', [
                'label' => esc_html__( 'Button Icon', 'gauch-toolkit' ),
                'type' => Controls_Manager::ICON,
                'label_block' => true,
                'options' => gauch_icons(),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => __( 'Image Background', 'plugin-domain' ),
                'types' => [ 'classic' ],
                'selector' => '{{WRAPPER}} .single-case-studies-box .image::before',
            ]
        );

        $this->add_control(
            'shape1',
            [
                'label' => __( 'Shape Image 1', 'gauch-toolkit' ),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape2',
            [
                'label' => __( 'Shape Image 2', 'gauch-toolkit' ),
                'type'  => Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'gauch-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-case-studies-box .content h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __( 'Title Typography', 'gauch-toolkit' ),
                'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .single-case-studies-box .content h3',
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => esc_html__( 'Content Color', 'gauch-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .owl-item.active .single-case-studies-box .content p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __( 'Content Typography', 'gauch-toolkit' ),
                'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .owl-item.active .single-case-studies-box .content p',
            ]

        );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Project Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'project',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'project_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'project',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order']
            );
        }
        $project_array = new \WP_Query( $args );
        ?>
        <div class="container">
            <div class="case-studies-slides owl-carousel owl-theme">
                <?php
                $single_idd = get_the_ID();
                while ($project_array->have_posts()): $project_array->the_post();
                    $idd = get_the_ID();
                    $terms = wp_get_post_terms(get_the_ID(), 'project_cat');

                    $output = array();

                    // ACF Fields
                    $icon               = get_field('service_icon_image');
                    $content            = get_field('services_card_content');
                    $framework_label    = get_field('framework_label');
                    $framework_value    = get_field('framework_value');
                    $category_label     = get_field('category_label');
                    $category_value     = get_field('category_value');
                    $web_link_label     = get_field('web_link_label');
                    $web_link_value     = get_field('web_link_value');

                    if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                        $post_link = get_the_permalink();
                    } else {
                        $post_link = get_field('external_link');
                    }
                    if($single_idd != $idd):
                        ?>
                        <div class="single-case-studies-box">
                            <div class="row align-items-center m-0">
                                <div class="col-lg-6 col-md-12 p-0">
                                    <div class="content">
                                        <div class="logo">
                                            <?php if($icon): ?>
                                                <img src="<?php echo esc_url($icon); ?>" alt="<?php the_post_thumbnail_caption();  ?>">
                                            <?php endif; ?>
                                        </div>
                                        <h3>
                                            <a href="<?php echo esc_url( $post_link ); ?>"><?php the_title(); ?></a>
                                        </h3>

                                        <?php echo wp_kses_post($content); ?>

                                        <ul class="features-list">
                                            <?php if($framework_label): ?>
                                                <li>
                                                    <span><?php echo esc_html($framework_label); ?></span>
                                                    <a href="<?php echo esc_url( $post_link ); ?>"><?php echo esc_html($framework_value); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($category_label): ?>
                                                <li>
                                                    <span><?php echo esc_html($category_label); ?></span>
                                                    <a href="<?php echo esc_url( $post_link ); ?>"><?php echo esc_html($category_value); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($web_link_label): ?>
                                                <li>
                                                    <span><?php echo esc_html($web_link_label); ?></span>
                                                    <a href="<?php echo esc_url( $web_link_value ); ?>"><?php echo esc_html($web_link_value); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>

                                        <?php if( $settings['button_text'] ): ?>
                                            <a href="<?php echo esc_url( $post_link ); ?>" class="default-btn"><span class="<?php echo esc_attr( $settings['button_icon'] ); ?>"></span><?php echo esc_html( $settings['button_text'] ); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-12 p-0">
                                    <?php if(has_post_thumbnail()): ?>
                                        <div class="image">
                                            <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'gauch_project_thumb'); ?>" alt="<?php the_post_thumbnail_caption(); ?>">
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endwhile; ?>
                <?php wp_reset_query(); ?>
            </div>
        </div>

        <?php if($settings['shape1']['url'] != ''): ?>
            <div class="shape7">
                <img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "gauch-toolkit"); ?>">
            </div>
        <?php endif; ?>
        <?php if($settings['shape2']['url'] != ''): ?>
            <div class="shape8">
                <img src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "gauch-toolkit"); ?>">
            </div>
        <?php endif; ?>

        <?php
	}


}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Project );