<?php
/**
 * Partner Logo Two Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Gauch_Partner_Logo_Two extends Widget_Base {

	public function get_name() {
        return 'Partner_Logo_Two';
    }

	public function get_title() {
        return __( 'Partner Logo Two', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-logo';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_partner_Section',
			[
				'label' => __( 'Section', 'gauch-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'style',
                [
                    'label' => __( 'Section Style', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style 1', 'gauch-toolkit' ),
                        '2'   => __( 'Style 2', 'gauch-toolkit' ),
                        '3'   => __( 'Style 3', 'gauch-toolkit' ),
                        '4'   => __( 'Style 4', 'gauch-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'bg_img', [
                    'type'    => Controls_Manager::MEDIA,
                    'label'   => esc_html__( 'Background Image', 'gauch-toolkit' ),
                    'condition' => [
                        'style' => '2',
                    ]
                ]
            );

            $repeater = new Repeater();
            $repeater->add_control(
                'logo', [
                    'type'    => Controls_Manager::MEDIA,
                    'label'   => esc_html__( 'Logo', 'gauch-toolkit' ),
                ]
            );
            $repeater->add_control(
                'logo_link', [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => esc_html__( 'Logo Link', 'gauch-toolkit' ),
                    'default' => '#'
                ]
            );
            $this->add_control(
                'logos',
                [
                    'label'   => esc_html__( 'Add Partner Logo', 'gauch-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings_for_display();
        ?>

        <?php if($settings['style'] == '1'): ?>
            <div class="partner-area">
                <div class="container">
                    <div class="partner-slides owl-carousel owl-theme">
                        <?php foreach( $settings['logos'] as $item ): ?>
                            <div class="partner-item">
                                <a href="<?php echo esc_url( $item['logo_link'] ); ?>" class="d-block"><img src="<?php echo esc_url( $item['logo']['url'] ); ?>" alt="<?php echo esc_attr__( 'Partner Logo', 'gauch-toolkit' ); ?>"></a>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '2'): ?>
            <div class="container">
                <div class="industry-partner-inner-box pt-100 pb-70" style="background-image:url(<?php echo esc_url( $settings['bg_img']['url'] ); ?>);">
                    <div class="partner-slides owl-carousel owl-theme">
                        <?php foreach( $settings['logos'] as $item ): 
                            if( $item['logo']['url'] != '' ) : ?>
                            <div class="partner-card">
                                <a href="<?php echo esc_url( $item['logo_link'] ); ?>" class="d-block"><img src="<?php echo esc_url( $item['logo']['url'] ); ?>" alt="<?php echo esc_attr__( 'Partner Logo', 'gauch-toolkit' ); ?>"></a>
                            </div>
                            <?php endif;
                        endforeach; ?>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '3'): ?>
            <div class="container">
                <div class="partner-slides owl-carousel owl-theme">
                    <?php foreach( $settings['logos'] as $item ): 
                        if( $item['logo']['url'] != '' ) : ?>
                        <div class="partner-card-box">
                            <a href="<?php echo esc_url( $item['logo_link'] ); ?>" class="d-block"><img src="<?php echo esc_url( $item['logo']['url'] ); ?>" alt="<?php echo esc_attr__( 'Partner Logo', 'gauch-toolkit' ); ?>"></a>
                        </div>
                        <?php endif;
                    endforeach; ?>
                </div>
            </div>
        <?php else: ?>
            <div class="container">
                <div class="industry-partner-inner-box-wrap pt-100 pb-70">
                    <div class="row align-items-center">
                        <?php foreach( $settings['logos'] as $item ): 
                            if( $item['logo']['url'] != '' ) : ?>
                            <div class="col-lg-2 col-6 col-sm-3 col-md-3">
                                <div class="partner-card">
                                    <a href="<?php echo esc_url( $item['logo_link'] ); ?>" class="d-block"><img src="<?php echo esc_url( $item['logo']['url'] ); ?>" alt="<?php echo esc_attr__( 'Partner Logo', 'gauch-toolkit' ); ?>"></a>
                                </div>
                            </div>
                            <?php endif;
                        endforeach; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Partner_Logo_Two );