<?php
/**
 * Page Banner Widget
 */

namespace Elementor;
class Gauch_Page_Banner extends Widget_Base {

	public function get_name() {
        return 'PageBanner';
    }

	public function get_title() {
        return __( 'Page Banner', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-banner';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Page_Banner',
			[
				'label' => __( 'Gauch Section', 'gauch-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'page_title',
                [
                    'label'   => __( 'Page Title', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __('Case Studies', 'gauch-toolkit'),
                ]
            );
            $this->add_control(
                'home_text',
                [
                    'label'   => __( 'Home', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::TEXT,
                    'default' => __('Home', 'gauch-toolkit'),
                ]
            );

            $this->add_control(
                'hide_breadcrumb',
                [
                    'label'   => esc_html__( 'Hide Breadcrumb', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'yes'           => esc_html__( 'Yes', 'gauch-toolkit' ),
                        'no'            => esc_html__( 'No', 'gauch-toolkit' ),
                    ],
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'style',
                [
                    'label'   => esc_html__( 'Style', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        '1'           => esc_html__( 'Style One', 'gauch-toolkit' ),
                        '2'            => esc_html__( 'Style Two', 'gauch-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label'   => esc_html__( 'Title Tag', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'gauch-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'gauch-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'gauch-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'gauch-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'gauch-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'gauch-toolkit' ),
                    ],
                    'default' => 'h1',
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => __( 'Content', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::WYSIWYG,
                ]
            );

            $repeater = new Repeater();
            $repeater->add_control(
                'image', [
					'type'    => Controls_Manager::MEDIA,
					'label'   => esc_html__( 'Image', 'gauch-toolkit' ),
                ]
            );
            $repeater->add_control(
                'image_link', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Image Link', 'gauch-toolkit' ),
                    'default' => '#'
                ]
            );
            $this->add_control(
                'items',
                [
                    'label'   => esc_html__( 'Add Image', 'gauch-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'condition' => [
                        'style' => '1',
                    ]
                ]
            );

            $items = new Repeater();
            $items->add_control(
                'icon', [
					'type'    => Controls_Manager::ICON,
					'label'   => esc_html__( 'Icon', 'gauch-toolkit' ),
                    'label_block' => true,
                    'options' => gauch_icons(),
                ]
            );
            $items->add_control(
                'title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Title', 'gauch-toolkit' ),
                    'label_block' => true,
                    'default' => 'Address:'
                ]
            );
            $items->add_control(
                'content', [
					'type'    => Controls_Manager::WYSIWYG,
					'label'   => esc_html__( 'Content', 'gauch-toolkit' ),
                ]
            );
            $this->add_control(
                'card_items',
                [
                    'label'   => esc_html__( 'Add Card', 'gauch-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $items->get_controls(),
                    'condition' => [
                        'style' => '2',
                    ]
                ]
            );

            $this->add_control(
                'bg', [
					'type'    => Controls_Manager::MEDIA,
					'label'   => esc_html__( 'Section Background Image', 'gauch-toolkit' ),
                ]
            );
            $this->add_control(
                'shape1', [
					'type'    => Controls_Manager::MEDIA,
					'label'   => esc_html__( 'Shape Image One', 'gauch-toolkit' ),
                ]
            );
            $this->add_control(
                'shape2', [
					'type'    => Controls_Manager::MEDIA,
					'label'   => esc_html__( 'Shape Image Two', 'gauch-toolkit' ),
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        ?>
        <div class="page-title-area" style="background-image:url(<?php echo esc_url($settings['bg']['url']); ?>);">
            <div class="container">
                <div class="page-title-content text-center">
                    <?php if($settings['page_title']): ?>
                        <<?php echo esc_attr( $settings['title_tag'] ); ?>>
                            <?php echo esc_html( $settings['page_title'] ); ?>
                        </<?php echo esc_attr( $settings['title_tag'] ); ?>>
                    <?php else: ?>
                        <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php the_title(); ?><<?php echo esc_attr( $settings['title_tag'] ); ?>>
                    <?php endif; ?>

                    <?php if($settings['hide_breadcrumb'] == 'yes'): ?>
                        <ul>
                            <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo esc_html($settings['home_text']); ?></a></li>
                            <?php if($settings['page_title']): ?>
                                <li>
                                    <?php echo esc_html( $settings['page_title'] ); ?>
                                </li>
                            <?php else: ?>
                                <li><?php the_title(); ?></li>
                            <?php endif; ?>
                        </ul>
                    <?php endif; ?>
                    <?php if($settings['style'] == '1'): ?>
                        <div class="clients-list">
                            <span><?php echo wp_kses_post($settings['content']); ?></span>
                            <div class="row justify-content-center">
                                <?php foreach( $settings['items'] as $item ): ?>
                                    <div class="col-lg-2 col-4 col-sm-3 col-md-2">
                                        <div class="box">
                                            <a href="<?php echo esc_url( $item['image_link'] ); ?>" target="_blank"><img src="<?php echo esc_url( $item['image']['url'] ); ?>" alt="<?php echo esc_attr__( 'Banner Logo', 'gauch-toolkit' ); ?>"></a>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php elseif($settings['style'] == '2'): ?>
                        <span><?php echo wp_kses_post($settings['content']); ?></span>
                        <div class="row justify-content-center">
                            <?php foreach( $settings['card_items'] as $item ): ?>
                                <div class="col-lg-3 col-sm-6 col-md-6">
                                    <div class="single-contact-info-box">
                                        <div class="icon">
                                            <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                        </div>
                                        <h3><?php echo esc_html( $item['title'] ); ?></h3>
                                        <?php echo wp_kses_post( $item['content'] ); ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
            <?php if($settings['shape1']['url'] != ''): ?>
                <div class="shape1"><img src="<?php echo esc_url($settings['shape1']['url']); ?>" alt="<?php echo esc_attr__( 'Banner Shape', 'gauch-toolkit' ); ?>"></div>
            <?php endif; ?>
            <?php if($settings['shape2']['url'] != ''): ?>
                <div class="shape3"><img src="<?php echo esc_url($settings['shape2']['url']); ?>" alt="<?php echo esc_attr__( 'Banner Shape', 'gauch-toolkit' ); ?>"></div>
            <?php endif; ?>
        </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Page_Banner );