<?php
/**
 * Newsletter Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Gauch_Newsletter extends Widget_Base {

	public function get_name() {
        return 'Gauch_Newsletter';
    }

	public function get_title() {
        return __( 'Newsletter', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-email-field';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

    public function get_keywords() {
        return [ 'mailchimp', 'form', 'newsletter' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Newsletter',
			[
				'label' => __( 'Gauch Newsletter', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_group_control(
               Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'label' => __( 'Background', 'gauch-toolkit' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .subscribe-inner',
                ]
            );

            $this->add_control(
                'action_url', [
                    'label' => esc_html__( 'Action URL', 'gauch-toolkit' ),
                    'description' => __( 'Enter here your MailChimp action URL. <a href="https://docs.envytheme.com/docs/gauch-theme-documentation/tips-guides-troubleshoots/get-mailchimp-newsletter-form-action-url/" target="_blank"> How to </a>', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'top_title', [
                    'label' => __( 'Top Title', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'READY TO GET STARTED', 'gauch-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'title', [
                    'label' => __( 'Title', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Subscribe to Our Newsletter' , 'gauch-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'gauch-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'gauch-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'gauch-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'gauch-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'gauch-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'gauch-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

            $this->add_control(
                'content', [
                    'label' => __( 'Description', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.' , 'gauch-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'placeholder_text', [
                    'label' => __( 'Email Placeholder Text', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Enter your email address' , 'gauch-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'button_text', [
                    'label' => __( 'Button text', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Subscribe Now' , 'gauch-toolkit' ),
                    'label_block' => true,
                ]
            );
            $this->add_control(
				'button_icon',
				[
					'label' => esc_html__( 'Button Icon', 'gauch-toolkit' ),
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'options' => gauch_icons(),
				]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'newsletter_style',
			[
				'label' => __( 'Style', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .subscribe-inner .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .subscribe-inner .sub-title',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .subscribe-inner h2, .subscribe-inner h3, .subscribe-inner h4, .subscribe-inner h5, .subscribe-inner h5, .subscribe-inner h6, .subscribe-inner h1, .subscribe-inner.text-left h2' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .subscribe-inner h2, .subscribe-inner h3, .subscribe-inner h4, .subscribe-inner h5, .subscribe-inner h5, .subscribe-inner h6, .subscribe-inner h1, .subscribe-inner.text-left h2',
                ]
            );

            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .subscribe-inner p, .subscribe-inner.text-left p' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .subscribe-inner p, .subscribe-inner.text-left p',
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $this-> add_inline_editing_attributes('content','none');

        // Button Icon
        if( $settings['button_icon'] != '' ):
            $icon = $settings['button_icon'];
        else:
            $icon = 'ri-arrow-right-s-line';
        endif;
        ?>
        <div class="subscribe-area">
            <div class="container">
                <div class="subscribe-inner">
                    <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                    <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                    <p <?php echo $this-> get_render_attribute_string('content'); ?>><?php echo wp_kses_post( $settings['content'] ); ?></p>

                    <form class="mailchimp newsletter-form" method="post">
                        <div class="subcribes">
                            <input type="email" class="input-newsletter memail" placeholder="<?php echo esc_attr( $settings['placeholder_text'] ); ?>" name="EMAIL" required>
                            <?php if( $settings['button_text'] != '' ): ?>
                                <button type="submit"><?php echo esc_html( $settings['button_text'] ); ?><i class="<?php echo esc_attr( $icon ); ?>"></i></button>
                            <?php endif; ?>
                        </div>
                        <p class="mchimp-errmessage" style="display: none;"></p>
                        <p class="mchimp-sucmessage" style="display: none;"></p>
                    </form>
                </div>
            </div>
        </div>

        <script>
            ;(function($){
                "use strict";
                $(document).ready(function () {
                    // MAILCHIMP
                    if ($(".mailchimp").length > 0) {
                        $(".mailchimp").ajaxChimp({
                            callback: mailchimpCallback,
                            url: "<?php echo esc_js($settings['action_url']) ?>"
                        });
                    }
                    if ($(".mailchimp_two").length > 0) {
                        $(".mailchimp_two").ajaxChimp({
                            callback: mailchimpCallback,
                            url: "<?php echo esc_js($settings['action_url']) ?>" //Replace this with your own mailchimp post URL. Don't remove the "". Just paste the url inside "".
                        });
                    }
                    $(".memail").on("focus", function () {
                        $(".mchimp-errmessage").fadeOut();
                        $(".mchimp-sucmessage").fadeOut();
                    });
                    $(".memail").on("keydown", function () {
                        $(".mchimp-errmessage").fadeOut();
                        $(".mchimp-sucmessage").fadeOut();
                    });
                    $(".memail").on("click", function () {
                        $(".memail").val("");
                    });

                    function mailchimpCallback(resp) {
                        if (resp.result === "success") {
                            $(".mchimp-errmessage").html(resp.msg).fadeIn(1000);
                            $(".mchimp-sucmessage").fadeOut(500);
                        } else if (resp.result === "error") {
                            $(".mchimp-errmessage").html(resp.msg).fadeIn(1000);
                        }
                    }
                });
            })(jQuery)
        </script>
    <?php
	}


}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Newsletter );