<?php
/**
 * Get Started Area Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Gauch_GetStart_Area extends Widget_Base {

	public function get_name() {
        return 'Gauch_GetStarted';
    }

	public function get_title() {
        return esc_html__( 'Get Started Area', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Get_Area',
			[
				'label' => esc_html__( 'Get Started Area', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'style',
                [
                    'label' => __( 'Services Style', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style 1', 'gauch-toolkit' ),
                        '2'   => __( 'Style 2', 'gauch-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'top_title',
                [
                    'label' => esc_html__( 'Top Title', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('ABOUT GAUCH', 'gauch-toolkit'),
                ]
            );

            $this->add_control(
                'title',
                [
                    'label' => esc_html__( 'Title', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('A Few Words About Us', 'gauch-toolkit'),
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'gauch-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'gauch-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'gauch-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'gauch-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'gauch-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'gauch-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => esc_html__( 'Content', 'gauch-toolkit' ),
                    'type' => Controls_Manager::WYSIWYG,
                    'default' => esc_html__('Cloud based storage for your data backup just log in with your mail account from play store and using whatever you want for your business purpose orem ipsum dummy text. Never missyour chance its just began.', 'gauch-toolkit'),
                ]
            );

            $this->add_control(
				'button_text',
				[
					'label' 	=> esc_html__( 'Left Button Text', 'gauch-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Read More', 'gauch-toolkit'),
				]
            );

            $this->add_control(
                'link_type',
                [
                    'label' 		=> esc_html__( 'Left Button Link Type', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' => [
                        '1'  	=> esc_html__( 'Link To Page', 'gauch-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'gauch-toolkit' ),
                    ],
                ]
            );

            $this->add_control(
                'link_to_page',
                [
                    'label' 		=> esc_html__( 'Left Button Link Page', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> gauch_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                    ]
                ]
            );

            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Left Button External Link', 'gauch-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );

            $this->add_control(
                'sec_image',
                [
                    'label' => __( 'Section Feature Image', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'sectionget_style',
			[
				'label' => esc_html__( 'Style', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'gettop_title_bgcolor',
                [
                    'label'     => esc_html__( 'Top Title Background', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .get-started-content .sub-title' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'gettop_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .get-started-content .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'gettop_title_typography',
                    'label' => __( 'Top Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .get-started-content .sub-title',
                ]
            );

            $this->add_control(
                'gettitle_color',
                [
                    'label' => esc_html__( 'Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .get-started-content h2, .get-started-content h1, .get-started-content h3, .get-started-content h4, .get-started-content h5, .get-started-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'gettitle_typography',
                    'label' => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .get-started-content h2, .get-started-content h1, .get-started-content h3, .get-started-content h4, .get-started-content h5, .get-started-content h6',
                ]
            );

            $this->add_control(
                'getcontent_color',
                [
                    'label' => esc_html__( 'Content Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .get-started-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'getcontent_typography',
                    'label' => __( 'Content Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .get-started-content p',
                ]
            );
            $this->add_control(
                'getbtn_color',
                [
                    'label' => esc_html__( 'Button Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .default-btn.style-two span, .default-btn.style-two' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $this-> add_inline_editing_attributes('content','none');

        // Get Button Link
        if($settings['link_type'] == 1){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }

        ?>

        <?php if($settings['style'] == '1'): ?>
            <div class="container">
                <div class="row">
                    <?php if($settings['sec_image']['url']): ?>
                    <div class="col-lg-6 col-md-12">
                        <?php if($settings['sec_image']['url']): ?>
                            <div class="get-started-image">
                                <img src="<?php echo esc_url( $settings['sec_image']['url'] ) ?>" alt="<?php echo esc_attr__('image','gauch-toolkit'); ?>">
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="col-lg-6 col-md-12">
                    <?php else: ?>
                    <div class="col-lg-12 col-md-12">
                    <?php endif; ?>
                        <div class="get-started-content">
                            <?php if( $settings['top_title'] != '' ): ?>
                                <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                            <?php endif; ?>

                            <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo wp_kses_post( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                            <?php echo wp_kses_post( $settings['content'] ); ?>

                            <?php if( $settings['button_text'] != '' ): ?>
                                <a href="<?php echo esc_url( $link ); ?>" class="default-btn style-two"><span class="ri-arrow-right-s-line"></span><?php echo esc_html( $settings['button_text'] ); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>

                </div>
            </div>
        <?php elseif($settings['style'] == '2'): ?>
            <div class="container">
                <div class="row">
                    <?php if($settings['sec_image']['url']): ?>
                    <div class="col-lg-6 col-md-12">
                        <?php if($settings['sec_image']['url']): ?>
                            <div class="get-started-image">
                                <img src="<?php echo esc_url( $settings['sec_image']['url'] ) ?>" alt="<?php echo esc_attr__('image','gauch-toolkit'); ?>">
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="col-lg-6 col-md-12">
                    <?php else: ?>
                    <div class="col-lg-12 col-md-12">
                    <?php endif; ?>
                        <div class="get-started-content white-color">
                            <?php if( $settings['top_title'] != '' ): ?>
                                <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                            <?php endif; ?>

                            <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo wp_kses_post( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                            <?php echo wp_kses_post( $settings['content'] ); ?>

                            <?php if( $settings['button_text'] != '' ): ?>
                                <a href="<?php echo esc_url( $link ); ?>" class="default-btn style-two"><span class="ri-arrow-right-s-line"></span><?php echo esc_html( $settings['button_text'] ); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>

                </div>
            </div>
        <?php endif; ?>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_GetStart_Area );