<?php
    require_once 'chatgpt-assistant-image-generator-actions-options.php';
?>
<div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-empty-key-notice" <?php echo ($check_openai_connection_code) ? 'style="display:none"' : '' ?>>
    <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-empty-key-notice-container">
        <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-empty-key-notice-left">
            <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-empty-key-notice-icon">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" fill="#F2AB26" width="25" height="25">
                    <path d="M256 32c14.2 0 27.3 7.5 34.5 19.8l216 368c7.3 12.4 7.3 27.7 .2 40.1S486.3 480 472 480H40c-14.3 0-27.6-7.7-34.7-20.1s-7-27.8 .2-40.1l216-368C228.7 39.5 241.8 32 256 32zm0 128c-13.3 0-24 10.7-24 24V296c0 13.3 10.7 24 24 24s24-10.7 24-24V184c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"/>
                </svg>
            </div>
            <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-empty-key-notice-text">
                <p>
                    <?php echo esc_html(__('Please enter your OpenAI API Key!', 'ays-chatgpt-assistant')); ?>
                </p>
            </div>
        </div>
        <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-empty-key-notice-right">
            <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-empty-key-notice-button">
                <a href="<?php echo esc_url(admin_url('admin.php?page=' . $this->plugin_name . '&ays_tab=tab3')); ?>"><?php echo esc_html(__('Go to Settings', 'ays-chatgpt-assistant')); ?></a>
            </div>
        </div>
    </div>
</div>
<div class="wrap">
    <form method="post" id="ays-image-generator-form">
        <h1 class="wp-heading-inline">
            <?php
                echo esc_html( get_admin_page_title()) ;
            ?>
        </h1>
    
        <div id="poststuff">
            <div id="post-body" class="metabox-holder">
                <div id="post-body-content">
                    <div class="form-group row p-3">
                        <input type="hidden" class="ays-chatgpt-assistant-openai-api-key" value="<?php echo esc_attr($api_key) ?>">
                        <div class="col-sm-3 p-4">
                            <div class="row m-0 mb-3">
                                <label for="ays-chatgpt-assistant-ig-select-model" class="form-label"><?php echo esc_html(__('Model', 'ays-chatgpt-assistant')); ?></label>
                                <select class="form-select" id="ays-chatgpt-assistant-ig-select-model">
                                    <?php foreach ($models as $key => $value) : ?>
                                        <option value="<?php echo esc_attr($key); ?>"><?php echo esc_attr($value); ?></option>
                                    <?php endforeach; ?>
                                    <option disabled>DALL·E 3 (ChatGPT Plus) (PRO)</option>
                                </select>
                            </div>
                            <div class="row m-0 mb-3">
                                <label for="ays-chatgpt-assistant-ig-select-size" class="form-label"><?php echo esc_html(__('Size', 'ays-chatgpt-assistant')); ?></label>
                                <select class="form-select" id="ays-chatgpt-assistant-ig-select-size">
                                    <?php foreach ($sizes as $key => $value) : ?>
                                        <option value="<?php echo esc_attr($key); ?>"><?php echo esc_attr($value); ?></option>
                                    <?php endforeach; ?>
                                    <option disabled>1792x1024 (DALL·E 3) (PRO)</option>
                                    <option disabled>1024x1792 (DALL·E 3) (PRO)</option>
                                </select>
                            </div>
                            <div class="row m-0 mb-3">
                                <label for="ays-chatgpt-assistant-ig-select-style" class="form-label"><?php echo esc_html(__('Style', 'ays-chatgpt-assistant')); ?></label>
                                <select class="form-select" id="ays-chatgpt-assistant-ig-select-style">
                                    <?php foreach ($styles as $key => $value) : ?>
                                        <option value="<?php echo esc_attr($key); ?>"><?php echo esc_attr($value); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="row m-0 mb-3">
                                <label for="ays-chatgpt-assistant-ig-select-resolution" class="form-label"><?php echo esc_html(__('Resolution', 'ays-chatgpt-assistant')); ?></label>
                                <select class="form-select" id="ays-chatgpt-assistant-ig-select-resolution">
                                    <?php foreach ($resolutions as $key => $value) : ?>
                                        <option value="<?php echo esc_attr($key); ?>"><?php echo esc_attr($value); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="row m-0 mb-3">
                                <label for="ays-chatgpt-assistant-ig-select-photography" class="form-label"><?php echo esc_html(__('Photography', 'ays-chatgpt-assistant')); ?></label>
                                <select class="form-select" id="ays-chatgpt-assistant-ig-select-photography">
                                    <?php foreach ($photography as $key => $value) : ?>
                                        <option value="<?php echo esc_attr($key); ?>"><?php echo esc_attr($value); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-9 p-4 d-flex flex-column justify-content-between">
                            <div class="m-0">
                                <div class="row m-0 mb-3">
                                    <label for="ays-chatgpt-assistant-ig-prompt" class="form-label"><?php echo esc_html(__('Prompt', 'ays-chatgpt-assistant')); ?></label>
                                    <textarea id="ays-chatgpt-assistant-ig-prompt" style="resize:none;height:<?php echo esc_attr($textarea_height)?>px"></textarea>
                                </div>
                                <div class="row m-0">
                                    <button type="button" id="ays-chatgpt-assistant-ig-generate" class="btn btn-outline-primary btn-md" style="width:fit-content"><?php echo esc_html(__('Generate', 'ays-chatgpt-assistant')); ?> <i class="fa fa-spinner fa-spin display_none"></i></button>
                                </div>
                            </div>
                            <div class="m-0">
                                <div class="row m-0 ays-chatgpt-assistant-image-generator-buttons ays-chatgpt-assistant-image-box-template">
                                    <div>
                                        <a role="button" target="_blank" download="image" class="ays-chatgpt-assistant-ig-download btn btn-primary btn-md w-100"><?php echo esc_html(__('Download', 'ays-chatgpt-assistant')); ?></a>
                                        <button type="button" class="ays-chatgpt-assistant-ig-save-media btn btn-secondary btn-md w-100"><?php echo esc_html(__('Add to Media', 'ays-chatgpt-assistant')); ?> <i class="fa fa-spinner fa-spin display_none"></i></button>
                                    </div>
                                </div>
                                <div class="row m-0 mt-4 ays-chatgpt-assistant-image-generator-img"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>