<?php
    $data = $this->db_obj->get_data();

    $api_key = isset( $data['api_key'] ) && $data['api_key'] != '' ? esc_attr( $data['api_key'] ) : '';
    
    $check_openai_connection = ChatGPT_assistant_Data::makeRequest($api_key, 'GET', 'models');
    $check_openai_connection_code = false;
    
    if(is_array($check_openai_connection)){
        $check_openai_connection_code = isset($check_openai_connection['openai_response_code']) && $check_openai_connection['openai_response_code'] == 200 ? true : false; 
    }

    // General settings options start

        $general_options = (empty($this->general_settings_obj->get_all_data())) ? array() : $this->general_settings_obj->get_all_data();
                    
        $textarea_height = isset( $general_options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'textarea_height'] ) && intval($general_options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'textarea_height']) > 0 ? esc_attr($general_options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'textarea_height']) : 70;

    // General settings options end

    $models = array(
        'dall-e-2' => 'DALL·E 2',
        // 'dall-e-3' => 'DALL·E 3 (ChatGPT Plus) (PRO)',
    );

    $styles = array(
        "vivid" => __("Vivid (hyper-real and dramatic images)", "ays-chatgpt-assistant"),
        "natural" => __("Natural (natural, less hyper-real looking images)", "ays-chatgpt-assistant"),
    );
    
    $photography = array(
        "Portrait" => __("Portrait", "ays-chatgpt-assistant"),
        "Landscape" => __("Landscape", "ays-chatgpt-assistant"),
        "Abstract" => __("Abstract", "ays-chatgpt-assistant"),
        "Action" => __("Action", "ays-chatgpt-assistant"),
        "Aerial" => __("Aerial", "ays-chatgpt-assistant"),
        "Agricultural" => __("Agricultural", "ays-chatgpt-assistant"),
        "Animal" => __("Animal", "ays-chatgpt-assistant"),
        "Architectural" => __("Architectural", "ays-chatgpt-assistant"),
        "Astrophotography" => __("Astrophotography", "ays-chatgpt-assistant"),
        "Bird photography" => __("Bird photography", "ays-chatgpt-assistant"),
        "Black and white" => __("Black and white", "ays-chatgpt-assistant"),
        "Candid" => __("Candid", "ays-chatgpt-assistant"),
        "Cityscape" => __("Cityscape", "ays-chatgpt-assistant"),
        "Close-up" => __("Close-up", "ays-chatgpt-assistant"),
        "Commercial" => __("Commercial", "ays-chatgpt-assistant"),
        "Conceptual" => __("Conceptual", "ays-chatgpt-assistant"),
        "Corporate" => __("Corporate", "ays-chatgpt-assistant"),
        "Documentary" => __("Documentary", "ays-chatgpt-assistant"),
        "Event" => __("Event", "ays-chatgpt-assistant"),
        "Family" => __("Family", "ays-chatgpt-assistant"),
        "Fashion" => __("Fashion", "ays-chatgpt-assistant"),
        "Fine art" => __("Fine art", "ays-chatgpt-assistant"),
        "Food" => __("Food", "ays-chatgpt-assistant"),
        "Food photography" => __("Food photography", "ays-chatgpt-assistant"),
        "Glamour" => __("Glamour", "ays-chatgpt-assistant"),
        "Industrial" => __("Industrial", "ays-chatgpt-assistant"),
        "Lifestyle" => __("Lifestyle", "ays-chatgpt-assistant"),
        "Macro" => __("Macro", "ays-chatgpt-assistant"),
        "Nature" => __("Nature", "ays-chatgpt-assistant"),
        "Night" => __("Night", "ays-chatgpt-assistant"),
        "Product" => __("Product", "ays-chatgpt-assistant"),
        "Sports" => __("Sports", "ays-chatgpt-assistant"),
        "Street" => __("Street", "ays-chatgpt-assistant"),
        "Travel" => __("Travel", "ays-chatgpt-assistant"),
        "Underwater" => __("Underwater", "ays-chatgpt-assistant"),
        "Wedding" => __("Wedding", "ays-chatgpt-assistant"),
        "Wildlife" => __("Wildlife", "ays-chatgpt-assistant"),
        "None" => __("None", "ays-chatgpt-assistant")
    );    
    
    $resolutions = array(
        "4K (3840x2160)" => "4K (3840x2160)",
        "1080p (1920x1080)" => "1080p (1920x1080)",
        "720p (1280x720)" => "720p (1280x720)",
        "480p (854x480)" => "480p (854x480)",
        "2K (2560x1440)" => "2K (2560x1440)",
        "1080i (1920x1080)" => "1080i (1920x1080)",
        "720i (1280x720)" => "720i (1280x720)",
        "None" => "None"
    );

    $sizes = array(
        '1024x1024' => '1024x1024 (Both)',
        '256x256' => '256x256 (DALL·E 2)',
        '512x512' => '512x512 (DALL·E 2)',
        // '1792x1024' => '1792x1024 (DALL·E 3) (PRO)',
        // '1024x1792' => '1024x1792 (DALL·E 3) (PRO)',
    );
    
?>