<?php
if( isset( $_POST['ays_submit'] ) || isset( $_POST['ays_submit_top'] ) ) {
    $this->embedding_settings_obj->store_data(); 
}

$data = $this->db_obj->get_data();

$api_key = isset( $data['api_key'] ) && $data['api_key'] != '' ? esc_attr( $data['api_key'] ) : '';
$api_type = isset( $data['type'] ) && $data['type'] != '' ? esc_attr( $data['type'] ) : '';
$checked_connection = ChatGPT_assistant_Data::makeRequest($api_key, 'GET', 'models');
$check_openai_connection_code = false;

if(is_array($checked_connection)){
    $check_openai_connection_code = isset($checked_connection['openai_response_code']) && $checked_connection['openai_response_code'] == 200 ? true : false; 
}

$api_data = ChatGPT_assistant_Data::get_selected_api_for_request($data, 'embedding');

$ays_tab = isset($_GET['ays_tab']) ? sanitize_text_field($_GET['ays_tab']) : 'tab1';

$options = (empty($this->embedding_settings_obj->get_all_data())) ? array() : $this->embedding_settings_obj->get_all_data();

$all_post_types = get_post_types(array('public' => true));
if (array_key_exists( 'attachment', $all_post_types )) {
    unset($all_post_types['attachment']);
}

$chatgpt_assistant_enable_embedding = isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'enable_embedding'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'enable_embedding'] == 'on' ? 'checked' : '';
$chatgpt_assistant_pinecone_api_key = isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'pinecone_api_key'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'pinecone_api_key'] != '' ? sanitize_text_field($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'pinecone_api_key']) : '';
$chatgpt_assistant_pinecone_index = isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'pinecone_index'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'pinecone_index'] != '' ? sanitize_text_field($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'pinecone_index']) : '';
$chatgpt_assistant_pinecone_connection = isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'pinecone_connection'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'pinecone_connection'] != '' ? sanitize_text_field($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'pinecone_connection']) : false;
$chatgpt_assistant_embedding_text_id = isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'embedding_text_id'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'embedding_text_id'] != '' ? sanitize_text_field($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'embedding_text_id']) : '';
?>
<div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-empty-key-notice" <?php echo ($checked_connection) ? 'style="display:none"' : '' ?>>
    <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-empty-key-notice-container">
        <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-empty-key-notice-left">
            <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-empty-key-notice-icon">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" fill="#F2AB26" width="25" height="25">
                    <path d="M256 32c14.2 0 27.3 7.5 34.5 19.8l216 368c7.3 12.4 7.3 27.7 .2 40.1S486.3 480 472 480H40c-14.3 0-27.6-7.7-34.7-20.1s-7-27.8 .2-40.1l216-368C228.7 39.5 241.8 32 256 32zm0 128c-13.3 0-24 10.7-24 24V296c0 13.3 10.7 24 24 24s24-10.7 24-24V184c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z" />
                </svg>
            </div>
            <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-empty-key-notice-text">
                <p>
                    <?php echo esc_html(__('Please enter your OpenAI API Key!', 'ays-chatgpt-assistant')); ?>
                </p>
            </div>
        </div>
        <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-empty-key-notice-right">
            <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-empty-key-notice-button">
            <a href="<?php echo esc_url(admin_url('admin.php?page=' . $this->plugin_name . '&ays_tab=tab3')); ?>"><?php echo esc_html(__('Go to Settings', 'ays-chatgpt-assistant')); ?></a>
            </div>
        </div>
    </div>
</div>
<div class="wrap">
    <div class="container-fluid">
        <form method="post" id="ays-embeddings-form">
            <input type="hidden" name="ays_tab" value="<?php echo $ays_tab; ?>">
            <h1 class="wp-heading-inline">
            <?php
                echo esc_html(__('Embeddings',"ays-chatgpt-assistant"));
            ?>
            </h1>
            <hr>
            <br>
            <div class="ays-settings-wrapper">
                <input type="hidden" class="ays-assistant-chatbox-apikey" name="ays_assistant_chatbox_apikey" value="<?php echo esc_attr($api_key) ?>">
                <input type="hidden" class="ays-assistant-chatbox-apitype" name="ays_assistant_chatbox_apitype" value="<?php echo esc_attr($api_type) ?>">
                <div>
                    <div class="nav-tab-wrapper" style="position:sticky; top:35px;">
                        <a href="#tab1" data-tab="tab1" class="nav-tab <?php echo ($ays_tab == 'tab1') ? 'nav-tab-active' : ''; ?>">
                            <?php echo esc_html__("General", $this->plugin_name);?>
                        </a>
                        <a href="#tab2" data-tab="tab2" class="nav-tab <?php echo ($ays_tab == 'tab2') ? 'nav-tab-active' : ''; ?>">
                            <?php echo esc_html__("Embeddings", $this->plugin_name);?>
                        </a>
                    </div>
                </div>
                <div class="<?php echo CHATGPT_ASSISTANT_CLASS_PREFIX; ?>-tabs-wrapper">
                    <div id="tab1" class="<?php echo CHATGPT_ASSISTANT_CLASS_PREFIX; ?>-tab-content ays-tab-content <?php echo ($ays_tab == 'tab1') ? 'ays-tab-content-active' : ''; ?>">
                        <p class="ays-subtitle"><?php echo esc_html__('General',$this->plugin_name)?></p>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="<?php echo CHATGPT_ASSISTANT_ID_PREFIX; ?>-enable-embedding">
                                    <?php echo esc_html__( "Enable content embedding", $this->plugin_name ); ?>
                                    <a class="ays_help" data-bs-toggle="tooltip" title="<?php echo esc_html__("Activate this option to enable custom content embedding. The chatbot will be able to provide answers to your users based on the information included in your provided custom content. You will need to add the Pinecone API Key and Index, otherwise, the feature will not be connected. To get the API Key and Index, you must follow the instructions. Note: The embedding feature works only on the front end.", $this->plugin_name)?>">
                                        <img src="<?php echo CHATGPT_ASSISTANT_ADMIN_URL; ?>/images/icons/info-circle.svg">
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-1 <?php echo CHATGPT_ASSISTANT_ID_PREFIX; ?>-hidden-suboption-parent">
                                <input class="<?php echo CHATGPT_ASSISTANT_CLASS_PREFIX; ?>-hidden-suboption-checkbox" type="checkbox" name="<?php echo CHATGPT_ASSISTANT_NAME_PREFIX; ?>_settings[enable_embedding]" id="<?php echo CHATGPT_ASSISTANT_ID_PREFIX; ?>-enable-embedding" value="on" <?php echo $chatgpt_assistant_enable_embedding; ?> >
                            </div>
                            <div class="col-sm-7 <?php echo $chatgpt_assistant_enable_embedding == "checked" ? '' : 'display_none'; ?> <?php echo CHATGPT_ASSISTANT_CLASS_PREFIX; ?>-hidden-suboption">
                            <div class="container mb-2" style="color: #3c434a;">
                                    <p><strong><?php echo esc_html__('Follow this steps to connect to Pinecone:', "ays-chatgpt-assistant"); ?></strong></p>
                                    <ol style="font-size: 14px;margin-left: 0;">
                                        <li><?php echo sprintf(esc_html__('Go to the %sPinecone website%s and create your Pinecone account', "ays-chatgpt-assistant"), '<a href="https://www.pinecone.io/" target="_blank">', '</a>'); ?></li>
                                        <li><?php echo esc_html__('Create an Index in Pinecone, for that, move to the "Indexes" page and click on the "Create Index" button', "ays-chatgpt-assistant"); ?></li>
                                        <li><?php echo sprintf(esc_html__('Set your dimension to %s1536 for OpenAI Embedding%s', "ays-chatgpt-assistant"), '<strong>', '</strong>', '<strong>', '</strong>', '<strong>', '</strong>'); ?></li>
                                        <li><?php echo esc_html__('Create API Key in the "API Keys" page in Pinecone, by clicking on the "Create API Key" button', "ays-chatgpt-assistant"); ?></li>
                                        <li><?php echo esc_html__('Copy the API Key and Pinecone Index URL and paste them here', "ays-chatgpt-assistant"); ?></li>
                                        <li><?php echo esc_html__('Click "Connect" button to connect to Pinecone', "ays-chatgpt-assistant"); ?></li>
                                    </ol>
                                    <p><strong><?php echo esc_html__('Note: Make sure your Pinecone index has no records.', "ays-chatgpt-assistant"); ?></strong></p>
                                </div>
                                <div class="container mb-2">
                                    <input type="text" class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-api-key w-100" name="<?php echo CHATGPT_ASSISTANT_NAME_PREFIX; ?>_settings[pinecone_api_key]" placeholder="Enter pinecone API Key" value="<?php echo esc_attr($chatgpt_assistant_pinecone_api_key); ?>">
                                </div>
                                <div class="container mb-2">
                                    <input type="text" class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-index w-100" name="<?php echo CHATGPT_ASSISTANT_NAME_PREFIX; ?>_settings[pinecone_index]" placeholder="Enter pinecone index" value="<?php echo esc_attr($chatgpt_assistant_pinecone_index); ?>">
                                </div>
                                <div class="container mb-2" style="text-align: right;">
                                    <button type="button" class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-connect-button btn btn-outline-primary btn-md"><i class="fa fa-spinner fa-spin display_none"></i> <?php echo esc_html__('Connect',$this->plugin_name); ?></button>
                                    <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-response-message">
                                        <div class="invalid-feedback"></div>
                                        <div class="valid-feedback"></div>
                                    </div>
                                </div>
                                <input type="hidden" id="<?php echo esc_attr(CHATGPT_ASSISTANT_ID_PREFIX); ?>-pinecone-connection" name="<?php echo CHATGPT_ASSISTANT_NAME_PREFIX; ?>_settings[pinecone_connection]" value="<?php echo $chatgpt_assistant_pinecone_connection ?>">
                                <p class="note-for-save" style="text-align:right;"><strong><?php echo esc_html__('Note: Make sure to save the changes after connecting to Pinecone.', "ays-chatgpt-assistant"); ?></strong></p>
                            </div>
                        </div>
                        <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-embedding-container <?php echo ($chatgpt_assistant_pinecone_connection === "true" && $chatgpt_assistant_enable_embedding === "checked") ? '' : 'display_none'; ?>">
                            <div>
                                <h6>
                                    <?php echo esc_html__('Custom content to embed',$this->plugin_name)?>
                                    <a class="ays_help" data-bs-toggle="tooltip" title="<?php echo esc_html__("Add custom content to embed", $this->plugin_name)?>">
                                        <img src="<?php echo CHATGPT_ASSISTANT_ADMIN_URL; ?>/images/icons/info-circle.svg">
                                    </a>
                                </h6>
                                <hr>
                                <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-custom-content-container">
                                    <p style="margin:0;"><strong><?php echo esc_html__('Note: Each time you embed something here, the existing content will be rewritten.', "ays-chatgpt-assistant"); ?></strong></p>
                                    <p><strong><?php echo esc_html__('Please note that the maximum length of the content you can embed is 5,000 words.', "ays-chatgpt-assistant"); ?></strong></p>
                                    <textarea class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-custom-content" id="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-custom-content" rows="10" style="width:99%;min-height:150px;max-height:500px;padding:10px;" placeholder="Paste your content"></textarea>
                                    <div class="container" style="text-align:right;max-width:100%">
                                        <button type="button" class="<?php echo CHATGPT_ASSISTANT_CLASS_PREFIX; ?>-embed-custom-text btn btn-outline-primary btn-md"><i class="fa fa-spinner fa-spin display_none"></i> <?php echo esc_html__('Embed',$this->plugin_name); ?></button>
                                        <input type="hidden" id="ays_last_pinecone_post_id" value="<?php echo esc_attr($chatgpt_assistant_embedding_text_id); ?>">
                                        <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-response-message">
                                            <div class="invalid-feedback <?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-invalid-feedback"></div>
                                            <div class="valid-feedback <?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-valid-feedback"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <br>
                            <div class="form-group row" style="margin:0px;">
                                <div class="col-sm-12 ays-pro-features-v2-main-box">
                                    <div class="ays-pro-features-v2-small-buttons-box">
                                        <div class="ays-pro-features-v2-video-button"></div>
                                        <a href="https://ays-pro.com/wordpress/chatgpt-assistant" target="_blank" class="ays-pro-features-v2-upgrade-button">
                                            <div class="ays-pro-features-v2-upgrade-icon" style="background-image: url('<?php echo esc_attr(CHATGPT_ASSISTANT_ADMIN_URL); ?>/images/icons/pro-features-icons/Locked_24x24.svg');" data-img-src="<?php echo esc_attr(CHATGPT_ASSISTANT_ADMIN_URL); ?>/images/icons/pro-features-icons/Locked_24x24.svg"></div>
                                            <div class="ays-pro-features-v2-upgrade-text">
                                                <?php echo esc_html(__("Upgrade" , "ays-chatgpt-assistant")); ?>
                                            </div>
                                        </a>
                                    </div>
                                    <div>
                                        <h6>
                                            <?php echo esc_html__('Select posts to embed',$this->plugin_name)?>
                                            <a class="ays_help" data-bs-toggle="tooltip" title="<?php echo esc_html__("Choose specific posts you want to be embedded. By ticking on each checkbox, you will be able to choose the posts of the checked post type that can be embedded. In case of not choosing any specific post, all the posts will be embedded.", $this->plugin_name)?>">
                                                <img src="<?php echo CHATGPT_ASSISTANT_ADMIN_URL; ?>/images/icons/info-circle.svg">
                                            </a>
                                        </h6>
                                        <hr>
                                        <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-posts-container">
                                            <?php 
                                                foreach ($all_post_types as $key => $value) {
                                                    ?>
                                                        <div class="<?php echo CHATGPT_ASSISTANT_CLASS_PREFIX; ?>-posts-each-container form-group row mb-2">
                                                            <div class="col-sm-4">
                                                                <label for="<?php echo CHATGPT_ASSISTANT_ID_PREFIX; ?>-post-type-<?php echo $value; ?>">
                                                                    <?php echo $value; ?>
                                                                </label>
                                                            </div>
                                                            <div class="col-sm-1 ">
                                                                <input type="checkbox" id="<?php echo CHATGPT_ASSISTANT_ID_PREFIX; ?>-post-type-<?php echo $value; ?>" class="<?php echo CHATGPT_ASSISTANT_CLASS_PREFIX; ?>-post-type-all <?php echo CHATGPT_ASSISTANT_CLASS_PREFIX; ?>-hidden-suboption-checkbox">
                                                            </div>
                                                        </div>
                                                    <?php
                                                }
                                            ?>
                                            <div class="container" style="max-width:100%;padding-left:0">
                                                <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-response-message">
                                                    <p class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-note" style="font-style:italic;color:#898989">
                                                        <?php echo esc_html__('Note: Please be aware that the process of embedding each post will require approximately 20 seconds. Therefore, if you have chosen a considerable number of posts, please expect a longer processing time.', 'chatgpt-assistant') ?>
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="container" style="text-align:right;max-width:100%">
                                                <button type="button" class="<?php echo CHATGPT_ASSISTANT_CLASS_PREFIX; ?>-embed-posts btn btn-outline-primary btn-md"><i class="fa fa-spinner fa-spin display_none"></i> <?php echo esc_html__('Embed',$this->plugin_name); ?></button>
                                                <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-response-message">
                                                    <div class="invalid-feedback <?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-invalid-feedback"></div>
                                                    <div class="valid-feedback <?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-valid-feedback"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <div>
                                        <h6>
                                            <?php echo esc_html__('PDF embedding',$this->plugin_name)?>
                                            <a class="ays_help" data-bs-toggle="tooltip" title="<?php echo esc_html__("Add custom PDF file to embed its content", $this->plugin_name)?>">
                                                <img src="<?php echo CHATGPT_ASSISTANT_ADMIN_URL; ?>/images/icons/info-circle.svg">
                                            </a>
                                        </h6>
                                        <hr>
                                        <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-custom-file-container">
                                            <input type="file" class="form-control <?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-custom-file" id="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-custom-file" accept=".pdf" style="width:99%;padding:0.375rem 0.75rem;margin-bottom:7px">
                                            <div class="container" style="text-align:right;max-width:100%">
                                                <button type="button" class="<?php echo CHATGPT_ASSISTANT_CLASS_PREFIX; ?>-embed-custom-file btn btn-outline-primary btn-md"><i class="fa fa-spinner fa-spin display_none"></i> <?php echo __('Embed',$this->plugin_name); ?></button>
                                                <div class="<?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-response-message">
                                                    <div class="invalid-feedback <?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-invalid-feedback"></div>
                                                    <div class="valid-feedback <?php echo esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX); ?>-pinecone-valid-feedback"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div id="tab2" class="<?php echo CHATGPT_ASSISTANT_CLASS_PREFIX; ?>-tab-content ays-tab-content <?php echo ($ays_tab == 'tab2') ? 'ays-tab-content-active' : ''; ?>">
                        <p class="ays-subtitle"><?php echo esc_html__('Embeddings',$this->plugin_name)?></p>
                        <hr>
                        <div class="form-group row" style="margin:0px;">
                            <div class="col-sm-12 ays-pro-features-v2-main-box">
                                <div class="ays-pro-features-v2-small-buttons-box">
                                    <div class="ays-pro-features-v2-video-button"></div>
                                    <a href="https://ays-pro.com/wordpress/chatgpt-assistant" target="_blank" class="ays-pro-features-v2-upgrade-button">
                                        <div class="ays-pro-features-v2-upgrade-icon" style="background-image: url('<?php echo esc_attr(CHATGPT_ASSISTANT_ADMIN_URL); ?>/images/icons/pro-features-icons/Locked_24x24.svg');" data-img-src="<?php echo esc_attr(CHATGPT_ASSISTANT_ADMIN_URL); ?>/images/icons/pro-features-icons/Locked_24x24.svg"></div>
                                        <div class="ays-pro-features-v2-upgrade-text">
                                            <?php echo esc_html(__("Upgrade" , "ays-chatgpt-assistant")); ?>
                                        </div>
                                    </a>
                                </div>
                                    <div id="poststuff">
                                        <div id="post-body" class="metabox-holder">
                                            <img src="<?php echo esc_attr(CHATGPT_ASSISTANT_ADMIN_URL).'/images/ays_chatgpt_embedding_list_table.png'?>" alt="Embedding List Table" style="width:100%;" > 
                                        </div>
                                        <br class="clear">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <hr>
            <div style="position:sticky;padding:15px 0px;bottom:0;">
                <?php
                   
                    wp_nonce_field('embedding_action', 'embedding_action');
                    $other_attributes = array();
                    
                    submit_button(esc_html__('Save changes', "ays-chatgpt-assistant"), 'primary '.esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX).'-loader-banner '.esc_attr(CHATGPT_ASSISTANT_CLASS_PREFIX).'-general-settings-save', 'ays_submit', true, $other_attributes);
                    //echo $loader_image;
                ?>
            </div>
            <div class="ays-chatgpt-embedding-video-box" style="text-align:center;">
                <iframe style="width: 100%;max-width: 560px;" height="315" src="https://www.youtube.com/embed/tetv6gx93Ew" loading="lazy" title="YouTube video player"  frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
            </div>
        </form>
    </div>
</div>