<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://ays-pro.com/
 * @since      1.0.0
 *
 * @package    Ays_Chatgpt_Assistant
 * @subpackage Ays_Chatgpt_Assistant/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Ays_Chatgpt_Assistant
 * @subpackage Ays_Chatgpt_Assistant/admin
 * @author     Ays_ChatGPT Assistant Team <info@ays-pro.com>
 */
class Chatgpt_Assistant_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * @var Chatgpt_Assistant_DB_Actions
	 */

     
	/**
	 * DB properties of this plugin.
    */
	private $dashboard_chat_db_name;
	private $front_chat_db_name;
	private $settings_db_name;
	private $general_settings_db_name;
	private $data_db_name;
	private $db_obj;
    private $embedding_db_name;
	private $capability;
         
	/**
	 * Set options of this plugin.
    */
    private $api_key;
	private $chatgpt_assistant_full_screen_mode;
	private $chatbox_position;
    private $chatbox_position_mobile;
    private $chatbox_enable_position_mobile;
	private $chatbox_icon_position;
    private $chatbox_icon_position_mobile;
    private $chatbox_enable_icon_position_mobile;
    private $chatgpt_assistant_show_dashboard_chat;
    private $chatgpt_assistant_show_dashboard_chat_mobile;
	private $chatgpt_assistant_chat_icon_size;
    private $chatgpt_assistant_chat_icon_size_mobile;
    private $chatgpt_assistant_enable_chat_icon_size_mobile;
	private $chatgpt_assistant_chat_width;
	private $chatgpt_assistant_chat_width_format;
    private $chatgpt_assistant_chat_width_mobile;
    private $chatgpt_assistant_chat_width_mobile_format;
    private $chatgpt_assistant_enable_chat_width_mobile;
	private $chatgpt_assistant_chat_height;
	private $chatgpt_assistant_chat_height_format;
    private $chatgpt_assistant_chat_height_mobile;
    private $chatgpt_assistant_chat_height_mobile_format;
    private $chatgpt_assistant_enable_chat_height_mobile;
	private $chatgpt_assistant_auto_opening_chatbox;
	private $chatgpt_assistant_auto_opening_chatbox_delay;
    private $chatgpt_assistant_auto_opening_chatbox_mobile;
	private $chatgpt_assistant_regenerate_response;
	private $chatgpt_assistant_message_placeholder;
	private $chatgpt_assistant_chatbot_name;
	private $chatgpt_assistant_compliance_text;
	private $chatgpt_assistant_chat_model;
	private $chatgpt_assistant_chat_temprature;
	private $chatgpt_assistant_chat_top_p;
	private $chatgpt_assistant_max_tokens;
	private $chatgpt_assistant_frequency_penalty;
	private $chatgpt_assistant_presence_penalty;
	private $chatgpt_assistant_best_of;
	private $chatgpt_assistant_context;
	private $chatgpt_assistant_profession;
	private $chatgpt_assistant_tone;
	private $chatgpt_assistant_language;
	private $chatgpt_assistant_name;
	private $chatgpt_assistant_greeting_message;
	private $chatgpt_assistant_greeting_message_default_text;
	private $chatgpt_assistant_greeting_message_text;
	private $chatbox_mode;
    private $chatbox_theme;
    private $chat_icon;
	private $user_profile_picture;
    private $chatgpt_assistant_enable_rate_chat;
    private $chatgpt_assistant_rate_chat_text;
	private $chatgpt_assistant_rate_chat_like;
	private $chatgpt_assistant_rate_chat_dislike;

	private $chatgpt_assistant_chatbox_background_color;
	private $chatgpt_assistant_chatbox_header_text_color;
	private $chatgpt_assistant_chatbox_header_text_letter_spacing;
	private $chatgpt_assistant_chatbox_header_text_font_size;
	private $chatgpt_assistant_end_chat_button_bg_color;
	private $chatgpt_assistant_end_chat_button_text_color;
	private $chatgpt_assistant_end_chat_button_text_font_size;
	private $chatgpt_assistant_end_chat_button_text_letter_spacing;
	private $chatgpt_assistant_message_font_size;
    private $chatgpt_assistant_message_font_size_mobile;
    private $chatgpt_assistant_enable_message_font_size_mobile;
	private $chatgpt_assistant_message_letter_spacing;
	private $chatgpt_assistant_send_button_font_size;
	private $chatgpt_assistant_send_button_padding;
	private $chatgpt_assistant_message_spacing;
	private $chatgpt_assistant_message_border_radius;
	private $chatgpt_assistant_chatbot_border_radius;
    private $chatgpt_assistant_chatbot_border_radius_mobile;
    private $chatgpt_assistant_enable_chatbot_border_radius_mobile;
	private $chatgpt_assistant_send_message_icon;
	private $chatgpt_assistant_send_message_icon_text;
	private $chatgpt_assistant_send_message_text;
	private $message_bg_color;
	private $message_text_color;
	private $response_text_color;
	private $response_icons_color;
	private $response_bg_color;
    private $rates_table_obj;
    public $settings_obj;
	public $general_settings_obj;
	public $front_settings_obj;
    private $embedding_settings_obj;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {
        global $wpdb;
		$this->plugin_name = $plugin_name;
		$this->version = $version;

        $this->dashboard_chat_db_name = $wpdb->prefix . CHATGPT_ASSISTANT_DB_PREFIX . 'dashboard_settings';
		$this->front_chat_db_name = $wpdb->prefix . CHATGPT_ASSISTANT_DB_PREFIX . 'front_settings';
		$this->settings_db_name = $wpdb->prefix . CHATGPT_ASSISTANT_DB_PREFIX . 'settings';
		$this->general_settings_db_name = $wpdb->prefix . CHATGPT_ASSISTANT_DB_PREFIX . 'general_settings';
        $this->embedding_db_name = $wpdb->prefix . CHATGPT_ASSISTANT_DB_PREFIX . 'embedding_settings';
		$this->data_db_name = $wpdb->prefix . CHATGPT_ASSISTANT_DB_PREFIX . 'data';

        $this->db_obj = new Chatgpt_Assistant_DB_Actions( $this->plugin_name, $this->data_db_name );
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles($hook_suffix) {
        wp_enqueue_style($this->plugin_name . '-admin', plugin_dir_url(__FILE__) . 'css/admin.css', array(), $this->version, 'all');
		wp_enqueue_style( $this->plugin_name . '-chatbox', plugin_dir_url( __FILE__ ) . 'css/chatgpt-assistant-chat-bot.css', array(), $this->version . time(), 'all' );
		if (false === strpos($hook_suffix, $this->plugin_name))
            return;

        wp_enqueue_style( $this->plugin_name . '-font-awesome', plugin_dir_url(__FILE__) .  'css/chatgpt-assistant-font-awesome.min.css', array(), $this->version, 'all');
		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/chatgpt-assistant-admin.css', array(), $this->version . time(), 'all' );
        wp_enqueue_style( $this->plugin_name . "-pro-features", plugin_dir_url( __FILE__ ) . 'css/chatgpt-assistant-pro-features.css', array(), time(), 'all' );
		
		if ( false !== strpos($hook_suffix, $this->plugin_name) || false !== strpos( $hook_suffix, 'embedding' ) || strpos($hook_suffix, $this->plugin_name.'-front-chat') !== false || false !== strpos( $hook_suffix, 'logs' ) || false !== strpos( $hook_suffix, 'rates' )) {
			wp_enqueue_style( $this->plugin_name . '-select2', plugin_dir_url(__FILE__) .  'css/ays-select2.min.css', array(), $this->version, 'all');
			wp_enqueue_style( $this->plugin_name . '-bootstrap', plugin_dir_url(__FILE__) . 'css/bootstrap.min.css', array(), $this->version, 'all');
		}

        if ( false !== strpos( $hook_suffix, 'image-generator' ) ) {
			wp_enqueue_script( $this->plugin_name . '-sweetalert-js', plugin_dir_url( __FILE__ ) . 'js/ays-chatgpt-assistant-sweetalert2.all.min.js', array('jquery'), $this->version, true );
			wp_enqueue_script( $this->plugin_name . '-image-generator', plugin_dir_url( __FILE__ ) . 'js/chatgpt-assistant-admin-image-generator.js', array( 'jquery' ), $this->version, true );
		}
		
		wp_enqueue_style( $this->plugin_name . '-sale-banner', plugin_dir_url(__FILE__) . 'css/chatgpt-banner.css', array(), $this->version, 'all');
		wp_enqueue_style( $this->plugin_name . '-banner', plugin_dir_url( __FILE__ ) . 'css/banner.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts($hook_suffix) {

        if (false !== strpos($hook_suffix, "plugins.php")){
            wp_enqueue_script( $this->plugin_name . '-sweetalert-js', plugin_dir_url( __FILE__ ) . 'js/ays-chatgpt-assistant-sweetalert2.all.min.js', array('jquery'), $this->version, true );
            wp_enqueue_script( $this->plugin_name . '-admin', plugin_dir_url(__FILE__) . 'js/admin.js', array( 'jquery' ), $this->version, true );
            wp_localize_script( $this->plugin_name . '-admin', 'AysChatGptAdmin', array( 
            	'ajaxUrl' => admin_url( 'admin-ajax.php' ),
                'nonce'   => wp_create_nonce( 'ajax-nonce' ),
            ) );
        }

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/chatgpt-assistant-admin.js', array( 'jquery' ), $this->version, true );
        wp_enqueue_script( $this->plugin_name . '-main-functions', CHATGPT_ASSISTANT_ASSETS_URL . '/js/chatgpt-assistant-main-functions.js',  array( 'jquery' ), $this->version, false );
        wp_enqueue_script( $this->plugin_name . '-autosize', plugin_dir_url( __FILE__ ) . '/js/chatgpt-assistant-autosize.js', array( 'jquery' ), $this->version, false );
		if (false === strpos($hook_suffix, $this->plugin_name)) return;
        
        wp_enqueue_script( $this->plugin_name . '-sweetalert-js', plugin_dir_url( __FILE__ ) . 'js/ays-chatgpt-assistant-sweetalert2.all.min.js', array('jquery'), $this->version, true );
		wp_enqueue_script( $this->plugin_name . "-general-js", plugin_dir_url( __FILE__ ) . 'js/chatgpt-assistant-admin-general.js', array( 'jquery' ), $this->version, true );
        wp_localize_script( $this->plugin_name . "-general-js", 'aysChatGptAssistantGeneral', array(
            'ajaxUrl' => admin_url( 'admin-ajax.php' ),
            'nonce'   => wp_create_nonce( 'ajax-nonce' ),
			'addImage'               => __( 'Add Image', 'ays-chatgpt-assistant' ),
            'editImage'              => __( 'Edit Image', 'ays-chatgpt-assistant' ),
            'removeImage'            => __( 'Remove Image', 'ays-chatgpt-assistant' ),

            'translations' => array(
                'chatGreetingMessage'    => __( 'Hello! I\'m an AI Assistant, and I\'m here to assist you with anything you need. How can I help you today?', "ays-chatgpt-assistant" ),
                'errorOpenAi'            => __('Error: Please Connect to OpenAI.','ays-chatgpt-assistant'),
                'successfullyEmbeded'    => __('Successfully embedded!','ays-chatgpt-assistant'),
                'embeddingFailed'        => __('Embedding failed!','ays-chatgpt-assistant'),
                'errorWords'             => __('Error: You are not allowed to add more than 5000 words.','ays-chatgpt-assistant'),
                'errorEmptyText'         => __('Error: Make sure to add text for embedding.','ays-chatgpt-assistant'),
                'errorConnectingPinecone'=> __('Error connecting to pinecone. Check your API key and index.','ays-chatgpt-assistant'),
                'pineconeDbEmpty'        => __('Pinecone database is not empty. You are not allowed to connect.','ays-chatgpt-assistant'),
                'connectedPinecone'      => __('Successfully connected to pinecone.','ays-chatgpt-assistant'),
            )
		) );

		$chatgpt_banner_date = $this->ays_chatgpt_update_banner_time();
		if ( false !== strpos($hook_suffix, $this->plugin_name) || strpos($hook_suffix, $this->plugin_name.'-front-chat') !== false || false !== strpos( $hook_suffix, 'logs' ) || strpos($hook_suffix, $this->plugin_name.'-rates') !== false ) {
			wp_enqueue_script( $this->plugin_name . "-popper", plugin_dir_url(__FILE__) . 'js/popper.min.js', array( 'jquery' ), $this->version, true );
			wp_enqueue_script( $this->plugin_name . "-bootstrap", plugin_dir_url(__FILE__) . 'js/bootstrap.min.js', array( 'jquery' ), $this->version, true );
			wp_enqueue_script( $this->plugin_name . '-select2js', plugin_dir_url( __FILE__ ) . 'js/ays-select2.min.js', array('jquery'), $this->version, true);
			wp_enqueue_script( $this->plugin_name . '-settings', plugin_dir_url( __FILE__ ) . 'js/chatgpt-assistant-admin-settings.js', array( 'jquery' ), $this->version, true );

            wp_enqueue_media();

			wp_localize_script( $this->plugin_name . '-settings', 'aysChatGptAssistantAdminSettings', array(
                'ajaxUrl'                   => admin_url( 'admin-ajax.php' ),
                'nonce'                     => wp_create_nonce( 'ajax-nonce' ),
				'selectUserRoles'           => __( 'Select user roles', "ays-chatgpt-assistant" ),
				'delete'                    => __( 'Delete', "ays-chatgpt-assistant" ),
				'selectQuestionDefaultType' => __( 'Select question default type', "ays-chatgpt-assistant" ),
				'yes'                       => __( 'Yes', "ays-chatgpt-assistant" ),
				'cancel'                    => __( 'Cancel', "ays-chatgpt-assistant" ),
				'errorMsg'                  => __( 'Error', "ays-chatgpt-assistant" ),
				'somethingWentWrong'        => __( "Maybe something went wrong.", "ays-chatgpt-assistant" ),
				'failed'                    => __( 'Failed', "ays-chatgpt-assistant" ),
				'selectPage'                => __( 'Select page', "ays-chatgpt-assistant" ),
				'selectPostType'            => __( 'Select post type', "ays-chatgpt-assistant" ),
				'copied'                    => __( 'Copied!', "ays-chatgpt-assistant"),
				'clickForCopy'              => __( 'Click to copy', "ays-chatgpt-assistant"),
				'selectForm'                => __( 'Select form', "ays-chatgpt-assistant"),
				'chatgptBannerDate'         => $chatgpt_banner_date,
			) );
		}
		wp_localize_script( $this->plugin_name, 'aysChatGptAssistantAdminSettings', array(
			'chatgptBannerDate' => $chatgpt_banner_date,
		) );
        if ( false !== strpos( $hook_suffix, 'embedding' ) ) {
			
			wp_enqueue_script( $this->plugin_name . '-embedding', plugin_dir_url( __FILE__ ) . 'js/chatgpt-assistant-admin-embedding.js', array( 'jquery' ), $this->version, true );
		}
	}

    /**
	 * De-register JavaScript files for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function disable_scripts($hook_suffix) {
        if (false !== strpos($hook_suffix, $this->plugin_name)) {
            if (is_plugin_active('ai-engine/ai-engine.php')) {
                wp_deregister_script('mwai');
                wp_deregister_script('mwai-vendor');
                wp_dequeue_script('mwai');
                wp_dequeue_script('mwai-vendor');
            }
        }
	}

	/**
     * Register the administration menu for this plugin into the WordPress Dashboard menu.
     *
     * @since    1.0.0
     */
    public function add_plugin_admin_menu(){
        global $wpdb;

        $this->capability = 'manage_options';

        add_menu_page(
            __('ChatGPT Assistant', 'ays-chatgpt-assistant'),
			__('ChatGPT Assistant', 'ays-chatgpt-assistant'),
            $this->capability,
            $this->plugin_name,
			array($this, 'display_plugin_main_page'),
            CHATGPT_ASSISTANT_ADMIN_URL . '/images/icons/chatgpt-icon-menu-bw.svg',
            '6.224'
        );

        $this->general_settings_obj = new ChatGPT_Assistant_General_Settings_DB_Actions( $this->plugin_name , $this->general_settings_db_name );
        $this->settings_obj = new ChatGPT_Assistant_Settings_DB_Actions( $this->plugin_name , $this->settings_db_name );
    }

	public function add_plugin_settings_submenu(){
		$hook_settings = add_submenu_page( $this->plugin_name,
			__('Settings','ays-chatgpt-assistant'),
			__('Settings', 'ays-chatgpt-assistant'),
			'manage_options',
			$this->plugin_name,
			array($this, 'display_plugin_main_page')
		);

        $this->general_settings_obj = new ChatGPT_Assistant_General_Settings_DB_Actions( $this->plugin_name , $this->general_settings_db_name );
        $this->settings_obj = new ChatGPT_Assistant_Settings_DB_Actions( $this->plugin_name , $this->settings_db_name );
	}

	// Front settings
	public function add_plugin_front_chat_submenu(){
		$this->capability = 'manage_options';

		$hook_settings = add_submenu_page( $this->plugin_name,
			__('Front chat', 'ays-chatgpt-assistant'),
			__('Front chat', 'ays-chatgpt-assistant'),
			$this->capability,
			$this->plugin_name . '-front-chat',
			array($this, 'display_plugin_front_chat_page')
		);

        $this->general_settings_obj = new ChatGPT_Assistant_General_Settings_DB_Actions( $this->plugin_name , $this->general_settings_db_name );
        $this->settings_obj = new ChatGPT_Assistant_Settings_DB_Actions( $this->plugin_name , $this->settings_db_name );
		$this->front_settings_obj = new ChatGPT_Assistant_Front_Chat_DB_Actions( $this->plugin_name , $this->front_chat_db_name);
	}

    // Embedding settings 
	public function add_plugin_embedding_submenu(){
		$this->capability = 'manage_options';
        $menu_item =  __('Embeddings', 'ays-chatgpt-assistant') . '<span class="ays_menu_badge ays_results_bage">' .  __('New', 'ays-chatgpt-assistant') . '</span>';

		$hook_settings = add_submenu_page( $this->plugin_name,
			__('Embeddings', 'ays-chatgpt-assistant'),
			$menu_item,
			$this->capability,
			$this->plugin_name . '-embedding',
			array($this, 'display_plugin_embedding_page')
		);
        $this->embedding_settings_obj = new ChatGPT_Assistant_Embedding_DB_Actions( $this->plugin_name , $this->embedding_db_name);
	}

    public function add_plugin_logs_submenu(){
		$this->capability = 'manage_options';

		$hook_settings = add_submenu_page( $this->plugin_name,
			__('Logs', 'ays-chatgpt-assistant'),
			__('Logs', 'ays-chatgpt-assistant'),
			$this->capability,
			$this->plugin_name . '-logs',
			array($this, 'display_plugin_logs_page')
		);
	}

    public function add_plugin_rates_submenu(){
		$this->capability = 'manage_options';

		$hook_settings = add_submenu_page( $this->plugin_name,
			__('Rates','ays-chatgpt-assistant'),
			__('Rates', 'ays-chatgpt-assistant'),
			$this->capability,
			$this->plugin_name . '-rates',
			array($this, 'display_plugin_rates_page')
		);

		$this->rates_table_obj = new ChatGPT_Assistant_Rates_List_Table( $this->plugin_name);
	}

    public function add_plugin_content_generator_submenu(){
		$this->capability = 'manage_options';

        $hook_pro_features = add_submenu_page(
            $this->plugin_name,
            __('Content Generator', 'ays-chatgpt-assistant'),
            __('Content Generator', 'ays-chatgpt-assistant'),
			$this->capability,
            $this->plugin_name . '-content-generator',
            array($this, 'display_plugin_content_generator_page')
        );
    }
    
    public function add_plugin_image_generator_submenu(){
		$this->capability = 'manage_options';

        $hook_pro_features = add_submenu_page(
            $this->plugin_name,
            __('Image Generator', 'ays-chatgpt-assistant'),
            __('Image Generator', 'ays-chatgpt-assistant'),
			$this->capability,
            $this->plugin_name . '-image-generator',
            array($this, 'display_plugin_image_generator_page')
        );

		$this->general_settings_obj = new ChatGPT_Assistant_General_Settings_DB_Actions( $this->plugin_name , $this->general_settings_db_name );
    }
    
    public function add_plugin_how_to_use_submenu(){
		$this->capability = 'manage_options';

        $hook_pro_features = add_submenu_page(
            $this->plugin_name,
            __('How to Use', 'ays-chatgpt-assistant'),
            __('How to Use', 'ays-chatgpt-assistant'),
			$this->capability,
            $this->plugin_name . '-how-to-use',
            array($this, 'display_plugin_how_to_use_page')
        );
    }
    
    public function add_plugin_general_settings_submenu(){
		$this->capability = 'manage_options';
		
        $hook_settings = add_submenu_page( $this->plugin_name,
			__('General Settings', 'ays-chatgpt-assistant'),
			__('General Settings', 'ays-chatgpt-assistant'),
			'manage_options',
			$this->plugin_name . '-general-settings',
			array($this, 'display_plugin_general_settings_page')
		);

        $this->general_settings_obj = new ChatGPT_Assistant_General_Settings_DB_Actions( $this->plugin_name , $this->general_settings_db_name );
	}
    
    public function add_plugin_features_submenu(){
		$this->capability = 'manage_options';

        $hook_pro_features = add_submenu_page(
            $this->plugin_name,
            __('PRO Features', 'ays-chatgpt-assistant'),
            __('PRO Features', 'ays-chatgpt-assistant'),
			$this->capability,
            $this->plugin_name . '-features',
            array($this, 'display_plugin_features_page')
        );
    }
    
    public function add_plugin_gift_submenu(){
		$this->capability = 'manage_options';

        $hook_pro_features = add_submenu_page(
            $this->plugin_name,
            __('Grab Your GIFT', 'ays-chatgpt-assistant'),
            __('Grab Your GIFT', 'ays-chatgpt-assistant'),
			$this->capability,
            $this->plugin_name . '-gift',
            array($this, 'display_plugin_gift_page')
        );
    }

	public function display_plugin_main_page(){
		if (isset( $_POST[CHATGPT_ASSISTANT_NAME_PREFIX.'_save_bttn'] )) {
			$this->db_obj->store_data( $_POST );
		}
		include_once('partials/settings/chatgpt-assistant-settings.php');
    }

	public function display_plugin_settings_page(){
		include_once('partials/settings/chatgpt-assistant-settings.php');
	}

	public function display_plugin_front_chat_page(){
		include_once('partials/front-chat/chatgpt-assistant-front-chat-display.php');
	}

	public function display_plugin_embedding_page(){
		include_once('partials/embeddings/chatgpt-assistant-embedding-display.php');
	}

    public function display_plugin_logs_page(){
		include_once('partials/logs/chatgpt-assistant-logs-display.php');
	}

    public function display_plugin_rates_page(){
		include_once('partials/rates/chatgpt-assistant-rates-display.php');
	}

    public function display_plugin_how_to_use_page(){
        include_once('partials/chatgpt-assistant-data-display.php');
    }

    public function display_plugin_general_settings_page(){
		include_once('partials/general-settings/chatgpt-assistant-general-settings.php');
	}
    
    public function display_plugin_content_generator_page(){
		include_once('partials/content-generator/chatgpt-assistant-content-generator-display.php');
    }

    public function display_plugin_image_generator_page(){
		include_once('partials/image-generator/chatgpt-assistant-image-generator-display.php');
    }
    
    public function display_plugin_features_page(){
        include_once('partials/features/chatgpt-assistant-features-display.php');
    }
    
    public function display_plugin_gift_page(){
        include_once('partials/gifts/chatgpt-assistant-gifts-display.php');
    }

	public function chatgpt_display_chat_icon(){
        $this->settings_obj = new ChatGPT_Assistant_Settings_DB_Actions( $this->plugin_name , $this->settings_db_name );
        include_once(plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/chatgpt-assistant-chatbox-display.php');
    }
    
	public function set_global_settings(){
        $data = $this->db_obj->get_data();
		$this->api_key = isset( $data['api_key'] ) && $data['api_key'] != '' ? esc_attr( $data['api_key'] ) : '';

		$options = ($this->settings_obj->get_setting('options') === false) ? array() : json_decode($this->settings_obj->get_setting('options'), true);
		

        // * GENERAL SETTINGS *
            // ===== Shortcode settings =====
                // Full Screen Mode
                $this->chatgpt_assistant_full_screen_mode = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'full_screen_mode'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'full_screen_mode'] == 'on' ) ? true : false; 
            // ===== General settings =====
                // Chatbot position
                $this->chatbox_position = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'position'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'position'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'position']) : 'right';
                // Chatbot position Mobile
                if( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'position_mobile'] )){
                    $this->chatbox_position_mobile = ($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'position_mobile'] != '') ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'position_mobile']) : 'right';
                } else{
                    $this->chatbox_position_mobile = $this->chatbox_position ;
                }
                // Enable chatbox position mobile
                $this->chatbox_enable_position_mobile = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'enable_position_mobile'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'enable_position_mobile'] == 'on' ) ? true : false; 
                // Chatbot icon position
                $this->chatbox_icon_position = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'icon_position'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'icon_position'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'icon_position']) : 'bottom-'.$this->chatbox_position;
                // Chatbot icon position mobile
                $this->chatbox_icon_position_mobile = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'icon_position_mobile'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'icon_position_mobile'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'icon_position_mobile']) : 'bottom-'.$this->chatbox_position;
                // Enable chatbox position mobile
                $this->chatbox_enable_icon_position_mobile = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'enable_icon_position_mobile'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'enable_icon_position_mobile'] == 'on' ) ? true : false; 
                // Chat icon size
                $this->chatgpt_assistant_chat_icon_size = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_icon_size'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_icon_size'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_icon_size']) : 70;
                // Chat icon size Mobile
                $this->chatgpt_assistant_chat_icon_size_mobile = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_icon_size_mobile'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_icon_size_mobile'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_icon_size_mobile']) : 70;
                // Enable Chat icon size Mobile
                $this->chatgpt_assistant_enable_chat_icon_size_mobile = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'enable_chat_icon_size_mobile'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'enable_chat_icon_size_mobile'] == 'on' ) ? true : false; 
                // Chat width
                $this->chatgpt_assistant_chat_width = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_width'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_width'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_width']) : 28;
                // Chat width format
                $this->chatgpt_assistant_chat_width_format = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_width_format'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_width_format'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_width_format']) : '%';
                // Chat width Mobile
                $this->chatgpt_assistant_chat_width_mobile = (isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_width_mobile'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_width_mobile'] != '') ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_width_mobile']) : 95;               
                // Chat width mobile format
                $this->chatgpt_assistant_chat_width_mobile_format = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_width_mobile_format'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_width_mobile_format'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_width_mobile_format']) : '%';
                // Enable Chat width mobile
                $this->chatgpt_assistant_enable_chat_width_mobile = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'enable_chat_width_mobile'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'enable_chat_width_mobile'] == 'on' ) ? true : false; 
                // Chat height
                $this->chatgpt_assistant_chat_height = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_height'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_height'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_height']) : 55;
                // Chat height format
                $this->chatgpt_assistant_chat_height_format = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_height_format'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_height_format'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_height_format']) : '%';
                // Chat height Mobile
                $this->chatgpt_assistant_chat_height_mobile = (isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_height_mobile'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_height_mobile'] != '') ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_height_mobile']) : 95;               
                // Chat height mobile format
                $this->chatgpt_assistant_chat_height_mobile_format = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_height_mobile_format'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_height_mobile_format'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_height_mobile_format']) : '%';
                // Enable Chat height mobile
                $this->chatgpt_assistant_enable_chat_height_mobile = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'enable_chat_height_mobile'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'enable_chat_height_mobile'] == 'on' ) ? true : false; 
                // Auto opening Chatbox
                $this->chatgpt_assistant_auto_opening_chatbox = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'auto_opening_chatbox'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'auto_opening_chatbox'] == 'on' ) ? true : false;
                // Auto opening Chatbox delay
                $this->chatgpt_assistant_auto_opening_chatbox_delay = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'auto_opening_chatbox_delay'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'auto_opening_chatbox_delay'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'auto_opening_chatbox_delay']) : 0;
                // Auto opening Chatbox Mobile
                if( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'auto_opening_chatbox_mobile'] )){
                    $this->chatgpt_assistant_auto_opening_chatbox_mobile = ($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'auto_opening_chatbox_mobile'] == 'on') ? true : false;
                } else{
                    $this->chatgpt_assistant_auto_opening_chatbox_mobile = $this->chatgpt_assistant_auto_opening_chatbox ;
                }
                // Show dashboard chat
                $this->chatgpt_assistant_show_dashboard_chat = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'show_dashboard_chat'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'show_dashboard_chat'] == 'off' ) ? false : true;
                // Show dashboard chat
                $this->chatgpt_assistant_show_dashboard_chat_mobile = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'show_dashboard_chat_mobile'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'show_dashboard_chat_mobile'] == 'off' ) ? false : true;
                // Regenerate Response
                $this->chatgpt_assistant_regenerate_response = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'regenerate_response'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'regenerate_response'] == 'on' ) ? true : false;

                // Enable rate chat
                $this->chatgpt_assistant_enable_rate_chat = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'enable_rate_chat'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'enable_rate_chat'] == 'on' ) ? true : false;

                // Rate chat text
                $this->chatgpt_assistant_rate_chat_text = isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'rate_chat_text'] ) ? stripslashes(sanitize_text_field($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'rate_chat_text'])) : __('How Satisfied are You?', 'ays-chatgpt-assistant');

				// Rate chat options
				$chatgpt_assistant_rate_chat = (isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'rate_chat']) && !empty($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'rate_chat'])) ? $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'rate_chat'] : array();

				$this->chatgpt_assistant_rate_chat_like = isset($chatgpt_assistant_rate_chat['like']) && !empty($chatgpt_assistant_rate_chat['like']) ? $chatgpt_assistant_rate_chat['like'] : array();
				$this->chatgpt_assistant_rate_chat_like['action'] = (isset($this->chatgpt_assistant_rate_chat_like['action']) && ($this->chatgpt_assistant_rate_chat_like['action'] == 'feedback')) ? sanitize_text_field($this->chatgpt_assistant_rate_chat_like['action']) : 'feedback';
				$this->chatgpt_assistant_rate_chat_like['text'] = (isset($this->chatgpt_assistant_rate_chat_like['text']) && $this->chatgpt_assistant_rate_chat_like['text'] != '') ? stripslashes(sanitize_text_field($this->chatgpt_assistant_rate_chat_like['text'])) : '';

				$this->chatgpt_assistant_rate_chat_dislike = isset($chatgpt_assistant_rate_chat['dislike']) && !empty($chatgpt_assistant_rate_chat['dislike']) ? $chatgpt_assistant_rate_chat['dislike'] : array();
				$this->chatgpt_assistant_rate_chat_dislike['action'] = (isset($this->chatgpt_assistant_rate_chat_dislike['action']) && ($this->chatgpt_assistant_rate_chat_dislike['action'] == 'feedback')) ? sanitize_text_field($this->chatgpt_assistant_rate_chat_dislike['action']) : 'feedback';
				$this->chatgpt_assistant_rate_chat_dislike['text'] = (isset($this->chatgpt_assistant_rate_chat_dislike['text']) && $this->chatgpt_assistant_rate_chat_dislike['text'] != '') ? stripslashes(sanitize_text_field($this->chatgpt_assistant_rate_chat_dislike['text'])) : '';

                // Greeting message
                $this->chatgpt_assistant_greeting_message = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'greeting_message'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'greeting_message'] == 'on' ) ? true : false;
                // Greeting message text
                $this->chatgpt_assistant_greeting_message_default_text = 'Hello! I\'m an AI Assistant, and I\'m here to assist you with anything you need. How can I help you today?';
                $this->chatgpt_assistant_greeting_message_text = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'greeting_message_text'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'greeting_message_text'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'greeting_message_text']) : $this->chatgpt_assistant_greeting_message_default_text;
                // Message placeholder
                $this->chatgpt_assistant_message_placeholder = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_placeholder'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_placeholder'] != '' ) ? stripslashes(esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_placeholder'])) : __('Enter your message ', 'ays-chatgpt-assistant');
                // Message placeholder
                $this->chatgpt_assistant_chatbot_name = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbot_name'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbot_name'] != '' ) ? stripslashes(esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbot_name'])) : __('AI Assistant', 'ays-chatgpt-assistant');
                // compliance text
                $this->chatgpt_assistant_compliance_text = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'compliance_text'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'compliance_text'] != '' ) ? stripslashes(esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'compliance_text'])) : '';
            // ===== Chat settings =====
                // Model
                $this->chatgpt_assistant_chat_model = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_model'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_model'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_model']) : 'gpt-3.5-turbo-16k';
                // Temprature
                $this->chatgpt_assistant_chat_temprature = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_temprature'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_temprature'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_temprature']) : '0.8';
                // Top P
                $this->chatgpt_assistant_chat_top_p = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_top_p'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_top_p'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chat_top_p']) : '1';
                // Max tokens
                $this->chatgpt_assistant_max_tokens = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'max_tokens'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'max_tokens'] != '' ) ? intval($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'max_tokens']) : 1500;
                // Frequency penalty
                $this->chatgpt_assistant_frequency_penalty = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'frequency_penalty'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'frequency_penalty'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'frequency_penalty']) : '0.01';
                // Presence penalty
                $this->chatgpt_assistant_presence_penalty = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'presence_penalty'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'presence_penalty'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'presence_penalty']) : '0.01';
                // Best of
                $this->chatgpt_assistant_best_of = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'best_of'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'best_of'] != '' ) ? intval($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'best_of']) : 1;   
                // Context
                $this->chatgpt_assistant_context = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'context'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'context'] != '' ) ? stripslashes(esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'context'])) : '';
                // Profession (Act as)
                $this->chatgpt_assistant_profession = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'profession'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'profession'] != '' ) ? stripslashes(esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'profession'])) : '';
                // Tone
                $this->chatgpt_assistant_tone = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'tone'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'tone'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'tone']) : '';                
                // Language
                $this->chatgpt_assistant_language = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'language'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'language'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'language']) : 'en';                
                // Name
                $this->chatgpt_assistant_name = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'name'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'name'] != '' ) ? stripslashes(esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'name'])) : '';                
        //

        // * STYLE SETTINGS *
            // Chat theme
			$this->chatbox_theme = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'chatbox_theme'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'chatbox_theme'] != '' ) ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'chatbox_theme']) : 'default';
            // Chat dark mode
            $this->chatbox_mode = ( isset( $options['chatbox_mode'] ) && $options['chatbox_mode'] != '' ) ? esc_attr($options['chatbox_mode']) : 'light';
            // Chat Widget background color
            $this->chatgpt_assistant_chatbox_background_color = isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbox_background_color']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbox_background_color'] != '' ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbox_background_color']) : '#ffffff';   
            $this->chatgpt_assistant_chatbox_background_color = !isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbox_background_color']) && $this->chatbox_mode == 'dark' ? '#343541' : $this->chatgpt_assistant_chatbox_background_color;
            // Chat Widget header text color
            $this->chatgpt_assistant_chatbox_header_text_color = isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbox_header_text_color']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbox_header_text_color'] != '' ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbox_header_text_color']) : '#ffffff';   
            // Chat Widget header text letter_spacing
            $this->chatgpt_assistant_chatbox_header_text_letter_spacing = isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbox_header_text_letter_spacing']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbox_header_text_letter_spacing'] != '' ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbox_header_text_letter_spacing']) : '0';   
            // Chat Widget header text font_size
            $this->chatgpt_assistant_chatbox_header_text_font_size = isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbox_header_text_font_size']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbox_header_text_font_size'] != '' ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbox_header_text_font_size']) : '16';   
            // Message font size
            $this->chatgpt_assistant_message_font_size = isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_font_size']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_font_size'] != '' ? $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_font_size'] : 16;
            // Message font size mobile
            if( isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_font_size_mobile'] )){
                $this->chatgpt_assistant_message_font_size_mobile = ($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_font_size_mobile'] != '') ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_font_size_mobile']) : 16;
            } else{
                $this->chatgpt_assistant_message_font_size_mobile = $this->chatgpt_assistant_message_font_size ;
            }
            // Enable font size mobile
            $this->chatgpt_assistant_enable_message_font_size_mobile = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'enable_message_font_size_mobile'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'enable_message_font_size_mobile'] == 'on' ) ? true : false; 
            // Message letter spacing
            $this->chatgpt_assistant_message_letter_spacing = isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_letter_spacing']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_letter_spacing'] != '' ? $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_letter_spacing'] : 0;
            // Message spacing
            $this->chatgpt_assistant_message_spacing = isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_spacing']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_spacing'] != '' ? $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_spacing'] : 7;
            // Message border radius
            $this->chatgpt_assistant_message_border_radius = isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_border_radius']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_border_radius'] != '' ? absint(esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_border_radius'])) : 10;
            // chatbot border radius
            $this->chatgpt_assistant_chatbot_border_radius = isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbot_border_radius']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbot_border_radius'] != '' ? absint(esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbot_border_radius'])) : 10;
            // chatbot border radius mobile
            if( isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbot_border_radius_mobile'] )){
                $this->chatgpt_assistant_chatbot_border_radius_mobile = ($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbot_border_radius_mobile'] != '') ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'chatbot_border_radius_mobile']) : 10;
            } else{
                $this->chatgpt_assistant_chatbot_border_radius_mobile = $this->chatgpt_assistant_chatbot_border_radius ;
            }
            // Enable chatbot border radius mobile
            $this->chatgpt_assistant_enable_chatbot_border_radius_mobile = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'enable_chatbot_border_radius_mobile'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'enable_chatbot_border_radius_mobile'] == 'on' ) ? true : false; 
            // send message icon
            $this->chatgpt_assistant_send_message_icon = (isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'send_message_icon']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'send_message_icon'] != '') ? stripslashes ( esc_attr( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'send_message_icon'] ) ) : esc_attr(CHATGPT_ASSISTANT_ADMIN_URL) . "/images/icons/send-button-icon.svg";
            // send message text
            $this->chatgpt_assistant_send_message_text = (isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'send_message_text']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'send_message_text'] != '') ? stripslashes ( esc_attr( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX . 'send_message_text'] ) ) : "";
            // Send button font size
            $this->chatgpt_assistant_send_button_font_size = isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'send_button_font_size']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'send_button_font_size'] != '' ? $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'send_button_font_size'] : 16;
            // Send button padding
            $this->chatgpt_assistant_send_button_padding = isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'send_button_padding']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'send_button_padding'] != '' ? $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'send_button_padding'] : 6;

			$this->chatgpt_assistant_send_message_icon_text = __('Upload Image', 'ays-chatgpt-assistant');
			if ( $this->chatgpt_assistant_send_message_icon != '' ) {
				$this->chatgpt_assistant_send_message_icon_text = __('Edit Image', 'ays-chatgpt-assistant');
			}

            /* === END CHAT MODAL STYLES START === */

            // Button bg color
            $this->chatgpt_assistant_end_chat_button_bg_color = isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'end_chat_button_bg_color']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'end_chat_button_bg_color'] != '' ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'end_chat_button_bg_color']) : '#d93311';   
            // text color
            $this->chatgpt_assistant_end_chat_button_text_color = isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'end_chat_button_text_color']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'end_chat_button_text_color'] != '' ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'end_chat_button_text_color']) : '#ffffff';   
            // text font size
            $this->chatgpt_assistant_end_chat_button_text_font_size = isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'end_chat_button_text_font_size']) && intval($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'end_chat_button_text_font_size']) != 0 ? absint(esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'end_chat_button_text_font_size'])) : '16';   
            // text letter spacing
            $this->chatgpt_assistant_end_chat_button_text_letter_spacing = isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'end_chat_button_text_letter_spacing']) ? absint(esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'end_chat_button_text_letter_spacing'])) : '0';   

            /* === END CHAT MODAL STYLES END === */
            
            /* === USER MESSAGE STYLES START === */

                // User message background color
                if(isset($options['message_color']) && $options['message_color'] != ''){
                    $this->message_bg_color = $options['message_color'];
                }else{
                    if ( !(isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_bg_color']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_bg_color'] != '') ) {
                        $this->message_bg_color = '#4e426d';
                        if ($this->chatbox_mode == 'dark') {
                            $this->message_bg_color = '#343541';
                        }
                    } else {
                        $this->message_bg_color = esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_bg_color']);
                    }
                }

                // User message text color
                if ( !(isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_text_color']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_text_color'] != '') ) {
                    $this->message_text_color = '#ffffff';
                    if ($this->chatbox_mode == 'dark') {
                        $this->message_text_color = '#f1f1f1';
                    }
                } else {
                    $this->message_text_color = esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'message_text_color']);
                }

            /* === USER MESSAGE STYLES END === */

            /* === CHATBOT MESSAGE STYLES START === */

                // Chatbot response background color
                if(isset($options['response_color']) && $options['response_color'] != ''){
                    $this->response_bg_color = $options['response_color'];
                }else{
                    if ( !(isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'response_bg_color']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'response_bg_color'] != '') ) {
                        $this->response_bg_color = '#d3d3d3';
                        if ($this->chatbox_mode == 'dark') {
                            $this->response_bg_color = '#4b4d56';
                        }
                    } else {
                        $this->response_bg_color = esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'response_bg_color']);
                    }

                }

                // Chatbot response text color
                 if ( !(isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'response_text_color']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'response_text_color'] != '') ) {
                    $this->response_text_color = '#000000';
                    if ($this->chatbox_mode == 'dark') {
                        $this->response_text_color = '#ffffff';
                    }
                } else {
                    $this->response_text_color = esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'response_text_color']);
                }

                $this->response_icons_color = isset($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'response_icons_color']) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'response_icons_color'] != '' ? esc_attr($options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'response_icons_color']) : '#636a84';   

            /* === CHATBOT MESSAGE STYLES END === */
                $guest_icon_index = wp_rand(1, 10);

                $this->chat_icon = CHATGPT_ASSISTANT_ADMIN_URL . "/images/icons/chatgpt-icon.png";
                /* === USER PROFILE PICTURE START === */
                $this->user_profile_picture = '<img alt="" src="' . CHATGPT_ASSISTANT_ADMIN_URL . '/images/icons/guest_icon_'.$guest_icon_index.'.png">';
                if ( is_user_logged_in() ) {
                    $current_user = wp_get_current_user();
                    $this->user_profile_picture = (get_avatar( $current_user->ID, 32 ));
                }
                /* === USER PROFILE PICTURE END === */

        //

        // Set Chatbot options for JS
        // $generate_hush_api =  base64_encode($this->api_key . uniqid(uniqid('chgafr') . 'eds'));
		wp_localize_script( $this->plugin_name , 'AysChatGPTChatSettings', array(
            'ajaxUrl' => admin_url( 'admin-ajax.php' ),
            'nonce' => wp_create_nonce( 'ajax-nonce' ),  
		    'chatModel' => $this->chatgpt_assistant_chat_model,
		    'chatTemprature' => $this->chatgpt_assistant_chat_temprature,
		    'chatTopP' => $this->chatgpt_assistant_chat_top_p,
		    'chatMaxTokents' => $this->chatgpt_assistant_max_tokens,
		    'chatFrequencyPenalty' => $this->chatgpt_assistant_frequency_penalty,
		    'chatPresencePenalty' => $this->chatgpt_assistant_presence_penalty,
		    'chatBestOf' => $this->chatgpt_assistant_best_of,
		    'chatContext' => $this->chatgpt_assistant_context,
		    'chatProfession' => $this->chatgpt_assistant_profession,
		    'chatTone' => $this->chatgpt_assistant_tone,
		    'chatLanguage' => $this->chatgpt_assistant_language,
		    'chatName' => $this->chatgpt_assistant_name,
		    'chatGreetingMessage' => $this->chatgpt_assistant_greeting_message,
		    'chatMessagePlaceholder' => $this->chatgpt_assistant_message_placeholder,
		    'chatBotName' => $this->chatgpt_assistant_chatbot_name,
            'chatboxTheme' => $this->chatbox_theme,
			'chatIcon' => $this->chat_icon,
			'userProfilePicture' => $this->user_profile_picture,
		    'chatAutoOpening' => $this->chatgpt_assistant_auto_opening_chatbox,
		    'chatAutoOpeningDelay' => $this->chatgpt_assistant_auto_opening_chatbox_delay,
            'chatAutoOpeningMobile' => $this->chatgpt_assistant_auto_opening_chatbox_mobile,
		    'chatRegenerateResponse' => $this->chatgpt_assistant_regenerate_response,
		    'chatboxPosition' => $this->chatbox_position,
            'chatboxPositionMobile' => $this->chatbox_position_mobile,
            'chatboxEnablePositionMobile' => $this->chatbox_enable_position_mobile,
		    'chatboxIconPosition' => $this->chatbox_icon_position,
            'chatboxIconPositionMobile' => $this->chatbox_icon_position_mobile,
            'chatboxEnableIconPositionMobile' => $this->chatbox_enable_icon_position_mobile,
		    'chatboxIconSize' => $this->chatgpt_assistant_chat_icon_size,
            'chatboxIconSizeMobile' => $this->chatgpt_assistant_chat_icon_size_mobile,
            'enableChatboxIconSizeMobile' => $this->chatgpt_assistant_enable_chat_icon_size_mobile,
            'showDashboardChat' => $this->chatgpt_assistant_show_dashboard_chat,
            'showDashboardChatMobile' => $this->chatgpt_assistant_show_dashboard_chat_mobile,
            'chatGreetingMessageText' => $this->chatgpt_assistant_greeting_message_text,
            'translations' => array(
                'endChat' => array(
					'warningMsg' => __( "Do you really want to leave the current chat?", "ays-chatgpt-assistant" ),
					'buttonMsg' => __( "End chat", "ays-chatgpt-assistant" ),
					'modalIcon' => esc_attr(CHATGPT_ASSISTANT_ADMIN_URL) . "/images/icons/leave-icon.svg"
				),
				// 'ka' => $generate_hush_api,

            )
		) );
	}

	public function ays_chatgpt_update_banner_time(){

        $date = time() + ( 3 * 24 * 60 * 60 ) + (int) ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS);
        // $date = time() + ( 60 ) + (int) ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS); // for testing | 1 min
        $next_3_days = gmdate('M d, Y H:i:s', $date);

        $ays_chatgpt_banner_time = get_option('ays_chatgpt_banner_time');

        if ( !$ays_chatgpt_banner_time || is_null( $ays_chatgpt_banner_time ) ) {
            update_option('ays_chatgpt_banner_time', $next_3_days ); 
        }

        $get_ays_chatgpt_banner_time = get_option('ays_chatgpt_banner_time');

        $val = 60*60*24*0.5; // half day
        // $val = 60; // for testing | 1 min

        $current_date = current_time( 'mysql' );
        $date_diff = strtotime($current_date) - intval(strtotime($get_ays_chatgpt_banner_time));

        $days_diff = $date_diff / $val;
        if(intval($days_diff) > 0 ){
            update_option('ays_chatgpt_banner_time', $next_3_days);
			$get_ays_chatgpt_banner_time = get_option('ays_chatgpt_banner_time');
        }

        return $get_ays_chatgpt_banner_time;
    }
	
	public function ays_chatgpt_sale_baner(){

        
        // if (isset($_POST['ays_chatgpt_sale_btn']) && (isset( $_POST[CHATGPT_ASSISTANT_NAME . '-sale-banner'] ) && wp_verify_nonce( $_POST[CHATGPT_ASSISTANT_NAME . '-sale-banner'], CHATGPT_ASSISTANT_NAME . '-sale-banner' )) && current_user_can( 'manage_options' )) {
        //     update_option('ays_chatgpt_sale_btn', 1);
        //     update_option('ays_chatgpt_sale_date', current_time( 'mysql' ));
        // }
    
        $ays_chatgpt_sale_date = get_option('ays_chatgpt_sale_date');

        $val = 60*60*24*5;

        $current_date = current_time( 'mysql' );
        $date_diff = strtotime($current_date) - intval(strtotime($ays_chatgpt_sale_date)) ;
        
        $days_diff = $date_diff / $val;
    
        if(intval($days_diff) > 0 ){
            update_option('ays_chatgpt_sale_btn', 0);
        }
    
        $ays_chatgpt_maker_flag = intval(get_option('ays_chatgpt_sale_btn'));
        if( $ays_chatgpt_maker_flag == 0 ){
            // phpcs:ignore WordPress.Security.NonceVerification.Recommended
            if (isset($_GET['page']) && strpos(sanitize_text_field(wp_unslash($_GET['page'])), CHATGPT_ASSISTANT_NAME) !== false) {
                // $this->ays_chatgpt_sale_message_30_emma($ays_chatgpt_maker_flag);
				//$this->ays_chatgpt_sale_message20($ays_chatgpt_maker_flag);
                $this->ays_chatgpt_new_bundle_message_2025($ays_chatgpt_maker_flag);
				// $this->ays_chatgpt_helloween_message($ays_chatgpt_maker_flag);
				// $this->ays_chatgpt_black_friday_message_2024($ays_chatgpt_maker_flag);
				// $this->ays_chatgpt_christmas_message_2024($ays_chatgpt_maker_flag);
            }
        }
    }

    public function ays_chatgpt_dismiss_button(){

        $data = array(
            'status' => false,
        );

        if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'ays_chatgpt_dismiss_button') { 
            if ( isset( $_REQUEST['_ajax_nonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_REQUEST['_ajax_nonce'] ) ), CHATGPT_ASSISTANT_NAME . '-sale-banner' ) && current_user_can( 'manage_options' ) ) {
                update_option('ays_chatgpt_sale_btn', 1);
                update_option('ays_chatgpt_sale_date', current_time( 'mysql' ));
                $data['status'] = true;
            } else if ( isset( $_REQUEST['_ajax_nonce'] ) && wp_verify_nonce(sanitize_text_field(  wp_unslash( $_REQUEST['_ajax_nonce'] ) ), CHATGPT_ASSISTANT_NAME . '-gift-banner' ) && current_user_can( 'manage_options' ) ) {
                update_option('ays_chatgpt_gift_btn', 1);
                update_option('ays_chatgpt_gift_date', current_time( 'mysql' ));
                $data['status'] = true;
            }
        }

        ob_end_clean();
        $ob_get_clean = ob_get_clean();
        echo json_encode($data);
        wp_die();

    }

    public function ays_chatgpt_gift_baner(){
        
        // if (isset($_POST['ays_chatgpt_gift_btn']) && (isset( $_POST[CHATGPT_ASSISTANT_NAME . '-gift-banner'] ) && wp_verify_nonce( $_POST[CHATGPT_ASSISTANT_NAME . '-gift-banner'], CHATGPT_ASSISTANT_NAME . '-gift-banner' )) && current_user_can( 'manage_options' )) {
        //     update_option('ays_chatgpt_gift_btn', 1);
        //     update_option('ays_chatgpt_gift_date', current_time( 'mysql' ));
        // }
    
        $ays_chatgpt_gift_date = get_option('ays_chatgpt_gift_date');

        $val = 60*60*24*5;

        $current_date = current_time( 'mysql' );
        $date_diff = strtotime($current_date) - intval(strtotime($ays_chatgpt_gift_date)) ;
        
        $days_diff = $date_diff / $val;
    
        if(intval($days_diff) > 0 ){
            update_option('ays_chatgpt_gift_btn', 0);
        }
    
        $ays_chatgpt_maker_flag = intval(get_option('ays_chatgpt_gift_btn'));
        if( $ays_chatgpt_maker_flag == 0 ){
            // phpcs:ignore WordPress.Security.NonceVerification.Recommended
            if ( isset( $_GET['page'] ) && strpos( sanitize_text_field( wp_unslash( $_GET['page'] ) ), CHATGPT_ASSISTANT_NAME ) !== false ) {
				$this->ays_chatgpt_gift_message($ays_chatgpt_maker_flag);
            }
        }
    }

    // Gift banner
    public function ays_chatgpt_gift_message($ishmar){
        if($ishmar == 0 ){
            $content = array();

            $content[] = '<div id="ays-chatgpt-dicount-month-main" class="notice notice-success is-dismissible ays_chatgpt_dicount_info" style="padding-top:10px;padding-bottom:10px">';
                $content[] = '<div id="ays-chatgpt-dicount-month" class="ays_chatgpt_dicount_month">';
                    $content[] = '<a href="' . admin_url('admin.php?page='.$this->plugin_name.'-gift') . '" target="_blank" class="ays-chatgpt-sale-banner-link" ><img src="' . esc_attr(CHATGPT_ASSISTANT_ADMIN_URL) . '/images/icons/chatgpt-icon.png"></a>';

                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box">';

                        $content[] = '<strong style="font-weight:bold;width:100%;font-size:20px">';
                            $content[] = 'Get the <a style="color:#1FAB90;" href="' . admin_url('admin.php?page='.$this->plugin_name.'-gift') . '" target="_blank">PRO Version</a> for free.';
                        $content[] = '</strong>';
                            
                    $content[] = '</div>';

                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-buy-now-button-box" style="width:20%">';
                        $content[] = '<a href="' . admin_url('admin.php?page='.$this->plugin_name.'-gift') . '" class="button button-primary ays-button" id="ays-button-top-buy-now" target="_blank">' . __( 'Learn more!', "ays-chatgpt-assistant" ) . '</a>';
                    $content[] = '</div>';

                $content[] = '</div>';

                $content[] = '<div style="position: absolute;right: 0;bottom: 1px;" class="ays-chatgpt-dismiss-buttons-container-for-form">';
                    $content[] = '<form action="" method="POST">';
                        $content[] = '<div id="ays-chatgpt-dismiss-buttons-content">';
                            if (current_user_can( 'manage_options' )) {
                                $content[] = '<button class="btn btn-link ays-button" name="ays_chatgpt_gift_btn" style="height: 32px; margin-left: 0;padding-left: 0; color: #979797;">Dismiss ad</button>';
                                $content[] = wp_nonce_field( CHATGPT_ASSISTANT_NAME . '-gift-banner' ,  CHATGPT_ASSISTANT_NAME . '-gift-banner' );
                            }
                        $content[] = '</div>';
                    $content[] = '</form>';
                $content[] = '</div>';

            $content[] = '</div>';

            $content = implode( '', $content );
            echo html_entity_decode(esc_html( $content ));// phpcs:ignore
        }
    }

    // 30% Sale Emma
    public function ays_chatgpt_sale_message_30_emma($ishmar){
        if($ishmar == 0 ){
            $content = array();
            $content[] = '<div id="ays-chatgpt-new-mega-bundle-dicount-month-main-2024" class="notice notice-success is-dismissible ays_chatgpt_dicount_info">';
                $content[] = '<div id="ays-chatgpt-dicount-month" class="ays_chatgpt_dicount_month">';

                    $content[] = '<div class="ays-chatgpt-discount-box-sale-image"></div>';
                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-text-box">';

                        $content[] = '<div class="ays-chatgpt-dicount-wrap-text-box-texts">';
                            $content[] = '<div>
                                            <a href="https://ays-pro.com/wordpress/chatgpt-assistant?utm_source=dashboard&utm_medium=gpt-free&utm_campaign=sale-banner" target="_blank" style="color:#30499B;">
                                            <span class="ays-chatgpt-new-mega-bundle-limited-text">Limited</span> Offer for ChatGPT Assistant </a> <br> 
                                          </div>';
                        $content[] = '</div>';

                        $content[] = '<div style="font-size: 17px;">';
                            $content[] = '<img style="width: 24px;height: 24px;" src="' . esc_attr(CHATGPT_ASSISTANT_ADMIN_URL) . '/images/icons/guarantee-new.png">';
                            $content[] = '<span style="padding-left: 4px; font-size: 14px; font-weight: 600;"> 30 Day Money Back Guarantee</span>';
                            
                        $content[] = '</div>';

                       

                        $content[] = '<div style="position: absolute;right: 10px;bottom: 1px;" class="ays-chatgpt-dismiss-buttons-container-for-chatgpt">';

                            $content[] = '<form action="" method="POST">';
                                $content[] = '<div id="ays-chatgpt-dismiss-buttons-content">';
                                    if( current_user_can( 'manage_options' ) ){
                                        $content[] = '<button class="btn btn-link ays-button" name="ays_chatgpt_sale_btn" style="height: 32px; margin-left: 0;padding-left: 0; color: #30499B;
                                        ">Dismiss ad</button>';
                                        $content[] = wp_nonce_field( $this->plugin_name . '-sale-banner' ,  $this->plugin_name . '-sale-banner' );
                                    }
                                $content[] = '</div>';
                            $content[] = '</form>';
                            
                        $content[] = '</div>';

                    $content[] = '</div>';

                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-countdown-box">';

                        $content[] = '<div id="ays-chatgpt-countdown-main-container">';
                            $content[] = '<div class="ays-chatgpt-countdown-container">';

                                $content[] = '<div id="ays-chatgpt-countdown">';

                                    $content[] = '<div style="font-weight: 500;">';
                                        $content[] = __( "Offer ends in:", "ays-chatgpt-assistant" );
                                    $content[] = '</div>';

                                    $content[] = '<ul>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-days"></span>days</li>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-hours"></span>Hours</li>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-minutes"></span>Minutes</li>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-seconds"></span>Seconds</li>';
                                    $content[] = '</ul>';
                                $content[] = '</div>';

                                $content[] = '<div id="ays-chatgpt-countdown-content" class="emoji">';
                                    $content[] = '<span>🚀</span>';
                                    $content[] = '<span>⌛</span>';
                                    $content[] = '<span>🔥</span>';
                                    $content[] = '<span>💣</span>';
                                $content[] = '</div>';

                            $content[] = '</div>';
                        $content[] = '</div>';
                            
                    $content[] = '</div>';

                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-button-box">';
                        $content[] = '<a href="https://ays-pro.com/wordpress/chatgpt-assistant?utm_source=dashboard&utm_medium=gpt-free&utm_campaign=sale-banner" class="button button-primary ays-button" id="ays-button-top-buy-now" target="_blank">' . __( 'Buy Now !', 'ays-chatgpt-assistant' ) . '</a>';
                        $content[] = '<span >One-time payment</span>';
                    $content[] = '</div>';
                $content[] = '</div>';
            $content[] = '</div>';

            $content = implode( '', $content );
            echo html_entity_decode(esc_html( $content ));// phpcs:ignore
        }        
    }

	// Self 20% sale
    public static function ays_chatgpt_sale_message20($ishmar){
        if($ishmar == 0 ){
            $content = array();

            $content[] = '<div id="ays-chatgpt-dicount-month-main" class="notice notice-success is-dismissible ays_chatgpt_dicount_info">';
                $content[] = '<div id="ays-chatgpt-dicount-month" class="ays_chatgpt_dicount_month">';
                    // $content[] = '<a href="https://ays-pro.com/wordpress/chatgpt-assistant" target="_blank" class="ays-chatgpt-sale-banner-link"><img src="' . CHATGPT_ASSISTANT_ADMIN_URL . '/images/ays_chatgpt_logo.png"></a>';

                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-text-box">';

                        $content[] = '<div class="ays-chatgpt-dicount-sale-name-discount-box">';
							$content[] = '<span class="ays-chatgpt-new-chatgpt-pro-title">';
                            $content[] = sprintf(
                                            /* translators: %s is the URL for the ChatGPT Assistant */
                                            __( "<span><a href='%s' target='_blank' style='color:#ffffff; text-decoration: underline;'>ChatGPT Assistant</a></span>", "ays-chatgpt-assistant" ),
                                            esc_url("https://ays-pro.com/wordpress/chatgpt-assistant?utm_source=dashboard&utm_medium=gpt-free&utm_campaign=sale-banner" . CHATGPT_ASSISTANT_VERSION)
                                        );
							$content[] = '</span>';
							$content[] = '<div>';
								$content[] = '<img src="' . CHATGPT_ASSISTANT_ADMIN_URL . '/images/ays-chatgpt-banner-sale-30.svg" style="width: 70px;">';
							$content[] = '</div>';
						$content[] = '</div>';

                        $content[] = '<span class="ays-chatgpt-new-chatgpt-pro-desc">';
							$content[] = '<img class="ays-chatgpt-new-chatgpt-pro-guaranteeicon" src="' . CHATGPT_ASSISTANT_ADMIN_URL . '/images/chatgpt-assistant-guaranteeicon.webp" style="width: 30px;">';
							$content[] = __( "30 Days Money Back Guarantee", 'ays-chatgpt-assistant' );
						$content[] = '</span>';
     
                        $content[] = '<div style="position: absolute;right: 10px;bottom: 1px;" class="ays-chatgpt-dismiss-buttons-container-for-chatgpt">';
                            $content[] = '<form action="" method="POST">';
                                $content[] = '<div id="ays-chatgpt-dismiss-buttons-content">';
                                    if (current_user_can( 'manage_options' )) {
                                        $content[] = '<button class="btn btn-link ays-button" name="ays_chatgpt_sale_btn" style="height: 32px; margin-left: 0;padding-left: 0">Dismiss ad</button>';
                                        $content[] = wp_nonce_field( CHATGPT_ASSISTANT_NAME . '-sale-banner' ,  CHATGPT_ASSISTANT_NAME . '-sale-banner' );
                                    }
                                $content[] = '</div>';
                            $content[] = '</form>';
                        $content[] = '</div>';

                    $content[] = '</div>';

                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-countdown-box">';

                        $content[] = '<div id="ays-chatgpt-countdown-main-container">';
                            $content[] = '<div class="ays-chatgpt-countdown-container">';
                                $content[] = '<div id="ays-chatgpt-countdown" style="display: block;">';
                                    $content[] = __( "Offer ends in:", 'ays-chatgpt-assistant' );
                                    
                                    $content[] = '<ul style="padding: 0">';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-days">0</span>' . __( 'Days', 'ays-chatgpt-assistant' ) . '</li>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-hours">0</span>' . __( 'Hours', 'ays-chatgpt-assistant' ) . '</li>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-minutes">0</span>' . __( 'Minutes', 'ays-chatgpt-assistant' ) . '</li>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-seconds">0</span>' . __( 'Seconds', 'ays-chatgpt-assistant' ) . '</li>';
                                    $content[] = '</ul>';
                                $content[] = '</div>';

                                $content[] = '<div id="ays-chatgpt-countdown-content" class="emoji" style="display: none;">';
                                    $content[] = '<span>🚀</span>';
                                    $content[] = '<span>⌛</span>';
                                    $content[] = '<span>🔥</span>';
                                    $content[] = '<span>💣</span>';
                                $content[] = '</div>';
                            $content[] = '</div>';
                        $content[] = '</div>';
                            
                    $content[] = '</div>';

                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-button-box">';
                        $content[] = '<a href="https://ays-pro.com/wordpress/chatgpt-assistant?utm_source=dashboard&utm_medium=gpt-free&utm_campaign=sale-banner'.CHATGPT_ASSISTANT_VERSION.'" class="button button-primary ays-button" id="ays-button-top-buy-now" target="_blank" style="" >' . __( 'Buy Now', 'ays-chatgpt-assistant' ) . '</a>';
                        $content[] = '<span class="ays-chatgpt-dicount-one-time-text">';
                            $content[] = __( "One-time payment", 'ays-chatgpt-assistant' );
                        $content[] = '</span>';
                    $content[] = '</div>';

                $content[] = '</div>';

            $content[] = '</div>';

            $content = implode( '', $content );
            echo $content;// phpcs:ignore
        }
    }

    // Helloween banner
    public static function ays_chatgpt_helloween_message($ishmar){
        if($ishmar == 0 ){
            $content = array();

            $content[] = '<div id="ays-chatgpt-dicount-month-main-helloween" class="notice notice-success is-dismissible ays_chatgpt_dicount_info">';
                $content[] = '<div id="ays-chatgpt-dicount-month-helloween" class="ays_chatgpt_dicount_month_helloween">';
                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box-helloween-limited">';

                        $content[] = '<p>';
                            $content[] = __( "Limited Time 
                            <span class='ays-chatgpt-dicount-wrap-color-helloween' style='color:#b2ff00;'>30%</span> 
                            <span>
                                SALE on
                            </span> 
                            <br>
                            <span style='' class='ays-chatgpt-helloween-bundle'>
                                <a href='https://ays-pro.com/wordpress/chatgpt-assistant?utm_source=dashboard&utm_medium=gpt-free&utm_campaign=halloween-sale-banner' target='_blank' class='ays-chatgpt-dicount-wrap-color-helloween ays-chatgpt-dicount-wrap-text-decoration-helloween' style='display:block; color:#b2ff00;margin-right:6px;'>
                                    ChatGPT Assistant
                                </a>
                            </span>", 'ays-chatgpt-assistant' );
                        $content[] = '</p>';
                        $content[] = '<p>';
                                $content[] = __( "Hurry up! 
                                                <a href='https://ays-pro.com/wordpress/chatgpt-assistant?utm_source=dashboard&utm_medium=gpt-free&utm_campaign=halloween-sale-banner' target='_blank' style='color:#ffc700;'>
                                                    Check it out!
                                                </a>", 'ays-chatgpt-assistant' );
                        $content[] = '</p>';
                            
                    $content[] = '</div>';

                    
                    $content[] = '<div class="ays-chatgpt-helloween-bundle-buy-now-timer">';
                        $content[] = '<div class="ays-chatgpt-dicount-wrap-box-helloween-timer">';
                            $content[] = '<div id="ays-chatgpt-countdown-main-container" class="ays-chatgpt-countdown-main-container-helloween">';
                                $content[] = '<div class="ays-chatgpt-countdown-container-helloween">';
                                    $content[] = '<div id="ays-chatgpt-countdown">';
                                        $content[] = '<ul>';
                                            $content[] = '<li><p><span id="ays-chatgpt-countdown-days"></span><span>days</span></p></li>';
                                            $content[] = '<li><p><span id="ays-chatgpt-countdown-hours"></span><span>Hours</span></p></li>';
                                            $content[] = '<li><p><span id="ays-chatgpt-countdown-minutes"></span><span>Mins</span></p></li>';
                                            $content[] = '<li><p><span id="ays-chatgpt-countdown-seconds"></span><span>Secs</span></p></li>';
                                        $content[] = '</ul>';
                                    $content[] = '</div>';

                                    $content[] = '<div id="ays-chatgpt-countdown-content" class="emoji">';
                                        $content[] = '<span>🚀</span>';
                                        $content[] = '<span>⌛</span>';
                                        $content[] = '<span>🔥</span>';
                                        $content[] = '<span>💣</span>';
                                    $content[] = '</div>';

                                $content[] = '</div>';

                            $content[] = '</div>';
                                
                        $content[] = '</div>';
                        $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-buy-now-button-box-helloween">';
                            $content[] = '<a href="https://ays-pro.com/wordpress/chatgpt-assistant?utm_source=dashboard&utm_medium=gpt-free&utm_campaign=halloween-sale-banner" class="button button-primary ays-buy-now-button-helloween" id="ays-button-top-buy-now-helloween" target="_blank" style="" >' . __( 'Buy Now !', 'ays-chatgpt-assistant' ) . '</a>';
                        $content[] = '</div>';
                    $content[] = '</div>';

                $content[] = '</div>';

                $content[] = '<div style="position: absolute;right: 0;bottom: 1px;"  class="ays-chatgpt-dismiss-buttons-container-for-form-helloween">';
                    $content[] = '<form action="" method="POST">';
                        $content[] = '<div id="ays-chatgpt-dismiss-buttons-content-helloween">';
                        if( current_user_can( 'manage_options' ) ){
                            $content[] = '<button class="btn btn-link ays-button-helloween" name="ays_chatgpt_sale_btn" style="height: 32px; margin-left: 0;padding-left: 0">Dismiss ad</button>';
                            $content[] = wp_nonce_field( CHATGPT_ASSISTANT_NAME . '-sale-banner' ,  CHATGPT_ASSISTANT_NAME . '-sale-banner' );
                        }
                        $content[] = '</div>';
                    $content[] = '</form>';

                $content[] = '</div>';
                // $content[] = '<button type="button" class="notice-dismiss">';
                // $content[] = '</button>';
            $content[] = '</div>';

            $content = implode( '', $content );

            echo $content;// phpcs:ignore
        }
    }

    // Black Friday banner
    public static function ays_chatgpt_black_friday_message($ishmar){
        if($ishmar == 0 ){
            $content = array();

            $content[] = '<div id="ays-chatgpt-dicount-black-friday-month-main" class="notice notice-success is-dismissible ays_chatgpt_dicount_info">';
                $content[] = '<div id="ays-chatgpt-dicount-black-friday-month" class="ays_chatgpt_dicount_month">';
                    $content[] = '<div class="ays-chatgpt-dicount-black-friday-box">';
                        $content[] = '<div class="ays-chatgpt-dicount-black-friday-wrap-box ays-chatgpt-dicount-black-friday-wrap-box-80" style="width: 70%;">';
                            $content[] = '<div class="ays-chatgpt-dicount-black-friday-title-row">' . __( 'Limited Time', "ays-chatgpt-assistant" ) .' '. '<a href="https://ays-pro.com/wordpress/chatgpt-assistant?utm_medium=gpt-free&utm_campaign=black-friday-sale-banner" class="ays-chatgpt-dicount-black-friday-button-sale" target="_blank">' . __( 'Sale', "ays-chatgpt-assistant" ) . '</a>' . '</div>';
                            $content[] = '<div class="ays-chatgpt-dicount-black-friday-title-row">' . __( 'ChatGPT Assistant plugin', "ays-chatgpt-assistant" ) . '</div>';
                        $content[] = '</div>';

                        $content[] = '<div class="ays-chatgpt-dicount-black-friday-wrap-box ays-chatgpt-dicount-black-friday-wrap-text-box">';
                            $content[] = '<div class="ays-chatgpt-dicount-black-friday-text-row">' . __( '20% off', "ays-chatgpt-assistant" ) . '</div>';
                        $content[] = '</div>';

                        $content[] = '<div class="ays-chatgpt-dicount-black-friday-wrap-box" style="width: 25%;">';
                            $content[] = '<div id="ays-chatgpt-countdown-main-container">';
                                $content[] = '<div class="ays-chatgpt-countdown-container">';
                                    $content[] = '<div id="ays-chatgpt-countdown" style="display: block;">';
                                        $content[] = '<ul>';
                                            $content[] = '<li><span id="ays-chatgpt-countdown-days">0</span>' . __( 'Days', "ays-chatgpt-assistant" ) . '</li>';
                                            $content[] = '<li><span id="ays-chatgpt-countdown-hours">0</span>' . __( 'Hours', "ays-chatgpt-assistant" ) . '</li>';
                                            $content[] = '<li><span id="ays-chatgpt-countdown-minutes">0</span>' . __( 'Minutes', "ays-chatgpt-assistant" ) . '</li>';
                                            $content[] = '<li><span id="ays-chatgpt-countdown-seconds">0</span>' . __( 'Seconds', "ays-chatgpt-assistant" ) . '</li>';
                                        $content[] = '</ul>';
                                    $content[] = '</div>';
                                    $content[] = '<div id="ays-chatgpt-countdown-content" class="emoji" style="display: none;">';
                                        $content[] = '<span>🚀</span>';
                                        $content[] = '<span>⌛</span>';
                                        $content[] = '<span>🔥</span>';
                                        $content[] = '<span>💣</span>';
                                    $content[] = '</div>';
                                $content[] = '</div>';
                            $content[] = '</div>';
                        $content[] = '</div>';

                        $content[] = '<div class="ays-chatgpt-dicount-black-friday-wrap-box" style="width: 25%;">';
                            $content[] = '<a href="https://ays-pro.com/wordpress/chatgpt-assistant?utm_medium=gpt-free&utm_campaign=black-friday-sale-banner" class="ays-chatgpt-dicount-black-friday-button-buy-now" target="_blank">' . __( 'Get Your Deal', "ays-chatgpt-assistant" ) . '</a>';
                        $content[] = '</div>';
                    $content[] = '</div>';
                $content[] = '</div>';

                $content[] = '<div style="position: absolute;right: 0;bottom: 1px;"  class="ays-chatgpt-dismiss-buttons-container-for-form-black-friday">';
                    $content[] = '<form action="" method="POST">';
                        $content[] = '<div id="ays-chatgpt-dismiss-buttons-content-black-friday">';
                            if( current_user_can( 'manage_options' ) ){
                                $content[] = '<button class="btn btn-link ays-button-black-friday" name="ays_chatgpt_sale_btn" style="">' . __( 'Dismiss ad', "ays-chatgpt-assistant" ) . '</button>';
                                $content[] = wp_nonce_field( CHATGPT_ASSISTANT_NAME . '-sale-banner' ,  CHATGPT_ASSISTANT_NAME . '-sale-banner' );
                            }
                        $content[] = '</div>';
                    $content[] = '</form>';
                $content[] = '</div>';
            $content[] = '</div>';

            $content = implode( '', $content );

            echo esc_html($content);
        }
    }

    // Black Friday 2024
    public function ays_chatgpt_black_friday_message_2024($ishmar){
        if($ishmar == 0 ){
            $content = array();

            $content[] = '<div id="ays-chatgpt-black-friday-bundle-dicount-month-main" class="notice notice-success is-dismissible ays_chatgpt_dicount_info">';
                $content[] = '<div id="ays-chatgpt-dicount-month" class="ays_chatgpt_dicount_month">';

                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-countdown-box">';

                        $content[] = '<div id="ays-chatgpt-countdown-main-container">';
                            $content[] = '<div class="ays-chatgpt-countdown-container">';

                                $content[] = '<div id="ays-chatgpt-countdown">';

                                    $content[] = '<div>';
                                        $content[] = __( "Offer ends in:", 'ays-chatgpt-assistant' );
                                    $content[] = '</div>';

                                    $content[] = '<ul>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-days"></span>'. __( "Days", 'ays-chatgpt-assistant' ) .'</li>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-hours"></span>'. __( "Hours", 'ays-chatgpt-assistant' ) .'</li>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-minutes"></span>'. __( "Minutes", 'ays-chatgpt-assistant' ) .'</li>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-seconds"></span>'. __( "Seconds", 'ays-chatgpt-assistant' ) .'</li>';
                                    $content[] = '</ul>';
                                $content[] = '</div>';

                                $content[] = '<div id="ays-chatgpt-countdown-content" class="emoji">';
                                    $content[] = '<span>🚀</span>';
                                    $content[] = '<span>⌛</span>';
                                    $content[] = '<span>🔥</span>';
                                    $content[] = '<span>💣</span>';
                                $content[] = '</div>';

                            $content[] = '</div>';
                        $content[] = '</div>';
                            
                    $content[] = '</div>';

                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-text-box">';
                        $content[] = '<div>';

                            $content[] = '<span class="ays-chatgpt-black-friday-bundle-title">';
                                $content[] = __( "<span><a href='https://ays-pro.com/business-bundle?utm_source=dashboard&utm_medium=gpt-free&utm_campaign=black-friday-business-bundle-sale-banner' class='ays-chatgpt-black-friday-bundle-title-link' target='_blank'>Black Friday Sale</a></span>", 'ays-chatgpt-assistant' );
                            $content[] = '</span>';

                            $content[] = '</br>';

                            $content[] = '<span class="ays-chatgpt-black-friday-bundle-desc">';
                                $content[] = '<a class="ays-chatgpt-black-friday-bundle-desc" href="https://ays-pro.com/business-bundle?utm_source=dashboard&utm_medium=gpt-free&utm_campaign=black-friday-business-bundle-sale-banner" class="ays-chatgpt-black-friday-bundle-title-link" target="_blank">';
                                    $content[] = __( "50% OFF", 'ays-chatgpt-assistant' );
                                $content[] = '</a>';
                            $content[] = '</span>';
                        $content[] = '</div>';

                        $content[] = '<div style="position: absolute;right: 10px;bottom: 1px;" class="ays-chatgpt-dismiss-buttons-container-for-form">';

                            $content[] = '<form action="" method="POST">';
                                $content[] = '<div id="ays-chatgpt-dismiss-buttons-content">';
                                if( current_user_can( 'manage_options' ) ){
                                    $content[] = '<button class="btn btn-link ays-button" name="ays_chatgpt_sale_btn" style="height: 32px; margin-left: 0;padding-left: 0">'. __( "Dismiss ad", 'ays-chatgpt-assistant' ) .'</button>';
                                    $content[] = wp_nonce_field( CHATGPT_ASSISTANT_NAME . '-sale-banner' ,  CHATGPT_ASSISTANT_NAME . '-sale-banner' );
                                }
                                $content[] = '</div>';
                            $content[] = '</form>';
                            
                        $content[] = '</div>';

                    $content[] = '</div>';

                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-text-box">';
                        $content[] = '<span class="ays-chatgpt-black-friday-bundle-title">';
                            $content[] = '<a class="ays-chatgpt-black-friday-bundle-title-link" href="https://ays-pro.com/business-bundle?utm_source=dashboard&utm_medium=gpt-free&utm_campaign=black-friday-business-bundle-sale-banner" target="_blank">';
                                $content[] = __( 'Business Bundle', 'ays-chatgpt-assistant' );
                            $content[] = '</a>';
                        $content[] = '</span>';
                    $content[] = '</div>';

                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-button-box">';
                        $content[] = '<a href="https://ays-pro.com/business-bundle?utm_source=dashboard&utm_medium=gpt-free&utm_campaign=black-friday-business-bundle-sale-banner" class="button button-primary ays-button" id="ays-button-top-buy-now" target="_blank">' . __( 'Get Your Deal', 'ays-chatgpt-assistant' ) . '</a>';
                        $content[] = '<span class="ays-chatgpt-dicount-one-time-text">';
                            $content[] = __( "One-time payment", 'ays-chatgpt-assistant' );
                        $content[] = '</span>';
                    $content[] = '</div>';
                $content[] = '</div>';
            $content[] = '</div>';

            $content = implode( '', $content );
            echo esc_html($content);
        }
    }

    // Christmas Top Banner 2024
    public function ays_chatgpt_christmas_message_2024($ishmar){
        if($ishmar == 0 ){
            $content = array();
            $content[] = '<div id="ays-chatgpt-christmas-top-bundle-dicount-month-main" class="notice notice-success is-dismissible ays_chatgpt_dicount_info">';
                $content[] = '<div id="ays-chatgpt-dicount-month" class="ays_chatgpt_dicount_month">';
                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-countdown-box">';
                        $content[] = '<div id="ays-chatgpt-countdown-main-container">';
                            $content[] = '<div class="ays-chatgpt-countdown-container">';
                                $content[] = '<div id="ays-chatgpt-countdown">';
                                    $content[] = '<div>';
                                        $content[] = __( "Offer ends in:", 'ays-chatgpt-assistant' );
                                    $content[] = '</div>';
                                    $content[] = '<ul style="padding-left: 0;">';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-days"></span>'. __( "Days", 'ays-chatgpt-assistant' ) .'</li>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-hours"></span>'. __( "Hours", 'ays-chatgpt-assistant' ) .'</li>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-minutes"></span>'. __( "Minutes", 'ays-chatgpt-assistant' ) .'</li>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-seconds"></span>'. __( "Seconds", 'ays-chatgpt-assistant' ) .'</li>';
                                    $content[] = '</ul>';
                                $content[] = '</div>';
                                $content[] = '<div id="ays-chatgpt-countdown-content" class="emoji">';
                                    $content[] = '<span>🚀</span>';
                                    $content[] = '<span>⌛</span>';
                                    $content[] = '<span>🔥</span>';
                                    $content[] = '<span>💣</span>';
                                $content[] = '</div>';
                            $content[] = '</div>';
                        $content[] = '</div>';
                            
                    $content[] = '</div>';
                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-text-box">';
                        $content[] = '<div>';
                            $content[] = '<span class="ays-chatgpt-christmas-top-bundle-title">';
                            $content[] = sprintf(
                                            /* translators: %s is the URL for the ChatGPT Assistant Christmas Sale */
                                            __( "<span><a href='%s' target='_blank' style='color:#ffffff; text-decoration: underline;'>ChatGPT Assistant</a></span>", "ays-chatgpt-assistant" ),
                                            esc_url("https://ays-pro.com/wordpress/chatgpt-assistant?utm_source=dashboard&utm_medium=gpt-free&utm_campaign=sale-banner" . CHATGPT_ASSISTANT_VERSION)
                                        );
                            $content[] = '</span>';
                            $content[] = '</br>';
                            $content[] = '<span class="ays-chatgpt-christmas-top-bundle-desc">';
                                $content[] = '<a class="ays-chatgpt-christmas-top-bundle-desc" href="https://ays-pro.com/wordpress/chatgpt-assistant?utm_source=dashboard&utm_medium=chatgpt-free&utm_campaign=christmas-sale-banner'.CHATGPT_ASSISTANT_VERSION.'" class="ays-chatgpt-christmas-top-bundle-title-link" target="_blank">';
                                    $content[] = __( "20% Extra OFF", 'ays-chatgpt-assistant' );
                                $content[] = '</a>';
                            $content[] = '</span>';
                        $content[] = '</div>';
                        $content[] = '<div style="position: absolute;right: 10px;bottom: 1px;" class="ays-chatgpt-dismiss-buttons-container-for-form">';
                            $content[] = '<form action="" method="POST">';
                                $content[] = '<div id="ays-chatgpt-dismiss-buttons-content">';
                                if( current_user_can( 'manage_options' ) ){
                                    $content[] = '<button class="btn btn-link ays-button" name="ays_chatgpt_sale_btn" style="height: 32px; margin-left: 0;padding-left: 0">'. __( "Dismiss ad", 'ays-chatgpt-assistant' ) .'</button>';
                                    $content[] = wp_nonce_field( CHATGPT_ASSISTANT_NAME . '-sale-banner' ,  CHATGPT_ASSISTANT_NAME . '-sale-banner' );
                                }
                                $content[] = '</div>';
                            $content[] = '</form>';
                            
                        $content[] = '</div>';
                    $content[] = '</div>';
                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-christmas-top-bundle-coupon-text-box">';
                        $content[] = '<div class="ays-chatgpt-christmas-top-bundle-coupon-row">';
                            $content[] = 'xmas20off';
                        $content[] = '</div>';
                        $content[] = '<div class="ays-chatgpt-christmas-top-bundle-text-row">';
                            $content[] = __( '20% Extra Discount Coupon', 'ays-chatgpt-assistant' );
                        $content[] = '</div>';
                    $content[] = '</div>';
                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-button-box">';
                        $content[] = '<a href="https://ays-pro.com/wordpress/chatgpt-assistant?utm_source=dashboard&utm_medium=chatgpt-free&utm_campaign=christmas-sale-banner'.CHATGPT_ASSISTANT_VERSION.'" class="button button-primary ays-button" id="ays-button-top-buy-now" target="_blank">' . __( 'Get Your Deal', 'ays-chatgpt-assistant' ) . '</a>';
                        $content[] = '<span class="ays-chatgpt-dicount-one-time-text">';
                            $content[] = __( "One-time payment", 'ays-chatgpt-assistant' );
                        $content[] = '</span>';
                    $content[] = '</div>';
                $content[] = '</div>';
            $content[] = '</div>';
            $content = implode( '', $content );
            echo esc_html($content);
        }
    }

    //new 2025 bundle
    public function ays_chatgpt_new_bundle_message_2025($ishmar){
        if($ishmar == 0 ){
            $content = array();

            $content[] = '<div id="ays-chatgpt-new-bundle-2025-dicount-month-main" class="notice notice-success is-dismissible ays_chatgpt_dicount_info">';
                $content[] = '<div id="ays-chatgpt-dicount-month" class="ays_chatgpt_dicount_month">';

                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-text-box">';
                        $content[] = '<div>';

                            $content[] = '<span class="ays-chatgpt-new-bundle-2025-title">';
                            
                                $content[] = sprintf(
                                            /* translators: %s is the URL for the ChatGPT Assistant */
                                            __( "<span><a href='%s' target='_blank' style='color:#ffffff; text-decoration: underline;'>ChatGPT Assistant</a></span>", "ays-chatgpt-assistant" ),
                                            esc_url("https://ays-pro.com/wordpress/chatgpt-assistant?utm_source=dashboard&utm_medium=gpt-free&utm_campaign=sale-banner" . CHATGPT_ASSISTANT_VERSION)
                                        );
                               
                            $content[] = '</span>';

                            $content[] = '</br>';

                            $content[] = '<span class="ays-chatgpt-new-bundle-2025-desc">';
                                $content[] = __( "30 Day Money Back Guarantee", 'ays-chatgpt-assistant' );
                            $content[] = '</span>';
                        $content[] = '</div>';
                        $content[] = '<div>';
                            $content[] = '<img class="ays-chatgpt-new-bundle-guaranteeicon" src="' . CHATGPT_ASSISTANT_ADMIN_URL . '/images/ays-chatgpt-new-bundle-2025-discount.svg" style="width: 70px; margin-left:10px;">';
                        $content[] = '</div>';
                        $content[] = '<div style="position: absolute;right: 10px;bottom: 1px;" class="ays-chatgpt-dismiss-buttons-container-for-form">';

                            $content[] = '<form action="" method="POST">';
                                $content[] = '<div id="ays-chatgpt-dismiss-buttons-content">';
                                if( current_user_can( 'manage_options' ) ){
                                    $content[] = '<button class="btn btn-link ays-button" name="ays_chatgpt_sale_btn" style="height: 32px; margin-left: 0;padding-left: 0">'. __( "Dismiss ad", 'ays-chatgpt-assistant' ) .'</button>';
                                    $content[] = wp_nonce_field( CHATGPT_ASSISTANT_NAME . '-sale-banner' ,  CHATGPT_ASSISTANT_NAME . '-sale-banner' );
                                }
                                $content[] = '</div>';
                            $content[] = '</form>';
                            
                        $content[] = '</div>';

                    $content[] = '</div>';

                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-countdown-box">';

                        $content[] = '<div id="ays-chatgpt-countdown-main-container">';
                            $content[] = '<div class="ays-chatgpt-countdown-container">';

                                $content[] = '<div id="ays-chatgpt-countdown">';

                                    $content[] = '<ul>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-days"></span>'. __( "Days", 'ays-chatgpt-assistant' ) .'</li>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-hours"></span>'. __( "Hours", 'ays-chatgpt-assistant' ) .'</li>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-minutes"></span>'. __( "Minutes", 'ays-chatgpt-assistant' ) .'</li>';
                                        $content[] = '<li><span id="ays-chatgpt-countdown-seconds"></span>'. __( "Seconds", 'ays-chatgpt-assistant' ) .'</li>';
                                    $content[] = '</ul>';
                                $content[] = '</div>';

                                $content[] = '<div id="ays-chatgpt-countdown-content" class="emoji">';
                                    $content[] = '<span></span>';
                                    $content[] = '<span></span>';
                                    $content[] = '<span></span>';
                                    $content[] = '<span></span>';
                                $content[] = '</div>';

                            $content[] = '</div>';
                        $content[] = '</div>';
                            
                    $content[] = '</div>';
                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-coupon-text-box">';
                        $content[] = '<div class="ays-chatgpt-dicount-wrap-coupon-row">';
                            $content[] = 'freetopro10off';
                        $content[] = '</div>';
                        $content[] = '<div class="ays-chatgpt-dicount-wrap-text-row">';
                            $content[] = __( '10% extra coupon', 'ays-chatgpt-assistant' );
                        $content[] = '</div>';
                    $content[] = '</div>';
                    $content[] = '<div class="ays-chatgpt-dicount-wrap-box ays-chatgpt-dicount-wrap-button-box">';
                        $content[] = '<a href="https://ays-pro.com/wordpress/chatgpt-assistant?utm_source=dashboard&utm_medium=gpt-free&utm_campaign=sale-banner'.CHATGPT_ASSISTANT_VERSION.'" class="button button-primary ays-button" id="ays-button-top-buy-now" target="_blank" style="" >' . __( 'Buy Now', 'ays-chatgpt-assistant' ) . '</a>';
                        $content[] = '<span class="ays-chatgpt-dicount-one-time-text">';
                            $content[] = __( "One-time payment", 'ays-chatgpt-assistant' );
                        $content[] = '</span>';
                    $content[] = '</div>';
                $content[] = '</div>';
            $content[] = '</div>';

            $content = implode( '', $content );
            echo wp_kses_post($content);
        }
    }
    public function add_action_links($links){
        /*
        *  Documentation : https://codex.wordpress.org/Plugin_API/Filter_Reference/plugin_action_links_(plugin_file_name)
        */
        $settings_link = array(
            '<a href="' . admin_url('admin.php?page=' . $this->plugin_name) . '">' . __('Settings', "ays-chatgpt-assistant") . '</a>',
            '<a href="https://plugins.ays-demo.com/wordpress-chatgpt-plugin-demo/" target="_blank">' . __('Demo', "ays-chatgpt-assistant") . '</a>',
            '<a href="https://ays-pro.com/wordpress/chatgpt-assistant?utm_source=dashboard&utm_medium=gpt-free&utm_campaign=plugins-buy-now-button" target="_blank" id="ays-chatgpt-plugins-buy-now-button">' . __('Upgrade 30% sale', "ays-chatgpt-assistant") . '</a>',
        );
        return array_merge($settings_link, $links);

    }

    public function deactivate_plugin_option(){
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $request_value = isset($_REQUEST['upgrade_plugin']) ? sanitize_text_field(wp_unslash($_REQUEST['upgrade_plugin'])) : '';
        $upgrade_option = get_option( 'ays_chatgpt_assistant_upgrade_plugin', '' );
        if($upgrade_option === ''){
            add_option( 'ays_chatgpt_assistant_upgrade_plugin', $request_value );
        }else{
            update_option( 'ays_chatgpt_assistant_upgrade_plugin', $request_value );
        }
        return json_encode( array( 'option' => get_option( 'ays_chatgpt_assistant_upgrade_plugin', '' ) ) );
    }

    public function ays_chatgpt_admin_footer($a){
        if(isset($_REQUEST['page'])){// phpcs:ignore WordPress.Security.NonceVerification.Recommended
            if(false !== strpos( sanitize_text_field(wp_unslash( $_REQUEST['page'] )), $this->plugin_name)){// phpcs:ignore WordPress.Security.NonceVerification.Recommended
                ?>
                <div class="ays-chatgpt-assistant-footer-support-box">
                    <span class="ays-chatgpt-assistant-footer-link-row"><a href="https://wordpress.org/support/plugin/ays-chatgpt-assistant/" target="_blank"><?php echo esc_html(__( "Support", "ays-chatgpt-assistant")); ?></a></span>
                    <span class="ays-chatgpt-assistant-footer-slash-row">/</span>
                    <span class="ays-chatgpt-assistant-footer-link-row"><a href="https://ays-pro.com/wordpress-chatgpt-assistant-user-manual" target="_blank"><?php echo esc_html(__( "Docs", "ays-chatgpt-assistant")); ?></a></span>
                    <span class="ays-chatgpt-assistant-footer-slash-row">/</span>
                    <span class="ays-chatgpt-assistant-footer-link-row"><a href="https://ays-demo.com/chatgpt-ai-assistant-plugin-feedback-survey/" target="_blank"><?php echo esc_html(__( "Suggest a Feature", "ays-chatgpt-assistant")); ?></a></span>
                </div>
                <p style="font-size:13px;text-align:center;font-style:italic;">
                    <span style="margin-left:0px;margin-right:10px;" class="ays_heart_beat"><i class="ays_fa ays_fa_heart_o animated"></i></span>
                    <span><?php echo esc_html(__( "If you love our plugin, please do big favor and rate us on", "ays-chatgpt-assistant")); ?></span>
                    <a target="_blank" href='https://wordpress.org/support/plugin/ays-chatgpt-assistant/reviews/'>WordPress.org</a>
                    <span class="ays_heart_beat"><i class="ays_fa ays_fa_heart_o animated"></i></span>
                </p>
            <?php
            }
        }
    }

    public function ays_chatgpt_admin_ajax(){
		global $wpdb;

		$response = array(
			"status" => false
		);
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$function = isset($_REQUEST['function']) ? sanitize_text_field( wp_unslash($_REQUEST['function'] )) : null;

		if($function !== null){
			$response = array();
			if( is_callable( array( $this, $function ) ) ){
				$response = $this->$function();

	            ob_end_clean();
	            $ob_get_clean = ob_get_clean();
				echo json_encode( $response );
				wp_die();
			}
        }
        ob_end_clean();
        $ob_get_clean = ob_get_clean();
		echo json_encode( $response );
		wp_die();
	}

    public function ays_chatgpt_connect(){

        if ( ! isset( $_REQUEST['nonce'] ) || ! wp_verify_nonce(sanitize_text_field ( wp_unslash( $_REQUEST['nonce'] ) ), 'ajax-nonce' ) || ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( [ 'message' => 'Request failed', 'error' => [] ] );
        }

        $settings_obj = new ChatGPT_Assistant_Settings_DB_Actions( $this->plugin_name , $this->settings_db_name );
        $api_key      = isset($_REQUEST[CHATGPT_ASSISTANT_NAME_PREFIX.'_api_key']) && $_REQUEST[CHATGPT_ASSISTANT_NAME_PREFIX.'_api_key'] != '' ? esc_attr(sanitize_text_field(wp_unslash($_REQUEST[CHATGPT_ASSISTANT_NAME_PREFIX.'_api_key']))) : '';
		$method       = isset($_REQUEST['rMethod']) && $_REQUEST['rMethod'] != '' ? esc_attr(sanitize_text_field(wp_unslash($_REQUEST['rMethod']))) : '';
		$request_type = isset($_REQUEST['request_type']) && $_REQUEST['request_type'] != '' ? esc_attr(sanitize_text_field(wp_unslash($_REQUEST['request_type']))) : '';
		$check_openai_connection_code = false;
		$check_openai_connection = ChatGPT_assistant_Data::makeRequest($api_key, 'GET', 'models');
        $response_data = array('status' => false);
        
        if(is_array($check_openai_connection)){
            $check_openai_connection_code = isset($check_openai_connection['openai_response_code']) && $check_openai_connection['openai_response_code'] == 200 ? true : false; 
		}

		if($check_openai_connection_code){
			$this->db_obj->store_data();
            $response_data['status'] = true;
            $options = ($settings_obj->get_setting('options') === false) ? array() : json_decode($settings_obj->get_setting('options'), true);
			$chatbox_mode = ( isset( $options['chatbox_mode'] ) && $options['chatbox_mode'] != '' ) ? $options['chatbox_mode'] : 'light';
			$chatgpt_assistant_show_dashboard_chat = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'show_dashboard_chat'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'show_dashboard_chat'] == 'off' ) ? false : true;
            $chatgpt_assistant_show_dashboard_chat_mobile = ( isset( $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'show_dashboard_chat_mobile'] ) && $options[CHATGPT_ASSISTANT_OPTIONS_PREFIX.'show_dashboard_chat_mobile'] == 'off' ) ? false : true;
			if ($chatgpt_assistant_show_dashboard_chat) {
				$response_data['chatbot_html'] = ChatGPT_assistant_Data::get_chatbot_main_box($chatbox_mode, $api_key, $options);
			} else {
				$response_data['chatbot_html'] = '';
			}
		}
        $response_data['openai_connection'] = $check_openai_connection;


		return $response_data;
	}

    public function ays_chatgpt_pinecone_check_connection(){
		$pinecone_key = isset($_REQUEST['pinecone_key']) && $_REQUEST['pinecone_key'] != '' ? esc_attr($_REQUEST['pinecone_key']) : '';
		$pinecone_url = isset($_REQUEST['pinecone_url']) && $_REQUEST['pinecone_url'] != '' ? esc_attr($_REQUEST['pinecone_url']) : '';
		$headers = array(
			"Content-Type"  => "application/json",
			"Api-Key" => $pinecone_key
		);

		$request_data = array(
			"headers" => $headers,
		);
		
		$response = wp_remote_post($pinecone_url , $request_data);
      
		if (is_wp_error($response) || wp_remote_retrieve_response_code($response) != 200) {
			return json_encode(["status" => false]);
		}

		$response_body = wp_remote_retrieve_body($response);
        $data = json_decode($response_body, true);

        if (isset($data['totalVectorCount'])) {
            
            $record_count = $data['totalVectorCount'];
            if ($data['totalVectorCount'] > 0) {
               
                return json_encode([
                    "status" => true,
                    "message" => __("Database has records. Embedding not allowed.",'ays-chatgpt-assistant'),
                    "allow_embedding" => false,
                ]);
            }
            return json_encode([
                "status" => true,
                "message" => "",
                "allow_embedding" => true,
                "record_count" => $record_count,
            ]);
            
        }
        return json_encode(["status" => false]);
	}
    public function ays_chatgpt_pinecone_delete(){
        global $wpdb;
        $embedding_settings = $wpdb->prefix . CHATGPT_ASSISTANT_DB_PREFIX . 'embedding_all_settings';
        
        $pinecone_key = isset($_REQUEST['pinecone_key']) ? esc_attr($_REQUEST['pinecone_key']) : '';
        $pinecone_url = isset($_REQUEST['pinecone_url']) ? esc_attr($_REQUEST['pinecone_url']) : '';
        $post_id = isset($_REQUEST['pinecone_id']) ? strval($_REQUEST['pinecone_id']) : ''; 
        $request_data = array(
			"Api-Key" => $pinecone_key,
            "Content-Type" => "application/json"
		);
       
        $delete_data = json_encode(array(
            "ids" => [$post_id] 
        ));
    
        $response = wp_remote_post($pinecone_url, array(
            'headers' => $request_data,
            'body'    => $delete_data
        ));
		if (is_wp_error($response)) {
			return $response->get_error_message();
		}
        if (wp_remote_retrieve_response_code($response) == 200) {
            return true; 
        } else {
            return false;  
        }
    }
   
	public function ays_chatgpt_pinecone_query(){
		$pinecone_key = isset($_REQUEST['pinecone_key']) && $_REQUEST['pinecone_key'] != '' ? esc_attr($_REQUEST['pinecone_key']) : '';
		$pinecone_url = isset($_REQUEST['pinecone_url']) && $_REQUEST['pinecone_url'] != '' ? esc_attr($_REQUEST['pinecone_url']) : '';
		$query_data = isset($_REQUEST['query_data']) && $_REQUEST['query_data'] != '' ? str_replace("\\", '', stripslashes($_REQUEST['query_data'])) : '';
		
		$headers = array(
			"Content-Type"  => "application/json",
			"Api-Key" => $pinecone_key
		);

		$request_data = array(
			"headers" => $headers,
			"body" => $query_data
		);

		$response = wp_remote_post($pinecone_url , $request_data);
		
		if (is_wp_error($response)) {
			return json_encode(array(
				'status' => false,
				'response' => $response->get_error_message()
			));
		}

		$data = json_decode(wp_remote_retrieve_body($response), true);
		if (isset($data['code']) && $data['code'] === 3) {
			return json_encode(array(
				'status' => false,
				'response' => $data['message']
			));
		}

		foreach ($data['matches'] as &$match) {
			$text = $match['metadata']['text'];

			$decoded_text = stripcslashes(json_decode('"' . $text . '"'));

			$match['metadata']['text'] = $decoded_text;
		}
		
		return json_encode(array(
			'status' => true,
			'response' => $data
		));
	}
    
    public function ays_chatgpt_save_embedding_text_to_db() {
        
        if (isset($_POST['text']) && isset($_POST['length'])) {
   
            $text = sanitize_text_field($_POST['text']);
            $word_count = intval($_POST['length']);      
            $encoded_text = base64_encode($text);
            $postId = sanitize_text_field($_POST['id']);
            $meta_data = array(
                array('meta_key' => 'embedding_text', 'meta_value' => $encoded_text),
                array('meta_key' => 'embedding_text_length', 'meta_value' => $word_count),
                array('meta_key' => 'embedding_text_id', 'meta_value' => $postId) 
            );
            global $wpdb;
            $embedding_settings = $wpdb->prefix . CHATGPT_ASSISTANT_DB_PREFIX . 'embedding_settings';
    
            foreach ($meta_data as $data) {  
                $meta_key = $data['meta_key'];
                $meta_value = $data['meta_value'];
    
                $existing_record = $wpdb->get_var(
                    $wpdb->prepare("SELECT COUNT(*) FROM $embedding_settings WHERE meta_key = %s", $meta_key)
                );
                
                if ($existing_record > 0) {
                    $wpdb->update(
                        $embedding_settings,
                        ['meta_value' => $meta_value], 
                        ['meta_key' => $meta_key]
                    );
                } else {
                    $wpdb->insert(
                        $embedding_settings,
                        [
                            'meta_key' => $meta_key,
                            'meta_value' => $meta_value,
                        ]
                    );
                }
            }
            wp_send_json_success();  
        } else {
            wp_send_json_error('Invalid data');  
        }
    }
    public function ays_chatgpt_pinecone_upsert(){
		$pinecone_key = isset($_REQUEST['pinecone_key']) && $_REQUEST['pinecone_key'] != '' ? esc_attr($_REQUEST['pinecone_key']) : '';
		$pinecone_url = isset($_REQUEST['pinecone_url']) && $_REQUEST['pinecone_url'] != '' ? esc_attr($_REQUEST['pinecone_url']) : '';
		$upsert_data = isset($_REQUEST['upsert_data']) && $_REQUEST['upsert_data'] != '' ? str_replace("\\", '', stripslashes($_REQUEST['upsert_data'])) : '';
		
		$headers = array(
			"Content-Type"  => "application/json",
			"Api-Key" => $pinecone_key
		);

		$request_data = array(
			"headers" => $headers,
			"body" => $upsert_data
		);
		
		$response = wp_remote_post($pinecone_url , $request_data);
		
		if (is_wp_error($response)) {
			return $response->get_error_message();
		}

		$data = json_decode(wp_remote_retrieve_body($response), true);
		if (isset($data['code']) && $data['code'] === 3) {
			return $data['message'];
		}

		return true;
	}

	public function ays_chatgpt_disconnect(){
        if (! isset( $_REQUEST['nonce'] ) || !wp_verify_nonce(sanitize_text_field ( wp_unslash( $_REQUEST['nonce'] ) ), 'ajax-nonce') || !current_user_can('manage_options')) {
            wp_send_json_error(['message' => 'Request failed', 'error' => []]);
        }

        $id = isset($_REQUEST[CHATGPT_ASSISTANT_NAME_PREFIX.'_id']) && $_REQUEST[CHATGPT_ASSISTANT_NAME_PREFIX.'_id'] != '' ? esc_attr(sanitize_text_field(wp_unslash($_REQUEST[CHATGPT_ASSISTANT_NAME_PREFIX.'_id']))) : '';

		$status = $this->db_obj->update_setting($id , "" , 'api_key' , 'id');		

		return $status;
	}

    public function ays_chatgpt_save_feedback(){
		global $wpdb;
		$rates_table = $wpdb->prefix . CHATGPT_ASSISTANT_DB_PREFIX . 'rates';

		$data = isset($_REQUEST['feedback_data']) && $_REQUEST['feedback_data'] != '' ? array_map('sanitize_text_field', json_decode(wp_unslash($_REQUEST['feedback_data']), true)) : array();// phpcs:ignore WordPress.Security.NonceVerification.Recommended

		global $current_user;
		$user_name = isset($data['user_name']) && $data['user_name'] != '' ? sanitize_text_field($data['user_name']) : (isset($current_user->user_login) && $current_user->user_login != '' ? sanitize_text_field($current_user->user_login) : '');
		$user_email = isset($data['user_email']) && $data['user_email'] != '' ? sanitize_text_field($data['user_email']) : (isset($current_user->user_email) && $current_user->user_email != '' ? sanitize_text_field($current_user->user_email) : '');
		
		$user_id = get_current_user_id();
		$date = current_time('mysql');

		$post_id = isset($data['post_id']) && $data['post_id'] != '' ? intval($data['post_id']) : 0;
		
		$source = isset($data['source']) && $data['source'] != '' ? sanitize_text_field($data['source']) : '';
		$type = isset($data['type']) && $data['type'] != '' ? sanitize_text_field($data['type']) : '';
		$feedback_action = isset($data['feedback_action']) && $data['feedback_action'] != '' ? sanitize_text_field($data['feedback_action']) : '';
		$feedback = isset($data['feedback']) && $data['feedback'] != '' ? esc_attr(stripslashes(sanitize_text_field($data['feedback']))) : '';

		if (trim($feedback) == '') {
			return false;
		}

		$result = $wpdb->insert(
			$rates_table,
			array(
                'post_id' => $post_id,
                'user_id' => $user_id,
                'user_name' => $user_name,
                'user_email' => $user_email,
                'date' => $date,
                'chat_source' => $source,
                'chat_type' => $type,
                'feedback' => $feedback,
                'action' => $feedback_action,
			),
			array( '%d', '%d', '%s', '%s', '%s', '%s', '%s', '%s', '%s' )
		);

		if ($result && $result > 0) {
			return true;
		}

		return false;
	}

    public function get_chatgpt_api_key() {
		$data = $this->db_obj->get_data();
		if (!$data || empty($data['api_key'])) {
			wp_send_json_error(['message' => __('API key not found')]);
		}
		$api_key = isset( $data['api_key']) && $data['api_key'] != '' ? esc_attr( $data['api_key'] ) : '';

		wp_send_json_success(['api_key' => $api_key]);
	}
    public function ays_chatgpt_save_wp_media() {
		$image_url = isset($_REQUEST['image_url']) ? esc_url_raw(sanitize_text_field(wp_unslash($_REQUEST['image_url']))) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
	
		require_once(ABSPATH . 'wp-admin/includes/media.php');
		require_once(ABSPATH . 'wp-admin/includes/file.php');
		require_once(ABSPATH . 'wp-admin/includes/image.php');
	
		if (!filter_var($image_url, FILTER_VALIDATE_URL)) {
			wp_send_json(['status' => false, 'message' => __('Invalid image URL provided', 'ays-chatgpt-assistant')]);
			return;
		}
	
		$tmp = download_url($image_url);
	
		if (is_wp_error($tmp)) {
			wp_send_json(['status' => false, 'message' => __('Error downloading the image:', 'ays-chatgpt-assistant') . $tmp->get_error_message()]);
			return;
		}
	
		$file_name = sanitize_file_name(basename(wp_parse_url($image_url, PHP_URL_PATH)));
		$file_array = array(
			'name' => $file_name,
			'tmp_name' => $tmp
		);
	
		$media_id = media_handle_sideload($file_array, 0);
	
		if (is_wp_error($media_id)) {
			wp_send_json(['status' => false, 'message' => __('Error saving the image:', 'ays-chatgpt-assistant') . $media_id->get_error_message()]);
			return;
		}
	
		$image_url = wp_get_attachment_url($media_id);
		wp_send_json(['status' => true, 'message' => __('Image saved to WordPress media library. URL: ', 'ays-chatgpt-assistant') . $image_url]);
	}

    public function ays_chatgpt_make_request() {

        if ( !isset( $_REQUEST['nonce'] ) || !wp_verify_nonce(sanitize_text_field ( wp_unslash( $_REQUEST['nonce'] ) ), 'ajax-nonce' ) ) {
            wp_send_json_error( [ 'message' => 'Request failed', 'error' => ['message' => 'Request failed']]);
        }
        
        if ( !isset($_REQUEST['dataObj']) || !isset($_REQUEST['dbOptions']) ) {
            wp_send_json_error(['message' => 'Missing required parameters', 'error' => ['message' => 'Missing required parameters']]);
        }
    
        $data = $this->db_obj->get_data();
		$apiKey = isset( $data['api_key'] ) && $data['api_key'] != '' ? esc_attr( $data['api_key'] ) : '';

        if ( !isset($apiKey) || $apiKey === "" ) {
            wp_send_json_error(['message' => 'Invalid API Key.', 'error' => ['message' => 'Invalid API Key.']]);
        }
    

        if(function_exists('mb_convert_encoding')){
            $dataObj = json_decode(mb_convert_encoding(base64_decode($_REQUEST['dataObj']), 'UTF-8'), true);
            $dbOptions = json_decode(mb_convert_encoding(base64_decode($_REQUEST['dbOptions']), 'UTF-8'), true);
        } else {
            $dataObj = json_decode(iconv('ISO-8859-1', 'UTF-8', base64_decode($_REQUEST['dataObj'])), true);
            $dbOptions = json_decode(iconv('ISO-8859-1', 'UTF-8', base64_decode($_REQUEST['dbOptions'])), true);
        }
            
        $chatRequestBody = array(
            'temperature' => +$dbOptions['chatTemperature'] ?? 0.7,
            'top_p' => +$dbOptions['chatTopP'] ?? 1,
            'max_tokens' => +$dbOptions['chatMaxTokents'] ?? 1500,
            'frequency_penalty' => +$dbOptions['chatFrequencyPenalty'] ?? 0.01,
            'presence_penalty' => +$dbOptions['chatPresencePenalty'] ?? 0.01,
            'model' => $dbOptions['chatModel'] ?? ""
        );
    
        switch ($dbOptions['chatModel']) {
            case 'gpt-3.5-turbo':
            case 'gpt-3.5-turbo-16k':
            case 'gpt-4':
                $dataObj['chatConversation'][] = array('role' => 'user', 'content' => $dataObj['prompt']);
                $chatRequestBody['messages'] = $dataObj['chatConversation'];
                break;
            default:
                $dataObj['chatConversation'][] = "Human: " . $dataObj['prompt'] . '.';
                $chatRequestBody['best_of'] = +$dbOptions['chatBestOf'] ?? 1;
                $chatRequestBody['prompt'] = implode("", $dataObj['chatConversation']);
                break;
        }
    
        $response = wp_remote_post($dataObj['requestUrl'], array(
            'method'    => 'POST',
            'headers'   => array(
                'Content-Type'  => 'application/json',
                'Authorization' => 'Bearer ' . $apiKey,
            ),
            'body'      => json_encode($chatRequestBody),
            'timeout'   => 20,
        ));
    
        if ( is_wp_error( $response ) ) {
            wp_send_json_error(['message' => 'Request failed', 'error' => $response->get_error_message()]);
            wp_die();
        }
    
        $response_body = wp_remote_retrieve_body( $response );
        wp_send_json_success(json_decode($response_body));
        
        wp_die();
    }
}
