<?php
/**
 * Token Distribution Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Gauch_TokenDistribution extends Widget_Base {

	public function get_name() {
        return 'Gauch_Token_Distribution';
    }

	public function get_title() {
        return esc_html__( 'Token Distribution', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-image-rollover';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Features_Info',
			[
				'label' => esc_html__( 'Gauch Features Info', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'sec_style',
                [
                    'label' => __( 'Style', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style 1', 'gauch-toolkit' ),
                        '2'   => __( 'Style 2', 'gauch-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
			$repeater = new Repeater();
            $repeater->add_control(
                'token_num', [
					'type'    => Controls_Manager::NUMBER,
					'label'   => esc_html__( 'Percentage Number', 'gauch-toolkit' ),
                    'default' => 45
                ]
            );
            $repeater->add_control(
                'token_per', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Percentage', 'gauch-toolkit' ),
                    'default' => '%'
                ]
            );
            $repeater->add_control(
                'token_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Title', 'gauch-toolkit' ),
                    'default' => 'Initial Coin Offering',
                ]
            );
            $this->add_control(
                'items',
                [
                    'label'   => esc_html__( 'Add Items', 'gauch-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                ]
            );


            $this->add_control(
                'coin_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Coin Details Title', 'gauch-toolkit' ),
                    'default' => 'Coin Details',
                ]
            );
            $repeater2 = new Repeater();
            $repeater2->add_control(
                'coin_label', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Label', 'gauch-toolkit' ),
                    'default' => __('Asset Name', 'gauch-toolkit' ),
                ]
            );
            $repeater2->add_control(
                'coin_value', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Value', 'gauch-toolkit' ),
                    'default' => __('Coin', 'gauch-toolkit' ),
                ]
            );
            $this->add_control(
                'items2',
                [
                    'label'   => esc_html__( 'Add Items', 'gauch-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater2->get_controls(),
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        $arr = [];
        $arr2 = [];
        foreach( $settings['items'] as $item ):
            $arr[]= $item['token_num'];
            $str = strval($item['token_num']);
            //$arr2[] = $str.'%';
            $arr2[] = "'".$str. "%'";
        endforeach;

        $seriesArr = implode(',', $arr);
        $labelArr = implode(',', $arr2);
        ?>

        <?php if($settings['sec_style'] == '1'): ?>
            <div class="container">
                <div class="row justify-content-center align-items-center">
                    <div class="col-lg-4 col-md-12">
                        <div class="token-distribution-card">
                            <ul class="distribution-list">

                                <?php $loop = 1; foreach( $settings['items'] as $item ): 
                                    if($loop == 1 || $loop % 6 == 0 ){
                                        $color = 'bg-0EA6EC';
                                    }elseif($loop == 2 || $loop % 7 == 0 ){
                                        $color = 'bg-0AA350';
                                    }elseif($loop == 3 || $loop % 8 == 0 ){
                                        $color = 'bg-EACF2A';
                                    }elseif($loop == 4 || $loop % 9 == 0 ){
                                        $color = 'bg-F48A1D';
                                    }elseif($loop == 5 || $loop % 10 == 0 ){
                                        $color = 'bg-F07258';
                                    }
                                ?>
                                    <li>
                                        <span class="<?php echo $color; ?>"> <?php echo esc_html($item['token_num']); ?><?php echo esc_html($item['token_per']); ?></span> <?php echo esc_html($item['token_title']); ?>
                                    </li>
                                <?php $loop++; endforeach; ?>

                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-12">
                        <div class="token-distribution-card">
                            <div id="token-distribution-chart" class="extra-margin"></div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-12">
                        <div class="token-distribution-card">
                            <div class="token-distribution-details">

                                <?php if( $settings['coin_title'] != '' ) : ?>
                                <div class="header">
                                    <h3><?php echo esc_html($settings['coin_title']); ?></h3>
                                </div>
                                <?php endif; ?>

                                <ul class="info-list">
                                    <?php foreach( $settings['items2'] as $item ): ?>
                                        <li class="d-flex justify-content-between align-items-center">
                                            <span><?php echo esc_html($item['coin_label']); ?></span>
                                            <span><?php echo esc_html($item['coin_value']); ?></span>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="container">
                <div class="row justify-content-center align-items-center">
                    <div class="col-lg-4 col-md-12">
                        <div class="token-distribution-card">
                            <div id="token-distribution-chart" class="extra-margin"></div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6">
                        <div class="token-distribution-card">
                            <ul class="distribution-list without-wrap">

                                <?php $loop = 1; foreach( $settings['items'] as $item ): 
                                    if($loop == 1 || $loop % 6 == 0 ){
                                        $color = 'bg-0EA6EC';
                                    }elseif($loop == 2 || $loop % 7 == 0 ){
                                        $color = 'bg-0AA350';
                                    }elseif($loop == 3 || $loop % 8 == 0 ){
                                        $color = 'bg-EACF2A';
                                    }elseif($loop == 4 || $loop % 9 == 0 ){
                                        $color = 'bg-F48A1D';
                                    }elseif($loop == 5 || $loop % 10 == 0 ){
                                        $color = 'bg-F07258';
                                    }
                                ?>
                                    <li>
                                        <span class="<?php echo $color; ?>"> <?php echo esc_html($item['token_num']); ?><?php echo esc_html($item['token_per']); ?></span> <?php echo esc_html($item['token_title']); ?>
                                    </li>
                                <?php $loop++; endforeach; ?>

                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6">
                        <div class="token-distribution-card">
                            <div class="token-distribution-details with-black-color">
                                <?php if( $settings['coin_title'] != '' ) : ?>
                                <div class="header">
                                    <h3><?php echo esc_html($settings['coin_title']); ?></h3>
                                </div>
                                <?php endif; ?>

                                <ul class="info-list">
                                    <?php foreach( $settings['items2'] as $item ): ?>
                                        <li class="d-flex justify-content-between align-items-center">
                                            <span><?php echo esc_html($item['coin_label']); ?></span>
                                            <span><?php echo esc_html($item['coin_value']); ?></span>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <script>
            (function($){
            "use strict";
                $( window ).on( 'elementor/frontend/init', function() {
                    elementorFrontend.hooks.addAction( 'frontend/element_ready/Gauch_Token_Distribution.default', function($scope, $){

                        // token-distribution-chart
                        var options = {
                            //series: [20, 10, 25, 10, 5, 45, 20],
                            series: [<?php echo $seriesArr; ?>],
                            chart: {
                                width: 380,
                                type: 'donut',
                            },
                            dataLabels: {
                                enabled: false
                            },
                            stroke: {
                                width: 0
                            },
                            //labels: ['25%', '10%', '25%', '10%', '5%', '45%', '20%'],
                            labels: [<?php echo $labelArr; ?>],
                            responsive: [{
                            breakpoint: 580,
                            options: {
                                chart: {
                                    width: 300
                                },
                                legend: {
                                    show: false
                                }
                            }
                            }],
                            legend: {
                                show: false
                            }
                        };
                        var chart = new ApexCharts(document.querySelector("#token-distribution-chart"), options);
                        chart.render();
                        
                    });

                });  

                if( typeof elementorFrontend !== 'undefined'  ){
                    elementorFrontend.hooks.addAction( 'frontend/element_ready/Gauch_Token_Distribution.default', function($scope, $){

                            // token-distribution-chart
                            var options = {
                            series: [<?php echo $seriesArr; ?>],
                            chart: {
                                width: 380,
                                type: 'donut',
                            },
                            dataLabels: {
                                enabled: false
                            },
                            stroke: {
                                width: 0
                            },
                            labels: [<?php echo $labelArr; ?>],
                            responsive: [{
                            breakpoint: 580,
                            options: {
                                chart: {
                                    width: 300
                                },
                                legend: {
                                    show: false
                                }
                            }
                            }],
                            legend: {
                                show: false
                            }
                        };
                        var chart = new ApexCharts(document.querySelector("#token-distribution-chart"), options);
                        chart.render();

                    });
                }
            
            }(jQuery));

        </script>
        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_TokenDistribution );