<?php
/**
 * Section Widget
 */

namespace Elementor;
class Gauch_Section extends Widget_Base {

	public function get_name() {
        return 'Section';
    }

	public function get_title() {
        return __( 'Section', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-handle';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Section',
			[
				'label' => __( 'Gauch Section', 'gauch-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'top_title',
                [
                    'label'   => __( 'Top Title', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __('KEY FEATURES', 'gauch-toolkit'),
                ]
            );
            $this->add_control(
                'title',
                [
                    'label'   => __( 'Title', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::TEXTAREA,
                    'default' => __('Our Featured Services', 'gauch-toolkit'),
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label'   => esc_html__( 'Title Tag', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'gauch-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'gauch-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'gauch-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'gauch-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'gauch-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'gauch-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => __( 'Content', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::WYSIWYG,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'gauch-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'top_title_bgcolor',
                [
                    'label'     => esc_html__( 'Top Title Background', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title .sub-title' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label'     => esc_html__( 'Top Title Color', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-title .sub-title',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title h2, .section-title h3, .section-title h4, .section-title h5, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-title h2, .section-title h3, .section-title h4, .section-title h5, .section-title h5, .section-title h6',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title p' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-title p',
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $this-> add_inline_editing_attributes('content','none');
        ?>
            <div class="container">
                <div class="section-title with-max-width">
                    <?php if( $settings['top_title'] != '' ): ?>
                        <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                    <?php endif; ?>

                    <<?php echo esc_attr( $settings['title_tag'] ); ?>>
                        <?php echo esc_html( $settings['title'] ); ?>
                    </<?php echo esc_attr( $settings['title_tag'] ); ?>>

                    <?php if( $settings['content'] != '' ): ?>
                        <?php echo wp_kses_post( $settings['content'] ); ?>
                    <?php endif; ?>
                </div>
            </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Section );