<?php
/**
 * Pricing Table Widget
 */

namespace Elementor;
class Gauch_Pricing_Table extends Widget_Base {

	public function get_name() {
        return 'Gauch_Pricing_Table';
    }

	public function get_title() {
        return __( 'Pricing Table', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-price-table';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Pricing_Table_Area',
			[
				'label' => __( 'Pricing Controls', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'style',
                [
                    'label' => __( 'Style', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style 1', 'gauch-toolkit' ),
                        '2'   => __( 'Style 2', 'gauch-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'shape', [
                    'type'    => Controls_Manager::MEDIA,
                    'label'   => esc_html__( 'Shape Image', 'gauch-toolkit' ),
                    'condition' => [
                        'style' => '2',
                    ]
                ]
            );

            $pricing_items = new Repeater();
            $pricing_items->add_control(
                'featured',
                [
                    'label' => __( 'Featured?', 'gauch-toolkit' ),
                    'type' =>Controls_Manager::SWITCHER,
                    'label_on' => __( 'Yes', 'gauch-toolkit' ),
                    'label_off' => __( 'No', 'gauch-toolkit' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $pricing_items->add_control(
                'featured_title',
                [
                    'label' => __( 'Featured Title', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('POPULAR', 'gauch-toolkit'),
                ]
            );

            $pricing_items->add_control(
                'title',
                [
                    'label' => __( 'Title', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Free', 'gauch-toolkit'),
                ]
            );

            $pricing_items->add_control(
                'short_desc',
                [
                    'label' => __( 'Short Description', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Give Gauch a try for free', 'gauch-toolkit'),
                ]
            );

            $pricing_items->add_control(
                'price_prefix',
                [
                    'label' => __( 'Price Prefix', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('$', 'gauch-toolkit'),
                ]
            );

            $pricing_items->add_control(
                'price',
                [
                    'label' => __( 'Price', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('0', 'gauch-toolkit'),
                ]
            );

            $pricing_items->add_control(
                'price_suffix',
                [
                    'label' => __( 'Number Suffix', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('/month', 'gauch-toolkit'),
                ]
            );

            $pricing_items->add_control(
                'price_desc',
                [
                    'label' => __( 'Price Short Description', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Pricing includes coverage for users', 'gauch-toolkit'),
                ]
            );

            $pricing_items->add_control(
                'button',
                [
                    'label' => __( 'Button Text', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Get Started', 'gauch-toolkit'),
                ]
            );

            $pricing_items->add_control(
                'button_link',
                [
                    'label' => __( 'Button Link', 'gauch-toolkit' ),
                    'type' => Controls_Manager::URL,
                ]
            );

            $pricing_items->add_control(
                'features_title',
                [
                    'label' => __( 'Features Title', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('ALL FEATURES:', 'gauch-toolkit'),
                ]
            );

            $pricing_items->add_control(
                'features',
                [
                    'label' => __( 'Features', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => '<li><i class="ri-check-line"></i> Up to 10 Website</li>',
                ]
            );
            $this->add_control(
                'list_items',
                [
                    'label' => __( 'Card Items', 'gauch-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $pricing_items->get_controls(),
                    'title_field' => '{{{ title }}}',
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
				'card_title_color',
				[
					'label' => __( 'Pricing Title Color', 'gauch-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-pricing-box .pricing-header h3, .single-pricing-card .pricing-header h3' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'pricing_title_typography',
                    'label' => __( 'Pricing Typography', 'gauch-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .single-pricing-box .pricing-header h3, .single-pricing-card .pricing-header h3',
                ]
            );

            $this->add_control(
				'short_desc_color',
				[
					'label' => __( 'Short Description Color', 'gauch-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-pricing-box .pricing-header p, .single-pricing-box .price p' => 'color: {{VALUE}}',
					],
                    'condition' => [
                        'style' => '1',
                    ]
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'short_desc_typography',
                    'label' => __( 'Short Description Typography', 'gauch-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .single-pricing-box .pricing-header p, .single-pricing-box .price p',
                    'condition' => [
                        'style' => '1',
                    ]
                ]
            );

            $this->add_control(
				'price_color',
				[
					'label' => __( 'Price Color', 'gauch-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-pricing-box .price h4, .single-pricing-card .price h4' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'price_typography',
                    'label' => __( 'Price Typography', 'gauch-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .single-pricing-box .price h4, .single-pricing-card .price h4',
                ]
            );

            $this->add_control(
				'suf_color',
				[
					'label' => __( 'Price Suffix Color', 'gauch-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-pricing-box .price h4 span, .single-pricing-card .price h4 span' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'price_suf_typography',
                    'label' => __( 'Price Suffix Typography', 'gauch-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .single-pricing-box .price h4 span, .single-pricing-card .price h4 span',
                ]
            );

            $this->add_control(
				'list_color',
				[
					'label' => __( 'List Color', 'gauch-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-pricing-box .features-list ul li, .single-pricing-card .features-list ul li' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'list_typography',
                    'label' => __( 'List Typography', 'gauch-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .single-pricing-box .features-list ul li, .single-pricing-card .features-list ul li',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings_for_display();
        ?>

        <?php if($settings['style'] == '1') : ?>
            <div class="container">
                <div class="row justify-content-center">
                    <?php foreach( $settings['list_items'] as $item ): ?>
                        <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6">
                            <div class="single-pricing-box">
                                <div class="pricing-header">
                                    <h3><?php echo wp_kses_post( $item['title'] ); ?></h3>
                                    <p><?php echo $item['short_desc']; ?></p>
                                </div>
                                <div class="price">
                                    <h4><?php echo esc_html( $item['price_prefix'] ); ?><?php echo esc_html( $item['price'] ); ?><span><?php echo esc_html( $item['price_suffix'] ); ?></span></h4>
                                    <p><?php echo $item['price_desc']; ?></p>
                                </div>

                                <?php if( $item['button'] != '' ): ?>
                                    <a href="<?php echo esc_url( $item['button_link']['url'] ); ?>" class="link-btn"><?php echo esc_html( $item['button'] ); ?></a>
                                <?php endif; ?>

                                <div class="features-list">
                                    <h5><?php echo esc_html( $item['features_title'] ); ?></h5>
                                    <ul>
                                        <?php echo wp_kses_post( $item['features'] ); ?>
                                    </ul>
                                </div>

                                <?php if($item['featured'] == 'yes'): ?>
                                    <div class="ribbon"><span><?php echo esc_html( $item['featured_title'] ); ?></span></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php else: ?>
            <div class="container">
                <div class="row justify-content-center">
                    <?php foreach( $settings['list_items'] as $item ): ?>
                        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
                            <div class="single-pricing-card">
                                <div class="pricing-header">
                                    <h3><?php echo wp_kses_post( $item['title'] ); ?></h3>
                                </div>
                                <div class="price">
                                    <h4><?php echo esc_html( $item['price_prefix'] ); ?><?php echo esc_html( $item['price'] ); ?><span><?php echo esc_html( $item['price_suffix'] ); ?></span></h4>
                                </div>
                                <div class="features-list">
                                    <ul>
                                        <?php echo wp_kses_post( $item['features'] ); ?>
                                    </ul>
                                </div>
                                <?php if( $item['button'] != '' ): ?>
                                    <a href="<?php echo esc_url( $item['button_link']['url'] ); ?>" class="link-btn"><?php echo esc_html( $item['button'] ); ?></a>
                                <?php endif; ?>

                                <?php if( $settings['shape']['url']  != '' ) : ?>
                                <div class="pricing-shape">
                                    <img src="<?php echo esc_url( $settings['shape']['url'] ); ?>" alt="<?php echo esc_attr__('image','gauch-toolkit'); ?>">
                                </div>
                                <?php endif; ?>

                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Pricing_Table );