<?php
/**
 * Partner Logo Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Gauch_Partner_Logo extends Widget_Base {

	public function get_name() {
        return 'Partner_Logo';
    }

	public function get_title() {
        return __( 'Partner Logo', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-logo';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_partner_Section',
			[
				'label' => __( 'Section', 'gauch-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'show_sec',
                [
                    'label'        => __( 'Section Hide/Show?', 'gauch-toolkit' ),
                    'type'         => Controls_Manager::SWITCHER,
                    'label_on'     => __( 'Show', 'gauch-toolkit' ),
                    'label_off'    => __( 'Hide', 'gauch-toolkit' ),
                    'return_value' => 'yes',
                    'default'      => 'yes',
                ]
            );

            $this->add_control(
                'top_title',
                [
                    'label'   => __( 'Top Title', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __('KEY FEATURES', 'gauch-toolkit'),
                    'condition' => [
                        'show_sec' => 'yes',
                    ]
                ]
            );
            $this->add_control(
                'title',
                [
                    'label'   => __( 'Title', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::TEXTAREA,
                    'default' => __('Our Featured Services', 'gauch-toolkit'),
                    'condition' => [
                        'show_sec' => 'yes',
                    ]
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label'   => esc_html__( 'Title Tag', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'gauch-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'gauch-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'gauch-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'gauch-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'gauch-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'gauch-toolkit' ),
                    ],
                    'default' => 'h2',
                    'condition' => [
                        'show_sec' => 'yes',
                    ]
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => __( 'Content', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::WYSIWYG,
                    'condition' => [
                        'show_sec' => 'yes',
                    ]
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'partner_section',
			[
				'label' => __( 'Partner Logo Control', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
			$repeater = new Repeater();
            $repeater->add_control(
                'logo', [
					'type'    => Controls_Manager::MEDIA,
					'label'   => esc_html__( 'Logo', 'gauch-toolkit' ),
                ]
            );
            $repeater->add_control(
                'logo_link', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Logo Link', 'gauch-toolkit' ),
                    'default' => '#'
                ]
            );
            $this->add_control(
                'logos',
                [
                    'label'   => esc_html__( 'Add Partner Logo', 'gauch-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'gauch-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_sec' => 'yes',
                ]
			]
        );

            $this->add_control(
                'top_title_bgcolor',
                [
                    'label'     => esc_html__( 'Top Title Background', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title .sub-title' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label'     => esc_html__( 'Top Title Color', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-title .sub-title',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title h2, .section-title h3, .section-title h4, .section-title h5, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-title h2, .section-title h3, .section-title h4, .section-title h5, .section-title h5, .section-title h6',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title p' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-title p',
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="partner-area pt-100">
            <div class="container">
                <?php if ( $settings['show_sec'] == 'yes' ) : ?>
                    <div class="section-title style-two">
                        <div class="row align-items-center">
                            <div class="col-lg-5 col-md-12">
                                <?php if( $settings['top_title'] != '' ): ?>
                                    <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                <?php endif; ?>

                                <<?php echo esc_attr( $settings['title_tag'] ); ?>>
                                    <?php echo wp_kses_post( $settings['title'] ); ?>
                                </<?php echo esc_attr( $settings['title_tag'] ); ?>>
                            </div>

                            <?php if( $settings['content'] != '' ): ?>
                                <div class="col-lg-7 col-md-12">
                                    <?php echo wp_kses_post( $settings['content'] ); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="partner-slides owl-carousel owl-theme">

                    <?php foreach( $settings['logos'] as $item ): ?>
                        <div class="partner-item">
                            <a href="<?php echo esc_url( $item['logo_link'] ); ?>" class="d-block"><img src="<?php echo esc_url( $item['logo']['url'] ); ?>" alt="<?php echo esc_attr__( 'Partner Logo', 'gauch-toolkit' ); ?>"></a>
                        </div>
                    <?php endforeach; ?>

                </div>
            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Partner_Logo );