<?php
/**
 * Button Widget
 */

namespace Elementor;
class Gauch_Button extends Widget_Base {

	public function get_name() {
        return 'GauchButton';
    }

	public function get_title() {
        return __( 'Gauch Button', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-button';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Button',
			[
				'label' => __( 'Gauch Button', 'gauch-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'button_text',
                [
                    'label'   => __( 'Button Text', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::TEXT,
                    'default' => __('Get In Touch', 'gauch-toolkit'),
                ]
            );

            $this->add_control(
                'button_link',
                [
                    'label'   => __( 'Button Link', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::URL,
                ]
            );

            $this->add_control(
                'button_alignment',
                [
                    'label'   => __( 'Button Alignment', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        'text-start'                => __( 'Left', 'gauch-toolkit' ),
                        'text-center'              => __( 'Center', 'gauch-toolkit' ),
                        'text-end'               => __( 'Right', 'gauch-toolkit' ),
                    ],
                    'default' => 'text-start',
                ]
            );

            $this->add_control(
				'button_icon',
				[
					'label' => esc_html__( 'Button Icon', 'gauch-toolkit' ),
                    'type' => Controls_Manager::ICONS,
                    'label_block' => true,
				]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'Button_style',
			[
				'label' => __( 'Style', 'gauch-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
				'btn_text_color',
				[
					'label'     => __( 'Button Text Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'background-color: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'btn_hover_bg_color',
				[
					'label'     => __( 'Button Hover Background Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn span' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'btn_hover_text_color',
				[
					'label'     => __( 'Button Hover Text Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn:hover' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );

            $this->add_responsive_control(
                'border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'gauch-toolkit' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .default-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'text_padding',
                [
                    'label' => esc_html__( 'Padding', 'gauch-toolkit' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .default-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        if ( ! empty( $settings['button_link']['url'] ) ) {
			$this->add_link_attributes( 'button_link', $settings['button_link'] );
		}

        ?>
        <div class="container">
            <div class="gauch-button-title <?php echo esc_attr($settings['button_alignment']); ?>">
                <?php if( $settings['button_text']): ?>
                    <a <?php echo $this->get_render_attribute_string( 'button_link' ); ?>  class="default-btn style-two">
                        <?php echo esc_html( $settings['button_text'] ); ?>
                        <?php Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    </a>   
                <?php endif; ?>
            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Button );