<?php
/**
 * Funfacts Widget
 */

namespace Elementor;
class Gauch_Funfacts extends Widget_Base {

	public function get_name() {
        return 'Gauch_Funfacts';
    }

	public function get_title() {
        return __( 'Funfacts', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-counter';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'funfacts_section',
			[
				'label' => __( 'Funfacts Control', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $list_items = new Repeater();

            $list_items->add_control(
                'icon',
                [
                    'type'    => Controls_Manager::ICON,
                    'label' => __( 'Icon', 'gauch-toolkit' ),
                    'label_block' => true,
                    'options' => gauch_icons(),
                ]
            );
            $list_items->add_control(
				'icon_bg_color',
				[
					'label' => __( 'Icon Background Color', 'gauch-toolkit' ),
					'type' => Controls_Manager::COLOR,
				]
			);
            $list_items->add_control(
                'number',
                [
                    'type'    => Controls_Manager::NUMBER,
                    'label'   => __( 'Ending Number', 'gauch-toolkit' ),
                    'default' => 324,
                ]
            );
            $list_items->add_control(
                'suffix',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Number Suffix', 'gauch-toolkit' ),
                    'default' => __('+', 'gauch-toolkit'),
                ]
            );
            $list_items->add_control(
                'title',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Title', 'gauch-toolkit' ),
                    'default' => __('Project Completed', 'gauch-toolkit'),
                ]
            );
            $this->add_control(
                'items',
                [
                    'label'   => __( 'Add Counter Item', 'gauch-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'counter_style',
			[
				'label' => __( 'Style', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'counter_color',
                [
                    'label' => __( 'Number Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-funfacts-box h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'number_typography',
                    'label'    => __( 'Number Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-funfacts-box h3',
                ]
            );

            $this->add_control(
				'title_color',
				[
					'label' => __( 'Title Color', 'gauch-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-funfacts-boxs p' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-funfacts-boxs p',
                ]
            );

            $this->add_control(
				'icon_color',
				[
					'label' => __( 'Icon Color', 'gauch-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-funfacts-boxs i' => 'color: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();
        ?>

        <div class="container">
            <div class="row justify-content-center">
                <?php $i = 1; foreach( $settings['items'] as $item ): ?>
                    <div class="col-lg-3 col-md-6 col-sm-4 col-6">
                        <div class="single-funfacts-box">
                            <div class="icon" style="background-color:<?php echo esc_attr($item['icon_bg_color']); ?>;">
                                <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                            </div>
                            <h3><span class="odometer" data-count="<?php echo esc_attr( $item['number'] ); ?>">00</span> <?php echo esc_html( $item['suffix'] ); ?></h3>
                            <p><?php echo esc_html( $item['title'] ); ?></p>
                        </div>
                    </div>
                <?php $i++; endforeach; ?>
            </div>
        </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Funfacts );