<?php
/**
 * Feedback Widget
 */

namespace Elementor;
class Gauch_Feedback_Area extends Widget_Base {

	public function get_name() {
        return 'FeedbackArea';
    }

	public function get_title() {
        return __( 'Feedback Area', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-testimonial';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $list_items = new Repeater();

        $list_items->add_control(
            'image',
            [
                'label' => __( 'Image', 'gauch-toolkit' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $list_items->add_control(
            'name',
            [
                'label' => esc_html__('Name', 'gauch-toolkit'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Olivar Lucy', 'gauch-toolkit'),
                'label_block' => true,
            ]
        );
        $list_items->add_control(
            'designation',
            [
                'label' => esc_html__('Designation', 'gauch-toolkit'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('CEO at ThemeForest', 'gauch-toolkit'),
                'label_block' => true,
            ]
        );
        $list_items->add_control(
            'feedback',
            [
                'label' => esc_html__('Feedback Content', 'gauch-toolkit'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Gauch is the best digital agency in our area As a midsize software developent company we combine the best of both worlds. We have the focus and speed of the small it outsurcing companies.', 'gauch-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'gauch_feedback_items',
            [
                'label' => esc_html__('Feedback Item', 'gauch-toolkit'),
                'type' => Controls_Manager::REPEATER,
                'default' => [
                    [ 'name' => esc_html__(' Item #1', 'gauch-toolkit') ],

                ],
                'fields' => $list_items->get_controls(),
            ]
        );
        $this->add_control(
            'quote_image',
            [
                'label' => __( 'Quote', 'gauch-toolkit' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
    $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        $items = $settings['gauch_feedback_items'];

        $this-> add_inline_editing_attributes('title','none'); ?>

        <?php $count = 0;
        foreach ( $items as $key => $value ) {
            $count++;
        } ?>

        <div class="container">
            <div class="feedback-slides owl-carousel owl-theme">
                <?php foreach ( $items as $key => $value ) { ?>
                    <div class="single-feedback-box">
                        <p><?php echo wp_kses_post( $value['feedback'] ); ?></p>
                        <div class="client-info">
                            <div class="d-flex align-items-center">
                                <?php if( $value['image']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url( $value['image']['url'] ); ?>" alt="<?php echo esc_attr__('image','gauch-toolkit' ) ?>">
                                <?php endif; ?>
                                <div class="title">
                                    <h3><?php echo esc_html( $value['name'] ); ?></h3>
                                    <span><?php echo esc_html( $value['designation'] ); ?></span>
                                </div>
                            </div>
                        </div>
                        <?php if($settings['quote_image']['url']): ?>
                            <style>
                                .single-feedback-box::before {background-image: url(<?php echo esc_url( $settings['quote_image']['url'] ); ?> )}
                            </style>
                        <?php endif; ?>
                    </div>
                <?php } ?>
            </div>
        </div>

        <?php
	}


}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Feedback_Area );