<?php
/**
 * FAQ Widget
 */

namespace Elementor;
class Gauch_Faq extends Widget_Base {

	public function get_name() {
        return 'FAQ';
    }

	public function get_title() {
        return __( 'Gauch FAQ', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-help-o';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Faq',
			[
				'label' => __( 'Faq Control', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
            'sec_style',
            [
                'label' => __( 'Section Style', 'gauch-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'   => __( 'Style 1', 'gauch-toolkit' ),
                    '2'   => __( 'Style 2', 'gauch-toolkit' ),
                ],
                'default' => '1',
            ]
        );

        $this->add_control(
            'section_img', [
                'type'    => Controls_Manager::MEDIA,
                'label'   => esc_html__( ' Image', 'gauch-toolkit' ),
                'condition' => [
                    'sec_style' => '2',
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'gauch-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Frequently Asked Questions', 'gauch-toolkit'),
                'condition' => [
                    'sec_style' => '2',
                ]
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__( 'Title Tag', 'gauch-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1'         => esc_html__( 'h1', 'gauch-toolkit' ),
                    'h2'         => esc_html__( 'h2', 'gauch-toolkit' ),
                    'h3'         => esc_html__( 'h3', 'gauch-toolkit' ),
                    'h4'         => esc_html__( 'h4', 'gauch-toolkit' ),
                    'h5'         => esc_html__( 'h5', 'gauch-toolkit' ),
                    'h6'         => esc_html__( 'h6', 'gauch-toolkit' ),
                ],
                'default' => 'h2',
                'condition' => [
                    'sec_style' => '2',
                ]
            ]
        );

        $this->add_control(
            'content',
            [
                'label' => esc_html__( 'Content', 'gauch-toolkit' ),
                'type' => Controls_Manager::WYSIWYG,
                'default' => esc_html__('Cloud based storage for your data backup just log in with your mail account from play store and using whatever you want for your business purpose orem ipsum dummy text. Never missyour chance its just began.', 'gauch-toolkit'),
                'condition' => [
                    'sec_style' => '2',
                ]
            ]
        );

        $list_items = new Repeater();

        $list_items->add_control(
            'title',
            [
                'label' => __( 'Title', 'gauch-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'What are my payment options?', 'gauch-toolkit' ),
            ]
        );
        $list_items->add_control(
            'content',
            [
                'label' => __( 'Description', 'gauch-toolkit' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Gauch is always looking for talented information security and IT risk management professionals who are dedicated, hard working and looking for a challenge. If you are interested in employment with Gauch, a company who values you and your family, visit our careers page.' ),
            ]
        );
        $this->add_control(
            'faq_item',
            [
                'label' => esc_html__('Faq Item', 'gauch-toolkit'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $list_items->get_controls(),
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        $faq_item = $settings['faq_item'];
        ?>

        <?php if($settings['sec_style'] == '1'): ?>
            <div class="container">
                <div class="faq-accordion accordion" id="accordionFaq">
                    <?php $i = 1;  foreach( $faq_item as $item ): ?>
                        <div class="accordion-item">
                            <button class="accordion-button <?php if($i != 1): ?>collapsed<?php endif; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>" aria-expanded="<?php if($i == 1): ?>true<?php else: echo 'false'; endif; ?>" aria-controls="collapse<?php echo $i; ?>"><?php echo esc_html( $item['title'] ); ?></button>

                            <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php if($i == 1): ?>show<?php endif; ?>" data-bs-parent="#accordionFaq">
                                <div class="accordion-body">
                                    <?php echo wp_kses_post($item['content'] ); ?>
                                </div>
                            </div>
                        </div>
                    <?php $i++; endforeach; ?>
                </div>
            </div>
        <?php else: ?>
            <div class="ico-faq-area ptb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <?php if( $settings['section_img']['url'] != '' ) : ?>
                        <div class="col-lg-6 col-md-12">
                            <div class="ico-faq-image">
                                <img src="<?php echo esc_url( $settings['section_img']['url'] ); ?>" alt="<?php echo esc_attr__( 'Image', 'gauch-toolkit' ); ?>">
                            </div>
                        </div>
                        <?php endif; ?>

                        <div class="col-lg-6 col-md-12">
                            <div class="ico-faq-content">
                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <?php echo wp_kses_post( $settings['content'] ); ?>
                            </div>
                            <div class="ico-faq-accordion accordion" id="accordionFaq">

                                <?php $i = 1;  foreach( $faq_item as $item ): ?>
                                    <div class="accordion-item">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>" aria-expanded="true" aria-controls="collapse<?php echo $i; ?>"><?php echo esc_html( $item['title'] ); ?></button>

                                        <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php if($i == 1): ?>show<?php endif; ?>" data-bs-parent="#accordionFaq">
                                            <div class="accordion-body">
                                                <?php echo wp_kses_post($item['content'] ); ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php $i++; endforeach; ?>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Faq );