<?php
/**
 * Banner 5 Widget
 */

namespace Elementor;
class Gauch_Banner_Five extends Widget_Base {

	public function get_name() {
        return 'GauchBannerFive';
    }

	public function get_title() {
        return __( 'Banner Five', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-banner';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Banner_Area',
			[
				'label' => __( 'Banner Controls', 'gauch-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
			$this->add_control(
                'title_tag',
                [
                    'label' 	=> esc_html__( 'Title Tag', 'gauch-toolkit' ),
                    'type' 		=> Controls_Manager::SELECT,
                    'options' 	=> [
                        'h1'         => esc_html__( 'h1', 'gauch-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'gauch-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'gauch-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'gauch-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'gauch-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'gauch-toolkit' ),
                    ],
                    'default' => 'h1',
                ]
            );

			$this->add_control(
				'title',
				[
					'label'       => __( 'Title', 'gauch-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
					'default'     => __('Lets Make Wave Amazing Together', 'gauch-toolkit'),
                    'label_block' => true,
				]
			);
			$this->add_control(
				'desc',
				[
					'label'       => __( 'Description', 'gauch-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
					'default'     => __('Donec sollicitudin molestie malesuada. Vivamus magna justo lacinia eget consectetur sed convallis at tellus. Donec rutrum congue leo eget malesuada.', 'gauch-toolkit'),
                    'label_block' => true,
				]
			);
			// Button One
			$this->add_control(
				'button_text',
				[
					'label'   => __( 'Button Text', 'gauch-toolkit' ),
					'type'    => Controls_Manager::TEXT,
					'default' => __('Get Started Now', 'gauch-toolkit'),
                    'label_block' => true,
				]
			);
			$this->add_control(
                'link_type',
                [
                    'label' 		=> esc_html__( 'Button Link Type', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' => [
                        '1'  	=> esc_html__( 'Link To Page', 'gauch-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'gauch-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'link_to_page',
                [
                    'label' 		=> esc_html__( 'Button Link Page', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> gauch_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                    ]
                ]
            );
            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button External Link', 'gauch-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );
            $this->add_control(
                'btn_div',
                [
                    'type'		=> Controls_Manager:: DIVIDER,
                ]
            );
			$this->add_control(
				'button_text2',
				[
					'label'   => __( 'Button Text Two', 'gauch-toolkit' ),
					'type'    => Controls_Manager::TEXT,
					'default' => __('White Paper', 'gauch-toolkit'),
                    'label_block' => true,
				]
			);
			$this->add_control(
                'link_type2',
                [
                    'label' 		=> esc_html__( 'Button Link Type', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' => [
                        '1'  	=> esc_html__( 'Link To Page', 'gauch-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'gauch-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'link_to_page2',
                [
                    'label' 		=> esc_html__( 'Button Link Page', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> gauch_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type2' => '1',
                    ]
                ]
            );
            $this->add_control(
                'ex_link2',
                [
                    'label'		=> esc_html__('Button External Link', 'gauch-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type2' => '2',
                    ]
                ]
            );

			$this->add_control(
                'sep2_div',
                [
                    'type'		=> Controls_Manager:: DIVIDER,
                ]
            );

			$this->add_control(
                'comm_text',
                [
                    'label'		=> esc_html__('Community Text', 'gauch-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
					'default'   => __('	Join Our Community', 'gauch-toolkit'),
                ]
            );
			$repeater = new Repeater();
			$repeater->add_control(
				'icon1',
				[
					'label' => esc_html__( 'Social Icon', 'gauch-toolkit' ),
					'type' => Controls_Manager::ICON,
					'label_block' => true,
					'options' => gauch_icons(),
				]
			);
			$repeater->add_control(
				'url1',
				[
					'label' => esc_html__( 'Social Link', 'gauch-toolkit' ),
					'type' => Controls_Manager::URL,
				]
			);
			$this->add_control(
				'social_icons',
				[
					'label' => esc_html__( 'Add Icon', 'gauch-toolkit' ),
					'type' => Controls_Manager::REPEATER,
					'fields' => $repeater->get_controls(),
				]
			);
			$this->add_control(
                'sep3_div',
                [
                    'type'		=> Controls_Manager:: DIVIDER,
                ]
            );
			$this->add_control(
				'bg_image',
				[
					'label' => __( 'Section Background Image', 'gauch-toolkit' ),
					'type'  => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'sec_image',
				[
					'label' => __( 'Section Right Image', 'gauch-toolkit' ),
					'type'  => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'shape1',
				[
					'label' => __( 'Shape 1', 'gauch-toolkit' ),
					'type'  => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'shape2',
				[
					'label' => __( 'Shape 2', 'gauch-toolkit' ),
					'type'  => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'shape3',
				[
					'label' => __( 'Shape 3', 'gauch-toolkit' ),
					'type'  => Controls_Manager::MEDIA,
				]
			);
        $this->end_controls_section();

        $this->start_controls_section(
			'banner_style',
			[
				'label' => __( 'Style', 'gauch-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .cryptocurrency-banner-content h1, .cryptocurrency-banner-content h2, .cryptocurrency-banner-content h3, .cryptocurrency-banner-content h4, .cryptocurrency-banner-content h5, .cryptocurrency-banner-content h6' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .cryptocurrency-banner-content h1, .cryptocurrency-banner-content h2, .cryptocurrency-banner-content h3, .cryptocurrency-banner-content h4, .cryptocurrency-banner-content h5, .cryptocurrency-banner-content h6',
                ]
            );
			$this->add_control(
				'desc_color',
				[
					'label'     => __( 'Description Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .cryptocurrency-banner-content p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'desc_typography',
                    'label'    => __( 'Description Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .cryptocurrency-banner-content p',
                ]
            );

			$this->add_control(
				'btn_text_color',
				[
					'label'     => __( 'Button Text Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn.style-two' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn.style-two' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'btn_hover_color',
				[
					'label'     => __( 'Button Hover Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn.style-two:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_hover_bg_color',
				[
					'label'     => __( 'Button Hover Background Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn.style-two:hover' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn.style-two',
                ]
            );
			$this->add_control(
				'btn_text_color2',
				[
					'label'     => __( 'Button Text 2 Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .cryptocurrency-banner-content .banner-btn-list li .white-paper-btn' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn2_bg_color',
				[
					'label'     => __( 'Button 2 Background Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .cryptocurrency-banner-content .banner-btn-list li .white-paper-btn' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn2_hover_color',
				[
					'label'     => __( 'Button 2 Hover Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .cryptocurrency-banner-content .banner-btn-list li .white-paper-btn:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn2_hover_bg_color',
				[
					'label'     => __( 'Button 2 Hover Background Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .cryptocurrency-banner-content .banner-btn-list li .white-paper-btn:hover' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn2_typography',
                    'label'    => __( 'Button 2 Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .cryptocurrency-banner-content .banner-btn-list li .white-paper-btn',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

		// Get Button Link
        if( $settings['link_type'] == 1 ){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }
		// Get Button Link
        if( $settings['link_type2'] == 1 ){
            $link2 = get_page_link( $settings['link_to_page2'] );
        } else {
            $link2 = $settings['ex_link2'];
        }

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
		$this-> add_inline_editing_attributes('content','none');
		?>

		<div class="cryptocurrency-banner-area" style="background-image:url(<?php echo esc_url( $settings['bg_image']['url'] ); ?>);">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <div class="cryptocurrency-banner-content">
							<<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>>
								<?php echo esc_html( $settings['title'] ); ?>
							</<?php echo esc_attr( $settings['title_tag'] ); ?>>

							<p><?php echo esc_html( $settings['desc'] ); ?></p>

							<?php if( $settings['button_text'] != '' ||  $settings['button_text2'] != '' ) : ?>
								<ul class="banner-btn-list">
									<?php if( $settings['button_text'] ): ?>
										<li>
											<a href="<?php echo esc_url( $link ); ?>" class="default-btn style-two"><span class="ri-arrow-right-s-line"></span><?php echo esc_html( $settings['button_text'] ); ?></a>
										</li>
									<?php endif; ?>
									<?php if( $settings['button_text2'] ): ?>
										<li>
											<a href="<?php echo esc_url( $link2 ); ?>" class="white-paper-btn"><?php echo esc_html( $settings['button_text2'] ); ?></a>
										</li>
									<?php endif; ?>
								</ul>
							<?php endif; ?>

                            <ul class="banner-community">
                                <span><?php echo esc_html( $settings['comm_text'] ); ?></span>
  								<?php foreach( $settings['social_icons'] as $item ): ?>
									<?php if( $item['icon1'] != '' && $item['url1']['url'] != '' ): ?>
                                        <li><a href="<?php echo esc_url( $item['url1']['url'] ); ?>"><i class="<?php echo esc_attr( $item['icon1'] ); ?>"></i></a></li>
                                    <?php endif; ?>
 								<?php endforeach; ?>
                            </ul>
                        </div>
                    </div>

					<?php if($settings['sec_image']['url']): ?>
					<div class="col-lg-6 col-md-12">
						<div class="cryptocurrency-banner-image">
							<img src="<?php echo esc_url( $settings['sec_image']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
						</div>
					</div>
					<?php endif; ?>
                </div>
            </div>

			<?php if($settings['shape1']['url']): ?>
				<div class="cryptocurrency-banner-shape-1">
					<img src="<?php echo esc_url( $settings['shape1']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
				</div>
			<?php endif; ?>
			<?php if($settings['shape2']['url']): ?>
				<div class="cryptocurrency-banner-shape-2">
					<img src="<?php echo esc_url( $settings['shape2']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
				</div>
			<?php endif; ?>
			<?php if($settings['shape3']['url']): ?>
				<div class="cryptocurrency-banner-shape-3">
					<img src="<?php echo esc_url( $settings['shape3']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
				</div>
			<?php endif; ?>
        </div>
        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Banner_Five );