<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = GAUCH_FRAMEWORK_VAR;

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'opt_name/opt_name', $opt_name );

    // Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
    $sampleHTML = '';
    if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
    }

    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();

    if ( is_dir( $sample_patterns_path ) ) {
        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();
            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {
                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    // All the possible arguments for Redux.
    $theme = wp_get_theme(); // For use with some settings. Not necessary.
    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'تنظیمات قالب', 'gauch-toolkit' ),
        'page_title'           => __( 'تنظیمات قالب', 'gauch-toolkit' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => false,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => 90,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => 'opt_nameion',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( __( '<p></p>', 'gauch-toolkit' ), $v );
    } else {
        $args['intro_text'] = __( '<p>This text is displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.</p>', 'gauch-toolkit' );
    }
    Redux::setArgs( $opt_name, $args );
    // END ARGUMENTS

    // START HELP TABS
    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => __( 'Theme Information 1', 'gauch-toolkit' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'gauch-toolkit' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => __( 'Theme Information 2', 'gauch-toolkit' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'gauch-toolkit' )
        )
    );
    Redux::set_help_tab( $opt_name, $tabs );

    // Set the help sidebar
    $content = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'gauch-toolkit' );
    Redux::set_help_sidebar( $opt_name, $content );

// General Options
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( 'تنظیمات پوسته', 'gauch-toolkit' ),
    'id'                => 'general_options',
    'customizer'        => false,
    'icon'              => ' el el-home',
    'fields'     => array(
        array(
            'id'      => 'gauch_enable_rtl',
            'type'    => 'select',
            'options' => array(
                'enable'        => 'فعال',
                'disable'       => 'غیرفعال',
            ),
            'title'     => esc_html__( 'راستچین', 'gauch-toolkit' ),
            'default'   => 'غیرفعال',
        ),
        array(
            'id'       => 'main_logo',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'لوگو سایت', 'gauch-toolkit' ),
            'desc'     => esc_html__( 'سایز پیشنهادی - عرض: 140 پیکسل، ارتفاع: 45 پیکسل', 'gauch-toolkit' ),
        ),
        array(
            'title'     => __( 'ابعاد لوگوی سایت', 'gauch-toolkit' ),
            'id'        => 'main_logo_dimensions',
            'type'      => 'dimensions',
            'units'     => array( 'em','px','%' ),
            'output'    => '.navbar-brand .black-logo, .navbar-brand img'
        ),
        array(
            'id'       => 'mobile_logo',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'لوگو برای موبایل (اختیاری)', 'gauch-toolkit' ),
            'desc'     => esc_html__( 'سایز پیشنهادی - عرض: 120 پیکسل، ارتفاع: 35 پیکسل', 'gauch-toolkit' ),
        ),

        array(
            'title'     => __( 'ابعاد لوگوی موبایل', 'gauch-toolkit' ),
            'id'        => 'mobile_logo_dimensions',
            'type'      => 'dimensions',
            'units'     => array( 'em','px','%' ),
            'output'    => '.logo img'
        ),

        array(
            'id'        => 'enable_sticky_header',
            'type'      => 'switch',
            'title'     => esc_html__('فعال کردن هدرچسبنده', 'gauch-toolkit'),
            'default'   => '1'
        ),
        array(
            'id'        => 'enable_back_to_top',
            'type'      => 'switch',
            'title'     => esc_html__('دکمه بازگشت به بالا را فعال کنید', 'gauch-toolkit'),
            'default'   => '1'
        ),
    ),
) );

// Preloader Options
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'پیش بارگذاری', 'gauch-toolkit' ),
    'id'               => 'preloader_opt',
    'icon'             => 'dashicons dashicons-controls-repeat',
    'fields'           => array(

        array(
            'id'      => 'enable_preloader',
            'type'    => 'switch',
            'title'   => esc_html__( 'پیش بارگذاری', 'gauch-toolkit' ),
            'on'      => esc_html__( 'فعال', 'gauch-toolkit' ),
            'off'     => esc_html__( 'غیرفعال', 'gauch-toolkit' ),
            'default' => true,
        ),

        array(
            'required' => array( 'enable_preloader', '=', '1' ),
            'id'       => 'preloader_style',
            'type'     => 'select',
            'title'    => esc_html__( 'استایل پیش بارگذاری', 'gauch-toolkit' ),
            'default'   => 'circle-spin',
            'options'  => array(
                'circle-spin'   => esc_html__( 'چرخش', 'gauch-toolkit' ),
                'text'          => esc_html__( 'متن', 'gauch-toolkit' ),
                'image'         => esc_html__( 'تصویر', 'gauch-toolkit' )
            )
        ),

        /**
         * Text Preloader
         */
        array(
            'title'     => esc_html__( 'رنگ پس زمینه', 'gauch-toolkit' ),
            'id'        => 'preloader_color_spin',
            'type'      => 'background',
            'background-image'      => false,
            'background-repeat'     => false,
            'background-size'       => false,
            'background-attachment' => false,
            'background-position'   => false,
            'transparent'           => false,
            'output'    => array( '.preloader-area' ),
        ),
        array(
            'title'     => esc_html__( 'رنگ', 'gauch-toolkit' ),
            'id'        => 'preloader_color',
            'type'      => 'color',
            'output'    => array( '.preloader-area p' ),
            'required'  => array( 'preloader_style', '=', 'text' ),
        ),
        array(
            'id'       => 'loading_text',
            'type'     => 'text',
            'title'    => esc_html__( 'متن لودینگ', 'gauch-toolkit' ),
            'default'  => esc_html__( 'لودینگ', 'gauch-toolkit' ),
            'required' => array( 'preloader_style', '=', 'text' ),
        ),

        array(
            'title'         => esc_html__( 'فونت متن لودینگ', 'gauch-toolkit' ),
            'id'            => 'preloader_small_typo',
            'type'          => 'typography',
            'text-align'    => false,
            'output'        => '.preloader-area p',
            'required' => array( 'preloader_style', '=', 'text' ),
        ),

        /**
         * Image Preloader
         */
        array(
            'required' => array( 'preloader_style', '=', 'image' ),
            'id'       => 'preloader_image',
            'type'     => 'media',
            'title'    => esc_html__( 'پیش بارگذاری تصویر', 'gauch-toolkit' ),
            'compiler' => true,
        ),
    )
));

// Header Top Area
Redux::setSection( $opt_name, array(
	'title' => esc_html__('بخش ارز دیجیتال بالای هدر', 'gauch-toolkit'),
	'desc'  => esc_html__( '', 'gauch-toolkit' ),
	'icon'  => 'el-icon-user',
	'customizer' => false,
	'fields' => array(
        array(
            'id'       => 'trade_img1',
            'type'     => 'media',
            'title'    => esc_html__( 'تصویر', 'gauch-toolkit' ),
            'compiler' => true,
        ),
        array(
			'id'    => 'trade_con1',
            'type'  => 'textarea',
			'title' => esc_html__('متن', 'gauch-toolkit')
		),

        array(
            'id'       => 'trade_img2',
            'type'     => 'media',
            'title'    => esc_html__( 'تصویر', 'gauch-toolkit' ),
            'compiler' => true,
        ),
        array(
			'id'    => 'trade_con2',
            'type'  => 'textarea',
			'title' => esc_html__('متن', 'gauch-toolkit')
		),

        array(
            'id'       => 'trade_img3',
            'type'     => 'media',
            'title'    => esc_html__( 'تصویر', 'gauch-toolkit' ),
            'compiler' => true,
        ),
        array(
			'id'    => 'trade_con3',
            'type'  => 'textarea',
			'title' => esc_html__('متن', 'gauch-toolkit')
		),

        array(
            'id'       => 'trade_img4',
            'type'     => 'media',
            'title'    => esc_html__( 'تصویر', 'gauch-toolkit' ),
            'compiler' => true,
        ),
        array(
			'id'    => 'trade_con4',
            'type'  => 'textarea',
			'title' => esc_html__('متن', 'gauch-toolkit')
		),

        array(
            'id'       => 'trade_img5',
            'type'     => 'media',
            'title'    => esc_html__( 'تصویر', 'gauch-toolkit' ),
            'compiler' => true,
        ),
        array(
			'id'    => 'trade_con5',
            'type'  => 'textarea',
			'title' => esc_html__('متن', 'gauch-toolkit')
		),

        array(
            'id'       => 'trade_img6',
            'type'     => 'media',
            'title'    => esc_html__( 'تصویر', 'gauch-toolkit' ),
            'compiler' => true,
        ),

        array(
			'id'    => 'trade_con6',
            'type'  => 'textarea',
			'title' => esc_html__('متن', 'gauch-toolkit')
		),

        array(
            'id'       => 'trade_img7',
            'type'     => 'media',
            'title'    => esc_html__( 'تصویر', 'gauch-toolkit' ),
            'compiler' => true,
        ),
        array(
			'id'    => 'trade_con7',
            'type'  => 'textarea',
			'title' => esc_html__('متن', 'gauch-toolkit')
		),

        array(
            'id'       => 'trade_img8',
            'type'     => 'media',
            'title'    => esc_html__( 'تصویر', 'gauch-toolkit' ),
            'compiler' => true,
        ),
        array(
			'id'    => 'trade_con8',
            'type'  => 'textarea',
			'title' => esc_html__('متن', 'gauch-toolkit')
		),

        array(
            'id'       => 'trade_img9',
            'type'     => 'media',
            'title'    => esc_html__( 'تصویر', 'gauch-toolkit' ),
            'compiler' => true,
        ),
        array(
			'id'    => 'trade_con9',
            'type'  => 'textarea',
			'title' => esc_html__('Content 9', 'gauch-toolkit')
		),
	)
) );

// Header Option
Redux::setSection( $opt_name, array(
	'title' => esc_html__('هدر', 'gauch-toolkit'),
	'icon'  => 'el el-caret-up',
	'customizer' => false,
	'fields' => array(
        array(
            'id'       => 'hide_top_header',
            'type'     => 'checkbox',
            'title'    => esc_html__( 'مخفی کردن هدر بالا ؟', 'gauch-toolkit' ),
        ),
        array(
            'id' => 'top_header_placeholder',
            'type' => 'text',
            'title' => esc_html__('متن کادر جستجو', 'gauch-toolkit'),
            'required' => array('hide_top_header','!=','1'),
        ),
        array(
            'id' => 'call_number',
            'type' => 'text',
            'title' => esc_html__('تلفن', 'gauch-toolkit'),
            'required' => array('hide_top_header','!=','1'),
        ),
        array(
            'id' => 'call_number_link',
            'type' => 'text',
            'title' => esc_html__('لینک شماره', 'gauch-toolkit'),
            'required' => array('hide_top_header','!=','1'),
        ),
        array(
            'id' => 'email_address',
            'type' => 'text',
            'title' => esc_html__('آدرس ایمیل', 'gauch-toolkit'),
            'required' => array('hide_top_header','!=','1'),
        ),
        array(
            'id' => 'email_address_link',
            'type' => 'text',
            'title' => esc_html__('لینک آدرس ایمیل', 'gauch-toolkit'),
            'required' => array('hide_top_header','!=','1'),
        ),
        array(
            'id'       => 'hide_top_header_social',
            'type'     => 'checkbox',
            'title'    => esc_html__( 'مخفی کردن شبکه های اجتماعی هدر بالا؟', 'gauch-toolkit' ),
            'required' => array('hide_top_header','!=','1'),
        ),
        array(
			'id'    => 'header_btn_icon',
            'type'  => 'text',
			'title' => esc_html__('کلاس آیکون دکمه هدر', 'gauch-toolkit'),
        ),
        array(
			'id'    => 'header_btn',
            'type'  => 'text',
			'title' => esc_html__('متن دکمه هدر', 'gauch-toolkit'),
        ),
        array(
			'id'    => 'header_btn_link',
            'type'  => 'text',
			'title' => esc_html__('لینک دکمه هدر', 'gauch-toolkit'),
        ),
	)
) );

// Banner
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( 'بنر', 'gauch-toolkit' ),
    'id'                => 'banner_options',
    'customizer'        => false,
    'icon'              => 'el el-website',
    'fields'     => array(
        array(
            'id'        => 'page_title_tag',
            'type'      => 'select',
            'title'     => esc_html__( 'برچسب عنوان بنر', 'gauch-toolkit' ),
            'options' => array(
                'h1'         => esc_html__( 'h1', 'gauch-toolkit' ),
                'h2'         => esc_html__( 'h2', 'gauch-toolkit' ),
                'h3'         => esc_html__( 'h3', 'gauch-toolkit' ),
                'h4'         => esc_html__( 'h4', 'gauch-toolkit' ),
                'h5'         => esc_html__( 'h5', 'gauch-toolkit' ),
                'h6'         => esc_html__( 'h6', 'gauch-toolkit' ),
            ),
            'default' => 'h1',
            'output'    => '.page-title-content h1, .page-title-content h2, .page-title-content h3, .page-title-content h4, .page-title-content h5, .page-title-content h6'
        ),
        array(
            'id'        => 'titlebar_title_typo',
            'type'      => 'typography',
            'text-align'    => false,
            'title'     => esc_html__( 'فونت عنوان', 'gauch-toolkit' ),
            'output'    => '.page-title-content h1, .page-title-content h2, .page-title-content h3, .page-title-content h4, .page-title-content h5, .page-title-content h6'
        ),
        array(
            'id'        => 'titlebar_desc_typo',
            'type'      => 'typography',
            'text-align'    => false,
            'title'     => esc_html__( 'فونت موقعیت مکانی', 'gauch-toolkit' ),
            'output'    => '.page-title-content ul li a, .page-title-content ul li'
        ),
        array(
            'title'     => esc_html__( 'فاصله بنر', 'gauch-toolkit' ),
            'subtitle'  => esc_html__( 'فاصله اطراف بنر', 'gauch-toolkit' ),
            'id'        => 'banner_padding',
            'type'      => 'spacing',
            'output'    => array( '.page-title-area' ),
            'mode'      => 'padding',
            'units'     => array( 'em', 'px', '%' ),
            'units_extended' => 'true',
        ),
        array(
            'id'       => 'banner_img1',
            'type'     => 'media',
            'title'    => esc_html__( 'تصویر شیپ اول', 'gauch-toolkit' ),
            'compiler' => true,
        ),
        array(
            'id'       => 'banner_img2',
            'type'     => 'media',
            'title'    => esc_html__( 'تصویر شیپ دوم', 'gauch-toolkit' ),
            'compiler' => true,
        ),
    ),
) );

// Social Profiles
Redux::setSection( $opt_name, array(
	'title' => esc_html__('شبکه اجتماعی', 'gauch-toolkit'),
	'desc'  => esc_html__( 'شبکه های اجتماعی در مکان های مختلف داخل قالب استفاده می شود', 'gauch-toolkit' ),
	'icon'  => 'el-icon-user',
	'customizer' => false,
	'fields' => array(
        array(
            'id' => 'gauch_social_target',
            'type' => 'select',
            'options' => array(
                '_blank'    => '( _blank )',
                '_self'     => '( _self )',
                '_parent'   => '( _parent )',
                '_top'      => '( _top )',
            ),
            'title'     => esc_html__( 'تارگت لینک', 'gauch-toolkit' ),
            'default'   => '_blank',
        ),

        array(
			'id'    => 'twitter_url',
            'type'  => 'text',
			'title' => esc_html__('لینک توییتر', 'gauch-toolkit')
		),
		array(
			'id'    => 'facebook_url',
			'type'  => 'text',
			'title' =>esc_html__('لینک فیسبوک', 'gauch-toolkit')
		),
		array(
			'id'    => 'instagram_url',
			'type'  => 'text',
			'title' => esc_html__('لینک اینستاگرام', 'gauch-toolkit')
		),
		array(
			'id'    => 'linkedin_url',
			'type'  => 'text',
			'title' => esc_html__('لینک لینکیداین', 'gauch-toolkit')
		),
		array(
			'id'    => 'pinterest_url',
			'type'  => 'text',
			'title' =>esc_html__('لینک پینترست', 'gauch-toolkit')
		),
		array(
			'id'    => 'dribbble_url',
			'type'  => 'text',
			'title' =>esc_html__('Dribbble لینک', 'gauch-toolkit')
		),
		array(
			'id'    => 'tumblr_url',
			'type'  => 'text',
			'title' =>esc_html__('لینک تامبلر', 'gauch-toolkit')
		),
		array(
			'id'    => 'youtube_url',
			'type'  => 'text',
			'title' =>  esc_html__('لینک یوتیوب', 'gauch-toolkit')
		),
		array(
			'id'    => 'flickr_url',
			'type'  => 'text',
			'title' =>  esc_html__('لینک فلیکر', 'gauch-toolkit')
		),
		array(
			'id'    => 'behance_url',
			'type'  => 'text',
			'title' =>  esc_html__('Behance لینک', 'gauch-toolkit'),
		),
		array(
			'id'    => 'github_url',
			'type'  => 'text',
			'title' =>  esc_html__('لینک گیت هاب', 'gauch-toolkit'),
		),
		array(
			'id'    => 'skype_url',
			'type'  => 'text',
			'title' =>  esc_html__('لینک  اسکایپ', 'gauch-toolkit'),
		),
		array(
			'id'    => 'rss_url',
			'type'  => 'text',
			'title' =>  esc_html__('RSS لینک', 'gauch-toolkit')
		),
	)
) );

// Footer Area
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( 'فوتر', 'gauch-toolkit' ),
    'id'                => 'footer',
    'customizer'        => false,
    'icon'              => 'el el-edit',
    'fields' => array(
        array(
            'id'        => 'copyright_text',
            'type'      => 'editor',
            'title'     => esc_html__('متن کپی رایت پاورقی (اختیاری)', 'gauch-toolkit'),
            'subtitle'  => esc_html__('کد HTML و شورت کد مجاز است', 'gauch-toolkit'),
            'args' => array(
                'teeny'         => true,
                'media_buttons' => false
            ),
        ),
        array(
            'id'            => 'footer_bg',
            'type'          => 'color',
            'title'         => esc_html__('رنگ پس زمینه فوتر', 'gauch-toolkit'),
            'default'       => '#f9f9f9',
            'validate'      => 'color',
            'transparent'   => false
        ),
        array(
            'title'     => esc_html__( 'ستون فوتر', 'gauch-toolkit' ),
            'id'        => 'footer_column',
            'type'      => 'select',
            'default'   => '4',
            'options'   => array(
                '-lg-12'    => esc_html__( 'یک ستونه', 'gauch-toolkit' ),
                '-lg-6'     => esc_html__( 'دو ستونه', 'gauch-toolkit' ),
                '-lg-4'     => esc_html__( 'سه ستونه', 'gauch-toolkit' ),
                '-lg-3'     => esc_html__( 'چهار ستونه', 'gauch-toolkit' ),
                '  auto'    => esc_html__( 'ستون خودکار', 'gauch-toolkit' ),
            ),
        ),
        array(
            'id'       => 'footer_shape',
            'type'     => 'media',
            'title'    => esc_html__( 'شیپ فوتر', 'gauch-toolkit' ),
            'compiler' => true,
        ),
    )
));

// Styling
Redux::setSection( $opt_name, array(
    'title'        => esc_html__( 'تنظیمات استایل', 'gauch-toolkit' ),
    'id'           => 'styling_options',
    'customizer'   => false,
    'icon'         => ' el el-magic',
    'fields'     => array(
        array(
            'id'            => 'primary_color',
            'type'          => 'color',
            'title'         => esc_html__('رنگ اصلی', 'gauch-toolkit'),
            'default'       => '#029894',
            'validate'      => 'color',
            'transparent'   => false,
        ),

        array(
            'id'            => 'nav_item_color',
            'type'          => 'color',
            'title'         => esc_html__('رنگ ایتم ناوبر', 'gauch-toolkit'),
            'default'       => '#09114a',
            'validate'      => 'color',
            'transparent'   => false
        ),

        array(
            'id'            => 'mob_nav_item_color',
            'type'          => 'color',
            'title'         => esc_html__('رنگ ایتم ناوبر موبایل', 'gauch-toolkit'),
            'default'       => '#09114a',
            'validate'      => 'color',
            'transparent'   => false
        ),

    ),
) );

// Blog Area
Redux::setSection( $opt_name, array(
    'title'         => esc_html__( 'تنظیمات وبلاگ', 'gauch-toolkit' ),
    'id'            => 'gauch_blog',
    'customizer'    => false,
    'icon'          => 'el el-file-edit',
    'desc'          => esc_html__( 'تنظیمات وبلاگ خود را مدیریت کنید', 'gauch-toolkit' ),
    'fields' => array(
        array(
            'id' => 'gauch_blog_style',
            'type' => 'select',
            'options' => array(
                '1'        => 'استایل یک',
                '2'       => 'استایل دو',
            ),
            'title'     => esc_html__( 'استایل وبلاگ', 'gauch-toolkit' ),
            'default'   => '1',
        ),
        array(
            'id'       => 'single_blog_bg',
            'type'     => 'media',
            'title'    => esc_html__( 'پس زمینه بنر وبلاگ تکی', 'gauch-toolkit' ),
            'compiler' => true,
            'required' => array('gauch_blog_style','equals','2'),
        ),
        array(
			'id'    => 'gauch_search_page',
            'type'  => 'switch',
            'title' => esc_html__('فعال کردن برگه ها در صفحه نتایج جستجو', 'gauch-toolkit'),
        ),
        array(
			'id'    => 'hide_blog_banner',
            'type'  => 'switch',
            'title' => esc_html__('مخفی کردن بنر وبلاگ', 'gauch-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'    => 'hide_breadcrumb',
            'type'  => 'switch',
			'title' => esc_html__('مخفی کردن موقعیت وبلاگ', 'gauch-toolkit'),
            'default'   => '0',
            'required'      => array('hide_blog_banner','equals','0'),
        ),
        array(
            'id'       => 'blog_title',
            'type'     => 'text',
            'title'    => esc_html__( 'عنوان  برگه وبلاگ', 'gauch-toolkit' ),
            'required'      => array('hide_blog_banner','equals','0'),
        ),
        array(
            'id' => 'gauch_blog_layout',
            'type' => 'select',
            'options' => array(
                'container'                 => esc_html__( 'Container', 'gauch-toolkit' ),
                'container-fluid'           => esc_html__( 'Container Fluid', 'gauch-toolkit' ),
            ),
            'title'     => esc_html__( 'عرض وبلاگ', 'gauch-toolkit' ),
            'default'   => 'container',
        ),
        array(
            'id' => 'gauch_blog_single_layout',
            'type' => 'select',
            'options' => array(
                'container'                 => esc_html__( 'Container', 'gauch-toolkit' ),
                'container-fluid'           => esc_html__( 'Container Fluid', 'gauch-toolkit' ),
            ),
            'title'     => esc_html__( 'عرض وبلاگ تکی', 'gauch-toolkit' ),
            'default'   => 'container',
        ),
        array(
            'id' => 'gauch_blog_grid',
            'type' => 'select',
            'options' => array(
                'col-lg-12 col-md-12'       => esc_html__( 'یک ستونه', 'gauch-toolkit' ),
                'col-lg-6 col-md-6'         => esc_html__( 'دو ستونه', 'gauch-toolkit' ),
                'col-lg-4 col-md-6'         => esc_html__( 'سه ستونه', 'gauch-toolkit' ),
                'col-lg-3 col-md-6'         => esc_html__( 'چهار ستونه', 'gauch-toolkit' ),
            ),
            'title'     => esc_html__( 'نوع گرید وبلاگ', 'gauch-toolkit' ),
            'default'   => 'col-lg-12 col-md-12',
        ),
        array(
            'id' => 'gauch_blog_sidebar',
            'type' => 'select',
            'options' => array(
                'gauch_with_sidebar'              => 'با سایدبار',
                'gauch_without_sidebar'           => 'بدون سایدبار (عرض کامل)',
                'gauch_without_sidebar_center'    => 'بدون سایدبار (وسط)',
            ),
            'title'     => esc_html__( 'سایدبار وبلاگ', 'gauch-toolkit' ),
            'default'   => 'gauch_with_sidebar',
        ),
        array(
            'id' => 'gauch_single_blog_sidebar',
            'type' => 'select',
            'options' => array(
                'gauch_with_sidebar'              => 'با سایدبار',
                'gauch_without_sidebar'           => 'بدون سایدبار (عرض کامل)',
                'gauch_without_sidebar_center'    => 'بدون سایدبار (وسط)',
            ),
            'title'     => esc_html__( 'سایدبار وبلاگ تکی', 'gauch-toolkit' ),
            'default'   => 'gauch_with_sidebar',
        ),
        array(
            'title'     => esc_html__( 'ادامه مطلب', 'gauch-toolkit' ),
            'subtitle'  => esc_html__( 'تغیییر متن ادامه مطلب', 'gauch-toolkit' ),
            'id'        => 'read_more',
            'type'      => 'text',
            'default'   => esc_html__( 'ادامه مطلب', 'gauch-toolkit' )
        ),
        array(
			'title'     => esc_html__( 'متا پست', 'gauch-toolkit' ),
			'subtitle'  => esc_html__( 'نمایش / مخفی', 'gauch-toolkit' ),
			'id'        => 'is_post_meta',
			'type'      => 'switch',
            'on'        => esc_html__( 'نمایش', 'gauch-toolkit' ),
            'off'       => esc_html__( 'مخفی', 'gauch-toolkit' ),
            'default'   => '1',
        ),
    )
));

// Typography
Redux::setSection( $opt_name, array(
    'title' => esc_html__( 'فونت', 'gauch-toolkit' ),
    'desc' => esc_html__( 'فونت های خود را مدیریت کنید ', 'gauch-toolkit' ),
    'icon' => 'el-icon-fontsize',
    'customizer'    => false,
    'fields' => array(
        array(
            'id'            => 'opt-typography-body',
            'type'          => 'typography',
            'title'         => esc_html__( 'فونت بدنه', 'gauch-toolkit' ),
            'google'        => true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'   => true, // Select a backup non-google font in addition to a google font
            'all_styles'    => false, // Enable all Google Font style/weight variations to be added to the page
            'font-style'    => false,
            'font-weight'   => false,
            'font-size'     => false,
            'text-align'    => false,
            'color'         => false,
            'line-height'   => false,
            'output' => array(
                'body, .h1, .h2, .h3, .h4, .h5, .h6, h1, h2, h3, h4, h5, h6, p',
            ), // An array of CSS selectors to apply this font style to dynamically
            'default' => array(
                'font-family' => 'Overpass',
                'google' => true,
            ),
        ),
        array(
            'id'            => 'opt-typography-sec',
            'type'          => 'typography',
            'title'         => esc_html__( 'فونت ثانویه', 'gauch-toolkit' ),
            'google'        => true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'   => true, // Select a backup non-google font in addition to a google font
            'all_styles'    => false, // Enable all Google Font style/weight variations to be added to the page
            'font-style'    => false,
            'font-weight'   => false,
            'font-size'     => false,
            'text-align'    => false,
            'color'         => false,
            'line-height'   => false,
            'output' => array(
                '.section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6, .default-btn, .navbar-area .navbar .navbar-nav .nav-item a, .about-content h2, .services-details-content h1, .case-studies-details-header .content h1, .single-pricing-box .link-btn, .plans-compare-table .table > tfoot tr td .link-btn, .plans-compare-table .table > tfoot tr td .link-btn, .blog-details-header .content h1, .page-title-content h1, .single-footer-widget .newsletter-form form button, .team-section-title h2, .single-funfacts-box h3, .subscribe-inner h2, .subscribe-inner .newsletter-form button, .quote-content h2, .quote-content form button, .single-pricing-card .link-btn, .cryptocurrency-banner-content .banner-btn-list li .white-paper-btn, .pre-token-sale-ends-content .pre-token-sale-ends-btn li .buy-token-btn, .ico-landing-banner-content .banner-pre-token-sale-ends .pre-token-sale-ends-btn li .buy-token-btn',
            ), // An array of CSS selectors to apply this font style to dynamically
            'default' => array(
                'font-family' => 'Cabin',
                'google' => true,
            ),
        ),
    ),
) );

// Advanced Settings
Redux::setSection( $opt_name, array(
	'title'         => esc_html__('تنظیمات اضافه', 'gauch-toolkit'),
    'icon'          => 'el-icon-cogs',
    'customizer'    => false,
	'fields' => array(
		array(
			'id' => 'css_code',
			'type' => 'ace_editor',
			'title' => esc_html__('کد css', 'gauch-toolkit'),
			'desc' => esc_html__('e.g. .btn-primary{ background: #000; } Don\'t use &lt;style&gt; tags', 'gauch-toolkit'),
			'subtitle' => esc_html__('کد CSS خود را اینجا قرار دهید', 'gauch-toolkit'),
			'mode' => 'css',
			'theme' => 'monokai'
		),
		array(
			'id'        => 'js_code',
			'type'      => 'ace_editor',
			'title'     => esc_html__('کد JS', 'gauch-toolkit'),
			'desc'      => esc_html__('e.g. alert("Hello World!"); Don\'t use&lt;script&gt;tags', 'gauch-toolkit'),
			'subtitle'  => esc_html__('کدهای خود را اینجا وارد کنید', 'gauch-toolkit'),
			'mode'      => 'javascript',
			'theme'     => 'monokai'
		)
	)
) );


// Custom Post
Redux::setSection( $opt_name, array(
    'title'         => esc_html__( 'تنظیمات پست های سفارشی', 'gauch-toolkit' ),
    'id'            => 'gauch_custom_posts',
    'customizer'    => false,
    'icon'          => 'el el-file-edit',
    'desc'          => esc_html__( 'تنظیمات خدمات و پروژه های خود را مدیریت کنید', 'gauch-toolkit' ),
    'fields' => array(
        array(
			'id'    => 'hide_service_banner',
            'type'  => 'switch',
            'title' => esc_html__('مخفی کردن بنر خدمات تکی', 'gauch-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'    => 'hide_services_breadcrumb',
            'type'  => 'switch',
			'title' => esc_html__('مخفی کردن موقعیت  خدمات', 'gauch-toolkit'),
            'default'   => '0',
            'required'    => array('hide_service_banner','equals','0'),
        ),

        array(
            'id'       => 'service_permalink',
            'type'     => 'text',
            'title'    => esc_html__( 'لینک پیوند خدمات', 'gauch-toolkit' ),
            'default'  => esc_html__('service-post', 'gauch-toolkit'),
            'desc'     => 'پس از تغییر پیوند یکتا خدمات به تنظیمات پیوندهای یکتا بروید و دکمه ذخیره تغییرات را بزنید.',
        ),
        array(
			'id'    => 'hide_project_banner',
            'type'  => 'switch',
            'title' => esc_html__('مخفی کردن بنر پروژه تکی', 'gauch-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'    => 'hide_project_breadcrumb',
            'type'  => 'switch',
			'title' => esc_html__('مخفی کردن موقعیت پروژه ها', 'gauch-toolkit'),
            'default'   => '0',
            'required'    => array('hide_project_banner','equals','0'),
        ),
        array(
            'id'       => 'project_permalink',
            'type'     => 'text',
            'title'    => esc_html__( 'لینک پیوند پروژه ها', 'gauch-toolkit' ),
            'default'  => esc_html__('project-post', 'gauch-toolkit'),
            'desc'     => 'پس از تغییر پیوند یکتا خدمات به تنظیمات پیوندهای یکتا بروید و دکمه ذخیره تغییرات را بزنید.',
        ),
    )
));

// WooCommerce Product
Redux::setSection( $opt_name, array(
    'title' => esc_html__( 'ووکامرس', 'gauch-toolkit' ),
    'desc'  => esc_html__( 'تنظیمات مدیریت محصولات فروشگاه.', 'gauch-toolkit' ),
    'icon'  => 'el-icon-list-alt',
    'customizer'    => false,
    'fields' => array(
        array(
            'title'     => esc_html__( 'عنوان برگه', 'gauch-toolkit' ),
            'subtitle'  => esc_html__( 'عنوان صفحه فروشگاه را اینجا قرار دهید', 'gauch-toolkit' ),
            'desc'      => esc_html__( 'این متن در بنر صفحه فروشگاه نمایش داده می شود', 'gauch-toolkit' ),
            'id'        => 'shop_title',
            'type'      => 'text',
            'default'   => esc_html__( 'فروشگاه', 'gauch-toolkit' ),
        ),

        array(
            'id'    => 'enable_auto_complete',
            'type'  => 'select',
            'options' => array(
                'yes'       => 'بله',
                'no'        => 'خیر',
            ),
            'title' => esc_html__('تکمیل خودکار سفارشات ووکامرس را فعال کنید', 'gauch-toolkit'),
            'default'   => 'yes',
        ),
        array(
            'id'    => 'product_columns',
            'type'  => 'select',
            'options' => array(
                ''         => 'Default',
                '2'        => '2',
                '3'        => '3',
                '4'        => '4',
            ),
            'title' => esc_html__('ستون های محصول را انتخاب کنید', 'gauch-toolkit'),
            'default'   => '',
        ),
        array(
            'id'        => 'products_page_count',
            'desc'      => esc_html__( 'تعداد محصولات در هر صفحه در صفحات محصول.', 'gauch-toolkit' ),
            'type'      => 'text',
            'title'     => esc_html__( 'محصولات در هر صفحه', 'gauch-toolkit' ),
            'default'   => '6',
        ),
        array(
            'id'    => 'gauch_product_sidebar',
            'type'  => 'select',
            'options' => array(
                'gauch_product_no_sidebar'       => 'هیچ',
                'gauch_product_left_sidebar'     => 'سایدبار سمت چپ',
                'gauch_product_right_sidebar'    => 'سایدبار سمت راست',
            ),
            'title'     => esc_html__( 'سایدبار کناری محصول', 'gauch-toolkit' ),
            'default'   => 'gauch_product_no_sidebar',
        ),
        array(
            'id'    => 'gauch_related_product_count',
            'type'  => 'text',
            'title' => esc_html__( 'جزئیات محصول تعداد محصولات مرتبط', 'gauch-toolkit' ),
            'desc'  => esc_html__( 'e.g. 3', 'gauch-toolkit' ),
            'default' => '3',
        ),
        array(
            'id'        => 'enable_product_share',
            'type'      => 'switch',
            'title'     => esc_html__('اشتراک گذاری شبکه های اجتماعی را فعال کنید', 'gauch-toolkit'),
            'default'   => '0'
        ),

        array(
            'id'        => 'enable_social_share_title',
            'type'      => 'text',
            'title'     => esc_html__('متن اشتراک گذاری', 'gauch-toolkit'),
            'default'   => 'Share:',
            'required'  => array('enable_product_share','equals','1'),
        ),
        array(
            'id'        => 'enable_product_fb',
            'type'      => 'switch',
            'title'     => esc_html__('اشتراک با فیسبوک', 'gauch-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),

        array(
            'id'        => 'enable_product_tw',
            'type'      => 'switch',
            'title'     => esc_html__('اشتراک با توییتر', 'gauch-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),
        array(
            'id'        => 'enable_product_ld',
            'type'      => 'switch',
            'title'     => esc_html__('اشتراک با لینکیداین', 'gauch-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),
        array(
            'id'        => 'enable_product_wp',
            'type'      => 'switch',
            'title'     => esc_html__('اشتراک با واتس اپ', 'gauch-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),
        array(
            'id'        => 'enable_product_email',
            'type'      => 'switch',
            'title'     => esc_html__('اشتراک با ایمیل', 'gauch-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),
        array(
            'id'        => 'enable_product_cp',
            'type'      => 'switch',
            'title'     => esc_html__('کپی لینک', 'gauch-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),
    ),
));

// 404 Area
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( 'برگه 404', 'gauch-toolkit' ),
    'id'                => 'gauch_404',
    'customizer'        => false,
    'icon'              => 'el el-question-sign',
    'fields'            => array(
        array(
            'id'    => 'banner_title_not_found',
            'type'  => 'text',
            'title' => esc_html__('عنوان بنر 404', 'gauch-toolkit'),
        ),
        array(
            'id'       => 'not_found_image',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'صفحه 404', 'gauch-toolkit' ),
        ),
        array(
            'id'    => 'title_not_found',
            'type'  => 'text',
            'title' => esc_html__('عنوان 404', 'gauch-toolkit'),
        ),
        array(
            'id'       => 'content_not_found',
            'type'     => 'textarea',
            'title'    => esc_html__( 'متن محتوا 404', 'gauch-toolkit' ),
        ),
        array(
            'id'       => 'button_not_found',
            'type'     => 'text',
            'title'    => esc_html__( 'متن بازگشت به صفحه نخست', 'gauch-toolkit' ),
        ),
    )
));

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    // Custom function for the callback validation referenced above
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    // Custom function for the callback referenced above
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'gauch-toolkit' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'gauch-toolkit' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    // Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    // Filter hook for filtering the default value of any given field. Very useful in development mode.
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    // Removes the demo link and the notice of integrated demo from the redux-framework plugin
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }