<?php
/**
 * Demo Import with One Click Demo Importer Plugin
 */


if (! defined('ABSPATH')) {
    exit;
}

class Demo_Importer_OCDI
{

    public function __construct()
    {
        add_filter('pt-ocdi/import_files', array( $this, 'demo_config' ));
        add_filter('pt-ocdi/after_import', array( $this, 'after_import' ));
        add_filter('pt-ocdi/disable_pt_branding', '__return_true');
    }

    public function demo_config()
    {

        $demos_array = array(
            'demo1' => array(
                'title' => __('Home Demo - 1', 'gauch-toolkit'),
                'page' => __('Home', 'gauch-toolkit'),
                'screenshot' => 'https://preview.hibotheme.com/gauch-wp/assets/img/demos/home1.jpg',
                'preview_link' => 'https://themes.hibotheme.com/gauch/',
            ),
            'demo2' => array(
                'title' => __('Home Demo - 2', 'gauch-toolkit'),
                'page' => __('Home 2', 'gauch-toolkit'),
                'screenshot' => 'https://preview.hibotheme.com/gauch-wp/assets/img/demos/home5.jpg',
                'preview_link' => 'https://themes.hibotheme.com/gauch/home-2',
            ),
            'demo3' => array(
                'title' => __('Home Demo - 3', 'gauch-toolkit'),
                'page' => __('Home 3', 'gauch-toolkit'),
                'screenshot' => 'https://preview.hibotheme.com/gauch-wp/assets/img/demos/home3.jpg',
                'preview_link' => 'https://themes.hibotheme.com/gauch/home-3',
            ),
            'demo4' => array(
                'title' => __('Home Demo - 4', 'gauch-toolkit'),
                'page' => __('Home 4', 'gauch-toolkit'),
                'screenshot' => 'https://preview.hibotheme.com/gauch-wp/assets/img/demos/home4.jpg',
                'preview_link' => 'https://themes.hibotheme.com/gauch/home-4',
            ),
            'demo5' => array(
                'title' => __('Home Demo - 5', 'gauch-toolkit'),
                'page' => __('Home 5', 'gauch-toolkit'),
                'screenshot' => 'https://preview.hibotheme.com/gauch-wp/assets/img/demos/home5.jpg',
                'preview_link' => 'https://themes.hibotheme.com/gauch/home-5',
            ),
            'demo6' => array(
                'title' => __('Home Demo - 6', 'gauch-toolkit'),
                'page' => __('Home 6', 'gauch-toolkit'),
                'screenshot' => 'https://preview.hibotheme.com/gauch-wp/assets/img/demos/home6.jpg',
                'preview_link' => 'https://themes.hibotheme.com/gauch/home-6',
            ),
        );

        $config = array();
        $import_path  = trailingslashit(get_template_directory()) . 'lib/sample-data/';
        $redux_option = 'gauch_opt';

        foreach ($demos_array as $key => $demo) {
            $config[] = array(
                'import_file_id'               => $key,
                'import_page_name'             => $demo['page'],
                'import_file_name'             => $demo['title'],
                'local_import_file'            => $import_path . 'contents.xml',
                'local_import_widget_file'     => $import_path . 'widgets.wie',
                'local_import_customizer_file' => $import_path . 'customizer.dat',
                'local_import_redux'           => array(
                    array(
                        'file_path'   => $import_path . 'options.json',
                        'option_name' => $redux_option,
                    ),
                ),
                'import_preview_image_url'   => $demo['screenshot'],
                'preview_url'                => $demo['preview_link'],
            );
        }

        return $config;
    }

    public function after_import($selected_import)
    {
        $this->assign_menu();
        $this->assign_frontpage($selected_import);
        $this->assign_woocommerce_pages();
        $this->update_permalinks();
    }

    private function assign_menu()
    {
        $primary  = get_term_by('name', 'Primary Menu', 'nav_menu');

        set_theme_mod('nav_menu_locations', array(
            'primary'  => $primary->term_id,
        ));
    }

    private function assign_frontpage($selected_import)
    {
        $blog_page  = get_page_by_title('Blog');
        $front_page = get_page_by_title($selected_import['import_page_name']);

        update_option('show_on_front', 'page');
        update_option('page_on_front', $front_page->ID);
        update_option('page_for_posts', $blog_page->ID);
    }

    private function assign_woocommerce_pages()
    {
        $shop     = get_page_by_title('Shop');
        $cart     = get_page_by_title('Cart');
        $checkout = get_page_by_title('Checkout');
        $account  = get_page_by_title('My Account');

        update_option('woocommerce_shop_page_id', $shop->ID);
        update_option('woocommerce_cart_page_id', $cart->ID);
        update_option('woocommerce_checkout_page_id', $checkout->ID);
        update_option('woocommerce_myaccount_page_id', $account->ID);
    }

    private function update_permalinks()
    {
        update_option('permalink_structure', '/%postname%/');
    }
}

new Demo_Importer_OCDI;
