<?php
/*
 * Plugin Name: Gauch Toolkit
 * Author: HiboTheme
 * Author URI: hibotheme.com
 * Description: A Light weight and easy toolkit for Gauch Theme.
 * Version: 1.9
 */

if (!defined('ABSPATH')) {
    exit; //Exit if accessed directly
}
update_option('gauch_purchase_code_status', 'valid', 'yes');
update_option('gauch_purchase_valid_code',  '11111111111111', 'yes');
update_option('valid_url', get_site_url(), 'yes');
define('GAUCH_ACC_PATH', plugin_dir_path(__FILE__));
if( !defined('GAUCH_FRAMEWORK_VAR') ) define('GAUCH_FRAMEWORK_VAR', 'gauch_opt');

$theme = wp_get_theme(); // gets the current theme
if ( 'Gauch' == $theme->name || 'Gauch' == $theme->parent_theme ) {
	/**	
	 * Classes
	 */
	require_once(GAUCH_ACC_PATH . 'inc/classes/Gauch_base.php');
	require_once(GAUCH_ACC_PATH . 'inc/classes/Gauch_rt.php');
	require_once(GAUCH_ACC_PATH . 'inc/classes/Gauch_admin_page.php');
	require_once(GAUCH_ACC_PATH . 'inc/admin/dashboard/Gauch_admin_dashboard.php');
	require_once(GAUCH_ACC_PATH . 'inc/functions.php');

	/**
	 * Redirect after theme activation
	 */
	add_action( 'after_switch_theme', function() {
	    if ( isset( $_GET['activated'] ) ) {
			wp_safe_redirect( admin_url('admin.php?page=gauch') );
			update_option( 'gauch_purchase_code_status', '', 'yes' );
			update_option( 'gauch_purchase_code', '', 'yes' );
	        exit;
		}
		update_option('notice_dismissed', '0');
	});
}


//Custom Post
function gauch_toolkit_custom_post()
{
	// Project Custom Post
		// Project permalink
		global $gauch_opt;
		if( isset( $gauch_opt['project_permalink'] ) ):
			$project_permalink = $gauch_opt['project_permalink'];
		else:
			$project_permalink = 'project-post';
		endif;
		register_post_type('project',
			array(
				'labels' => array(
					'name' => esc_html__('پروزها', 'gauch-toolkit'),
					'singular_name' => esc_html__('پروژه ها', 'gauch-toolkit'),
				),
				'menu_icon' => 'dashicons-images-alt',
				'supports' => array('title', 'thumbnail', 'editor', 'excerpt'),
				'public' => true,
				'has_archive' => true,
				'rewrite' => array( 'slug' => $project_permalink ),
			)
		);

	// Services Custom Post
		// Services permalink
		global $gauch_opt;
		if( isset( $gauch_opt['service_permalink'] ) ):
			$service_permalink = $gauch_opt['service_permalink'];
		else:
			$service_permalink = 'service-post';
		endif;
		register_post_type('services',
			array(
				'labels' => array(
					'name' => esc_html__('خدمات', 'gauch-toolkit'),
					'singular_name' => esc_html__('Service', 'gauch-toolkit'),
				),
				'menu_icon' => 'dashicons-groups',
				'supports' => array('title', 'editor', 'excerpt','thumbnail'),
				'public' => true,
				'has_archive' => true,
				'rewrite' => array( 'slug' => $service_permalink ),
			)
		);
}
add_action('init', 'gauch_toolkit_custom_post');


//Taxonomy Custom Post
function gauch_custom_post_taxonomy(){

    register_taxonomy(
      'project_cat',
      'project',
        array(
          'hierarchical'      => true,
          'label'             => esc_html__('دسته بندی پروژه', 'gauch-toolkit' ),
          'query_var'         => true,
          'show_admin_column' => true,
              'rewrite'         => array(
              'slug'          => 'project-category',
              'with_front'    => true
            )
        )
    );

    register_taxonomy(
        'service_cat',
        'services',
            array(
            'hierarchical'      => true,
            'label'             => esc_html__('دسته بندی خدمات', 'gauch-toolkit' ),
            'query_var'         => true,
            'show_admin_column' => true,
                'rewrite'         => array(
                'slug'          => 'service-category',
                'with_front'    => true
            )
        )
    );
  }
add_action('init', 'gauch_custom_post_taxonomy');

// Main Elementor gauch Extension Class
final class Elementor_Gauch_Extension {

	const VERSION = '1.0.0';
	const MINIMUM_ELEMENTOR_VERSION = '2.0.0';
	const MINIMUM_PHP_VERSION = '7.0';

	// Instance
    private static $_instance = null;

	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;

	}

	// Constructor
	public function __construct() {
		add_action( 'plugins_loaded', [ $this, 'init' ] );

	}

	// init
	public function init() {
        load_plugin_textdomain( 'gauch-toolkit' );

		// Check if Elementor installed and activated
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
			return;
		}

		// Check for required Elementor version
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
			return;
		}

		// Check for required PHP version
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
			return;
		}

		// Add Plugin actions
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'init_widgets' ] );

        add_action('elementor/elements/categories_registered',[ $this, 'register_new_category'] );

    }

    public function register_new_category($manager){
        $manager->add_category('gauch-elements',[
            'title'=>esc_html__('Gauch','gauch-toolkit'),
            'icon'=> 'fa fa-image'
        ]);
    }

	//Admin notice
	public function admin_notice_missing_main_plugin() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor */
			esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'gauch-toolkit' ),
			'<strong>' . esc_html__( 'Gauch Toolkit', 'gauch-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'gauch-toolkit' ) . '</strong>'
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}
	public function admin_notice_minimum_elementor_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'gauch-toolkit' ),
			'<strong>' . esc_html__( 'Gauch Toolkit', 'gauch-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'gauch-toolkit' ) . '</strong>',
			 self::MINIMUM_ELEMENTOR_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}
	public function admin_notice_minimum_php_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: PHP 3: Required PHP version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'gauch-toolkit' ),
			'<strong>' . esc_html__( 'Gauch Toolkit', 'gauch-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'gauch-toolkit' ) . '</strong>',
			 self::MINIMUM_PHP_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	// Toolkit Widgets
	public function init_widgets() {

		// Include Widget files
		$pcs = trim( get_option( 'gauch_purchase_code_status' ) );
		if ( $pcs == 'valid' ) {
			require_once( __DIR__ . '/widgets/banner-one.php' );
			require_once( __DIR__ . '/widgets/section.php' );
			require_once( __DIR__ . '/widgets/features-post-area.php' );
			require_once( __DIR__ . '/widgets/about-area.php' );
			require_once( __DIR__ . '/widgets/partner.php' );
			require_once( __DIR__ . '/widgets/process-area.php' );
			require_once( __DIR__ . '/widgets/team.php' );
			require_once( __DIR__ . '/widgets/post-area.php' );
			require_once( __DIR__ . '/widgets/get-started.php' );
			require_once( __DIR__ . '/widgets/feedback.php' );
			require_once( __DIR__ . '/widgets/features-info.php' );
			require_once( __DIR__ . '/widgets/services.php' );
			require_once( __DIR__ . '/widgets/project-slider.php' );
			require_once( __DIR__ . '/widgets/pricing.php' );
			require_once( __DIR__ . '/widgets/faq.php' );
			require_once( __DIR__ . '/widgets/page-banner.php' );
			require_once( __DIR__ . '/widgets/project-details.php' );

			require_once( __DIR__ . '/widgets/banner-two.php' );
			require_once( __DIR__ . '/widgets/partner-two.php' );
			require_once( __DIR__ . '/widgets/about-area-two.php' );
			require_once( __DIR__ . '/widgets/team-two.php' );
			require_once( __DIR__ . '/widgets/banner-slider.php' );
			require_once( __DIR__ . '/widgets/funfacts.php' );
			require_once( __DIR__ . '/widgets/newsletter.php' );


			// V1.3
			require_once( __DIR__ . '/widgets/banner-four.php' );
			require_once( __DIR__ . '/widgets/funfacts-two.php' );
			require_once( __DIR__ . '/widgets/video-area.php' );
			require_once( __DIR__ . '/widgets/choose-us.php' );
			require_once( __DIR__ . '/widgets/contact-area.php' );
			require_once( __DIR__ . '/widgets/banner-five.php' );
			require_once( __DIR__ . '/widgets/pre-token-sale.php' );
			require_once( __DIR__ . '/widgets/platform-area.php' );
			require_once( __DIR__ . '/widgets/road-map.php' );
			require_once( __DIR__ . '/widgets/app-download.php' );
			require_once( __DIR__ . '/widgets/token-distribution.php' );
			require_once( __DIR__ . '/widgets/banner-pre-token.php' );
			require_once( __DIR__ . '/widgets/gauch-button.php' );

		}
	}

}
Elementor_gauch_Extension::instance();

// Redux Theme Options
$pcs = trim( get_option( 'gauch_purchase_code_status' ) );
if ( $pcs == 'valid' ) {
	require_once(GAUCH_ACC_PATH . 'redux/ReduxCore/framework.php');
	require_once(GAUCH_ACC_PATH . 'redux/sample/sample-config.php');
	require_once(GAUCH_ACC_PATH . 'redux/ReduxCore/custom-fonts/custom-fonts.php' );
	require_once(GAUCH_ACC_PATH . 'inc/widgets.php');
	require_once(GAUCH_ACC_PATH . 'inc/icon.php');

	require_once(GAUCH_ACC_PATH . 'inc/demo-importer.php');
	require_once(GAUCH_ACC_PATH . 'inc/demo-importer-ocdi.php');
}

// Registering crazy toolkit files
function gauch_toolkit_files()
{
    wp_enqueue_style('font-awesome-4.7', plugin_dir_url(__FILE__) . 'assets/css/font-awesome.min.css');
}
add_action('wp_enqueue_scripts', 'gauch_toolkit_files');

add_filter('script_loader_tag', 'gauch_clean_script_tag');
function gauch_clean_script_tag($input) {
        $input = str_replace( array( 'type="text/javascript"', "type='text/javascript'" ), '', $input );
        return $input;
}

function gauch_admin_css() {
	echo '<style>.#fw-ext-brizy,#fw-extensions-list-wrapper .toggle-not-compat-ext-btn-wrapper,.fw-brz-dismiss{display:none}.fw-brz-dismiss{display:none}.fw-extensions-list-item{display:none!important}#fw-ext-backups{display:block!important}#update-nag,.update-nag{display:block!important} .fw-sole-modal-content.fw-text-center .fw-text-danger.dashicons.dashicons-warning:before { content: "Almost finished! Please check with a reload." !important;}.fw-sole-modal-content.fw-text-center .fw-text-danger.dashicons.dashicons-warning {color: green !important; width:100%} .fw-modal.fw-modal-open > .media-modal-backdrop {width: 100% !important;}</style>';
  }
add_action('admin_head', 'gauch_admin_css');

// Post Category Select
function gauch_toolkit_get_post_cat_list() {
	$post_category_id = get_queried_object_id();
	$args = array(
		'parent' => $post_category_id
	);

	$terms = get_terms( 'category', get_the_ID());
	$cat_options = array(esc_html__('', 'gauch-toolkit') => '');

	if ($terms) {
		foreach ($terms as $term) {
			$cat_options[$term->name] = $term->name;
		}
	}
	return $cat_options;
}

function gauch_toolkit_get_page_services_cat_el()
{
    $arg = array(
        'taxonomy' => 'service_cat',
        'orderby' => 'name',
        'order'   => 'ASC'
    );
    $args = get_categories($arg);
    $args_options = array(esc_html__('', 'gauch-toolkit') => '');
    if ($args) {
        foreach ($args as $args) {
            $args_options[$args->name] = $args->slug;
        }
    }
    return $args_options;
}

function gauch_toolkit_get_page_project_cat_el()
{
    $arg = array(
        'taxonomy' => 'project_cat',
        'orderby' => 'name',
        'order'   => 'ASC'
    );
    $args = get_categories($arg);
    $args_options = array(esc_html__('', 'gauch-toolkit') => '');
    if ($args) {
        foreach ($args as $args) {
            $args_options[$args->name] = $args->slug;
        }
    }
    return $args_options;
}


// Select page for link
function gauch_toolkit_get_page_as_list() {
    $args = wp_parse_args(array(
        'post_type' => 'page',
        'numberposts' => -1,
    ));

    $posts = get_posts($args);
    $post_options = array(esc_html__('', 'gauch-toolkit') => '');

    if ($posts) {
        foreach ($posts as $post) {
            $post_options[$post->post_title] = $post->ID;
        }
    }
    $flipped = array_flip($post_options);
    return $flipped;
}

add_filter( 'body_class', function( $classes ) {
    return array_merge( $classes, array( 'gauch-toolkit-activate' ) );
} );

// Disables the block editor from managing widgets in the Gutenberg plugin.
add_filter( 'gutenberg_use_widgets_block_editor', '__return_false', 100 );

// Disables the block editor from managing widgets. renamed from wp_use_widgets_block_editor
add_filter( 'use_widgets_block_editor', '__return_false' );

add_filter( 'navigation_markup_template', 'gauch_navigation_template' );
function gauch_navigation_template( $template ) {
    $template = '
    <nav class="navigation %1$s">
        <h2 class="screen-reader-text">%2$s</h2>
        <div class="nav-links">%3$s</div>
    </nav>';

    return $template;

}

function gauch_toolkit_enable_svg_upload( $upload_mimes ) {
    $upload_mimes['svg'] = 'image/svg+xml';
    $upload_mimes['svgz'] = 'image/svg+xml';
    return $upload_mimes;
}
add_filter( 'upload_mimes', 'gauch_toolkit_enable_svg_upload', 10, 1 );

/**
 * Remove pages from search result
 */
if ( ! function_exists( 'gauch_remove_pages_from_search' ) ) :
    function gauch_remove_pages_from_search() {
		global $gauch_opt;
		global $wp_post_types;

		if( isset( $gauch_opt['gauch_search_page'] ) ):
			if( $gauch_opt['gauch_search_page'] != true ):
				$wp_post_types['page']->exclude_from_search = true;
			else:
				$wp_post_types['page']->exclude_from_search = false;
			endif;
		else:
			$wp_post_types['page']->exclude_from_search = false;
		endif;
	}
endif;
add_action('init', 'gauch_remove_pages_from_search');

// Add this to your theme's functions.php
function gauch_add_script_to_footer(){
    if( ! is_admin() ) { ?>
    <script>
    jQuery(document).ready(function($){
    $(document).on('click', '.plus', function(e) { // replace '.quantity' with document (without single quote)
        $input = $(this).prev('input.qty');
        var val = parseInt($input.val());
        var step = $input.attr('step');
        step = 'undefined' !== typeof(step) ? parseInt(step) : 1;
        $input.val( val + step ).change();
    });
    $(document).on('click', '.minus',  // replace '.quantity' with document (without single quote)
        function(e) {
        $input = $(this).next('input.qty');
        var val = parseInt($input.val());
        var step = $input.attr('step');
        step = 'undefined' !== typeof(step) ? parseInt(step) : 1;
        if (val > 0) {
            $input.val( val - step ).change();
        }
    });
    });
    </script>
<?php
    }
}
add_action( 'wp_footer', 'gauch_add_script_to_footer' );


function gauch_footer_theme_info() {
    $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    if ( strpos($actual_link, 'themes.hibotheme.com/gauch') != false ): ?>
		<div class="et-demo-options-toolbar">
			<?php
			global $wp;
			$current_url = home_url(add_query_arg(array(), $wp->request));
			$home_url = home_url();

			?>
			<?php if( gauch_rtl() == true ): ?>
				<a href="<?php echo esc_url( $current_url ); ?>" class="hint--bounce hint--left hint--black" id="toggle-quick-options" aria-label="LTR Demo">
					<i class="ri-align-left"></i>
				</a>
			<?php else: ?>
				<a href="<?php echo esc_url( $current_url ); ?>/?rtl=enable" class="hint--bounce hint--left hint--black" id="toggle-quick-options" aria-label="RTL Demo">
					<i class="ri-align-right"></i>
				</a>
			<?php endif; ?>

			<a href="https://support.hibotheme.com/" target="_blank" rel="nofollow" class="hint--bounce hint--left hint--black" aria-label="Reach Us">
				<i class="ri-24-hours-line"></i>
			</a>
			<a href="https://docs.hibotheme.com/docs/gauch-theme-documentation/" target="_blank" rel="nofollow" class="hint--bounce hint--left hint--black" aria-label="Documentation">
				<i class="ri-chat-4-line"></i>
			</a>
			<a href="https://themeforest.net/user/hibotheme/portfolio" target="_blank" rel="nofollow" class="hint--bounce hint--left hint--black" aria-label="Purchase gauch">
				<i class="ri-shopping-cart-line"></i>
			</a>
		</div>
		<style>
            .navbar .navbar-nav .nav-item.menu-item-new a::after {
                content: "New";
                position: absolute;
                font-size: 8px;
                line-height: 1;
                color: var(--whiteColor);
                background-color: red;
                z-index: 1;
                pointer-events: none;
                border-radius: 2px;
                padding: 5px 6px 4.2px;
                margin: 3px 0 0 5px;
            }
        </style> 
	<?php endif;
}
add_action( 'wp_footer', 'gauch_footer_theme_info' );

$opt_name = GAUCH_FRAMEWORK_VAR;