<?php
/**
 * Description tab
 *
 * This template can be overridden by copying it to gauch/woocommerce/single-product/tabs/description.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @package 	WooCommerce/Templates
 * @version   7.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post;

$heading = esc_html( apply_filters( 'woocommerce_product_description_heading', __( 'مشخصات', 'gauch' ) ) );

?>

<?php if ( $heading ) : ?>
  <h3><?php echo esc_html($heading, 'gauch'); ?></h3>
<?php endif; ?>

<?php the_content(); ?>
